<style>
.upload-area {
    /* width: 70%;
    height: 200px;*/
    border: 2px solid lightgray;
    border-radius: 3px;
    margin: 0 auto;
    /* margin-top: 100px;*/
    text-align: center;
    overflow: auto;
    height: 100px;
}

.upload-area:hover {
    cursor: pointer;
}

.upload-area h1 {
    text-align: center;
    font-weight: normal;
    font-family: sans-serif;
    line-height: 50px;
    color: black;
    background: #9aace76b;
}

#be_upload {
    display: none;
}
</style>
<div class="row align-items-center">
    <div class="col-sm-6">
        <div class="page-title-box">
            <h4 class="font-size-18">Upload Certificate</h4>
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="javascript: void(0);">Settings</a></li>
                <li class="breadcrumb-item active"> Upload Certificate</li>
            </ol>
        </div>
    </div>
</div>

<?php
if ($this->session->flashdata('alert_success')) {
    ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">×</span>
    </button>
    <strong>Success!</strong> <?php echo $this->session->flashdata('alert_success'); ?>
</div>
<?php
}

if ($this->session->flashdata('alert_danger')) {
    ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">×</span>
    </button>
    <strong>Success!</strong> <?php echo $this->session->flashdata('alert_danger'); ?>
</div>
<?php
}

if ($this->session->flashdata('alert_warning')) {
    ?>
<div class="alert alert-warning alert-dismissible fade show" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">×</span>
    </button>
    <strong>Success!</strong> <?php echo $this->session->flashdata('alert_warning'); ?>
</div>
<?php
}
if (validation_errors()) {
    ?>
<!-- <div class="alert alert-danger alert-dismissible fade show" role="alert">
<button type="button" class="close" data-dismiss="alert" aria-label="Close">
<span aria-hidden="true">×</span>
</button>
<?php echo validation_errors(); ?>
</div> -->
<?php
}
?>

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo $actionUrl; ?>" method="post" enctype="multipart/form-data">
                    <h3 id="Title"></h3>
                    <div class="row">
                    <div class="col-md-2"></div>
                        <div class="col-md-6 form-group">
                            <label>Financial Year</label><span class="mandatory">*</span>
                            <select name="financial_year" id="financial_year" class="form-control" required>
                                <option value="">Select Status</option>
                                <?php foreach($records as $row){ ?>
                                <option value="<?php echo $row->year; ?>"><?php echo $row->year; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-12 form-group">
                        <input type="file" id="be_upload" multiple name="be_upload[]" class="form-control">
                        <!-- Drag and Drop container-->
                        <div class="upload-area" id="uploadfile">
                            <h3 id="drg_txt">Drag and Drop file here<br />Or<br />Click to select file</h3>
                        </div>
                    </div>



                    <div class="form-group mb-0">
                        <div>
                            <button name="submit" type="submit" class="btn btn-primary waves-effect waves-light mr-1">
                                Submit
                            </button>
                            <button type="reset" class="btn btn-secondary waves-effect"
                                onclick="window.location.reload()">
                                Cancel
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>




<script>
function editYear(id) {
    $.ajax({
        url: "<?php echo site_url() ?>/settingsController/getYearData/" + id,
        method: "GET",
        success: function(result) {
            var data = JSON.parse(result);
            if (data.length > 0) {
                $('#year_id').val(data[0].id);
                $('#statuss').select2("val", data[0].status);
                $('#year').val(data[0].year);
                $('#Title').text("Edit Financial year");
                document.documentElement.scrollTop = 0;
            }


        },
        error: function(error) {
            console.log(error);
        }
    });
}

function deleteYear(id) {
    if (confirm("If you want to delete?") === true) {
        $.ajax({
            url: "<?php echo site_url() ?>/settingsController/deleteYear/" + id,
            method: "GET",
            success: function(result) {
                if (result > 0) {
                    window.location.reload();
                }
            },
            error: function(error) {
                console.log(error);
            }
        });
    }
}

$('#dmstable').DataTable();

function get_region(zone_id) {
    $.ajax({
        url: "<?php echo site_url() ?>/users/manage_dealers/get_region",
        method: "POST",
        type: "ajax",
        data: {
            zone_id: zone_id
        },
        success: function(result) {
            var data = JSON.parse(result);
            $('#region')
                .find('option')
                .remove();
            $.each(data, function(key, value) {
                var option = '<option value="' + value.region_id + '">' + value.region_name +
                    '</option>';
                $('#region').append(option);
            });
        },
        error: function(error) {
            console.log(error);
        }
    });
}

// preventing page from redirecting
$("html").on("dragover", function(e) {
    e.preventDefault();
    e.stopPropagation();
    $("#drg_txt").text("Drag here");
});

$("html").on("drop", function(e) {
    e.preventDefault();
    e.stopPropagation();
});

// Drag enter
$('.upload-area').on('dragenter', function(e) {
    e.stopPropagation();
    e.preventDefault();
    $("#drg_txt").text("Drop");
});

// Drag over
$('.upload-area').on('dragover', function(e) {
    e.stopPropagation();
    e.preventDefault();
    $("#drg_txt").text("Drop");
});

// Drop
$('.upload-area').on('drop', function(e) {
    e.stopPropagation();
    e.preventDefault();
    var fd = new FormData();
    var year = $('#financial_year').val();
    if (year.length > 0) {
        $("#drg_txt").text("Uploading...");
        var file = e.originalEvent.dataTransfer.files;

        //console.log(files_list);  
        for (var i = 0; i < file.length; i++) {
            fd.append('pdf_files[]', file[i]);
        }
        fd.append("year", year);
        uploadData(fd);
    } else {
        alert('Please Choose year');
    }
});

// Open file selector on div click
$("#uploadfile").click(function() {
    $("#be_upload").click();
});
$("#be_upload").change(function() {

    var fileInput = document.getElementById('be_upload');
    var filePath = fileInput.value;
    // Allowing file type
    var allowedExtensions = /(\.pdf)$/i;

    if (!allowedExtensions.exec(filePath)) {
        alert("File Format Not Support");
        fileInput.value = '';
        $('#be_upload').val('');
        $("#drg_txt").text("Drag and Drop file here Or Click to select file");
        return false;
    }
    var year = $('#financial_year').val();
    if (year.length > 0) {
        var fd = new FormData();
        var files = $('#be_upload')[0].files;
        for (var i = 0; i < files.length; i++) {
            fd.append("pdf_files[]", document.getElementById('be_upload').files[i]);
        }

        fd.append("year", year);

        uploadData(fd);
    } else {
        alert('Please Choose year');
    }
});

// Sending AJAX request and upload file
function uploadData(formdata) {
    $('#progress').show();
    $.ajax({
        url: "<?php echo site_url() ?>settingsController/store10BE",
        type: 'post',
        data: formdata,
        contentType: false,
        processData: false,
        dataType: 'json',
        success: function(response) {
            if (response) {
                $('#progress').hide();
                setTimeout(function() {
                    //window.location = "<?php echo site_url() ?>home/aid_pdf";
                }, 1000);
                //console.log(response);

            }

        }
    });
}
</script>