<?php
defined('BASEPATH') or exit('No direct script access allowed');

class EmailTemplateController extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->is_logged_in();
        //($this->verify_role('seller'))?'':redirect('login');
    }
    public function index()
    {
        $view_data['records'] = $this->mcommon->records_all('mail_template');
        //    print_r($view_data['datatable']);exit();
        $data = array(
            'title' => 'Email Template',
            'page' => 'Email Template',
            'content' => $this->load->view('emailTemplateMaster/viewEmail', $view_data, true),
        );
        $this->load->view('base/main_template', $data);
    }
    public function emailTemplateAdd($id='')
    {


        if (isset($_POST["submit"])) {

            $this->form_validation->set_rules('templateFor', 'template For', 'required');
            $this->form_validation->set_rules('subject', 'Subject', 'required');
            $this->form_validation->set_rules('email_content', 'email Content', 'required');
          
            
            if ($this->form_validation->run() == true) {
            $input = $this->input->post();


           if ($_FILES['attachment']['name']) {
            if (!is_dir('./attachments/mailTemplate/')) {
                mkdir('./attachments/mailTemplate/', 0777, true);
            }
            $upload_path = 'attachments/mailTemplate/';
            $upload_path_table = base_url() . 'attachments/mailTemplate/';
            $banner = $_FILES['attachment']['name'];
            $expbanner = explode('.', $banner);
            $bannerexptype = $expbanner[1];
            $date = date('m/d/Yh:i:sa', time());
            $rand = rand(10000, 99999);
            $encname = $date . $rand;
            $bannername = md5($encname) . '.' . $bannerexptype;
            $bannerpath = $upload_path . $bannername;
            move_uploaded_file($_FILES["attachment"]["tmp_name"], $bannerpath);
            $attachment = $upload_path_table . $bannername;
               
        } else {

            $attachment = isset($input['oldAttachment'])  ? $input['oldattAchment'] : '' ;

        }

            $insert_array = array(
                'template_for' => $input['templateFor'],
                'email_subject' => $input['subject'],
                'email_content' => $input['email_content'],
                'attachment' => $attachment,
                'status' =>1,
            );


            if($input['id']){
                $update = $this->mcommon->common_edit('mail_template', $insert_array, array('id' => $input['id']));
                $this->session->set_flashdata('alert_success', 'Email Template Updated Successfully');

            }else{
                $insert = $this->mcommon->common_insert('mail_template', $insert_array);
                $this->session->set_flashdata('alert_success', 'Email Template Added Successfully');

            }
            redirect('EmailTemplateController');

        }
            
        // }
          
        }

        if($id){
            $view_data['records'] = $this->mcommon->specific_row('mail_template', array('id' => $id));

            // echo '<pre>';  print_r($view_data['records'] );exit();

            $data = array(
                'title' => 'Email Template',
                'page' => 'Email Template',
                'content' => $this->load->view('emailTemplateMaster/addEmail', $view_data, true),
            );
        }else{
            $data = array(
                'title' => 'Email Template',
                'page' => 'Email Template',
                'content' => $this->load->view('emailTemplateMaster/addEmail', " ", true),
            );
        }


        $this->load->view('base/main_template', $data);
    }

    public function addOrEdit($id)
    {
       
        if (isset($_POST["submit"])) {
            $pincode = $this->input->post('pincode');
         
            $update_array = array(
                'pincode' => $pincode
            );
            $update = $this->mcommon->common_edit('pincode', $update_array, array('id' => $id));
            if ($update) {
                $this->session->set_flashdata('alert_success', 'pincode edited successfully');
            }
            $this->index();
        } else  {
          
            $view_data['record'] = $this->mcommon->specific_row('pincode', array('id' => $id));
            $data = array(
                'title' => 'Delivery Pincode',
                'page' => 'Delivery Pincode',
                'content' => $this->load->view('pincode/edit_pincode', $view_data, true),
            );
            $this->load->view('base/main_template', $data);
        }
    }

    public function statusUpdate($id)
    {
        $status = $this->mcommon->specific_row_value('pincode', array('id' => $id), 'status');
        $change_status = ($status == 1) ? 0 : 1;
        $updateArray = array(
            'status' => $change_status
        );
        $update = $this->mcommon->common_edit('pincode', $updateArray, array('id' => $id));
        if ($update > 0) {
            $this->session->set_flashdata('alert_success', 'Status changed successfully!');
            $this->index();
        } else {
            $this->session->set_flashdata('alert_danger', 'Something went wrong. Please try again later');
            $this->index();
        }
    }

    public function delete($id)
    {
        $delete = $this->db->delete('pincode', array('id' => $id));
        if ($delete) {
            echo json_encode(1);
            $this->session->set_flashdata('alert_danger', 'pincode deleted successfully');
        }
    }
}
