<?php
defined('BASEPATH') or exit('No direct script access allowed');

class SettingsController extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->is_logged_in();
     
       // ($this->verify_min_level(1)) ? '' : redirect('login');
       ($this->auth_level!=5) ? '' : redirect('logout');
    }

    public function index(){
        $view_data['actionUrl'] = base_url() . 'settingsController/addEditFinancialYear';
        $view_data['records'] = $this->mcommon->records_all('financial_year');
       // print_r($view_data['datatable']);exit();
        $data = array(
            'title' => 'Finanical year',
            'page' => 'Financial Year',
            'content' => $this->load->view('settings/financial_year', $view_data, true),
        );
        $this->load->view('base/main_template', $data);
    }

    public function trustSettings(){
        $view_data['actionUrl'] = base_url() . 'settingsController/addEditFinancialYear';
        $view_data['records'] = $this->mcommon->records_all('financial_year');
       // print_r($view_data['datatable']);exit();
        $data = array(
            'title' => 'Trust Settings',
            'page' => 'Trust Settings',
            'content' => $this->load->view('settings/trust_settings', $view_data, true),
        );
        $this->load->view('base/main_template', $data);
    }

    public function addEditFinancialYear(){
       
         $year = $this->input->post('year');
         $status = $this->input->post('status');
         $id = $this->input->post('id');
         $this->form_validation->set_rules('year', 'Financial Year', 'required');
		 $this->form_validation->set_rules('status', 'Status', 'required');

			//check is the validation returns no error
            if ($this->form_validation->run() == TRUE)
            {
                if($id=='') {
                    $insert_array = array(            		
                        'year'=>$year,
                        'status'=>$status
                   );            
                    $insert = $this->mcommon->common_insert('financial_year',$insert_array);
                    if($status==1){
                        $this->mcommon->common_edit('financial_year',array('status'=>'0'),array('id !='=>$insert));
                    }
                    if($insert > '0')
                    {
                        $this->session->set_flashdata('alert_success', 'Financial added successfully!');
                        redirect("/settingsController");
                    }
                    else
                    {
                        $this->session->set_flashdata('alert_danger', 'Something went wrong. Please try again later');
                        redirect("/settingsController");
                    }
                    
                }else{
                    $updateArray = array(            		
                        'year'=>$year,
                        'status'=>$status
                   );            
                    $insert = $this->mcommon->common_edit('financial_year',$updateArray,array('id'=>$id));
                    if($status==1){
                        $this->mcommon->common_edit('financial_year',array('status'=>'0'),array('id !='=>$id));
                    } 
                   
                    if($insert > 0)
                    {                        
                        $this->session->set_flashdata('alert_success', 'Financial Edit successfully!');
                        redirect("/settingsController/trustSettings");
                    }
                    else
                    {
                        $this->session->set_flashdata('alert_danger', 'Something went wrong. Please try again later');
                        redirect("/settingsController/trustSettings");
                    }
                }         

            }else{
                redirect("settingsController");
            }
    }   




    public function getYearData($id){
            $records = $this->mcommon->records_all('financial_year',array('id'=>$id));
            if($records > 0){
                echo json_encode($records);
            }else{
                echo 0;
            }
            
    }

    public function deleteYear($id){
        $this->mcommon->common_delete('financial_year',array('id'=>$id));
        echo 1;
    }

    public function pdfDesign(){
        $print_data['setting'] = "test";
        return $this->load->view('settings/test_pdf', $print_data);
    }

    public function upload10BE(){
        $view_data['actionUrl'] = base_url() . 'settingsController/editTrustSettings';
        $view_data['records'] = $this->mcommon->records_all('financial_year');
       // print_r($view_data['datatable']);exit();
        $data = array(
            'title' => 'Upload 10 BE',
            'page' => 'Upload 10 BE',
            'content' => $this->load->view('10_BE/upload_be_certificate', $view_data, true),
        );
        $this->load->view('base/main_template', $data);
    }

    public function store10BE(){
        $cnt=count($_FILES['pdf_files']['name']);
        $year=$this->input->post('year');
        for($i=0;$i<$cnt;$i++){
            $_FILES['img']['name']=$_FILES['pdf_files']['name'][$i];
            $_FILES['img']['type']= $_FILES['pdf_files']['type'][$i];
            $_FILES['img']['size']= $_FILES['pdf_files']['size'][$i];
            $names=explode("_",$_FILES['pdf_files']['name'][$i]);
            print_r($names);
        }
        
    }

    public function generatePDF(){
        //$this->load->library('Pdf');
         $this->load->library('m_pdf');
        // $print_data['setting'] = "test";
		 $print_data['setting'] = "test";
		$html = $this->load->view('settings/test_pdf', $print_data, true);
   		$pdfFilePath =  $_SERVER['DOCUMENT_ROOT'] . '/goseva/admin/attachments/orders/' . uniqid() . '.pdf';
   		unlink($pdfFilePath);
   		$m_pdf=new M_pdf();
   		$m_pdf->pdf->WriteHTML($html);
   		$pdf=$m_pdf->pdf->Output($pdfFilePath,'F');	
		ob_clean();
    }

    public function uploadPhoto(){
        $view_data['actionUrl'] = base_url().'settingsController/storePhoto';
        $view_data['records'] = $this->mcommon->records_all('photos',array('is_delete'=>0));
        $data = array(
            'title' => 'Upload Photo',
            'page' => 'Upload Photo',
            'content' => $this->load->view('settings/photo/upload_banner', $view_data, true),
        );
        $this->load->view('base/main_template', $data);
    }

    public function storePhoto(){
        $cnt=count($_FILES['banner']['name']);
        $type=$this->input->post('type');
     
        for($i=0;$i<$cnt;$i++){
            $_FILES['img']['name']=$_FILES['banner']['name'][$i];
            $_FILES['img']['type']= $_FILES['banner']['type'][$i];
            $_FILES['img']['size']= $_FILES['banner']['size'][$i];
            $_FILES['img']['tmp_name']=$_FILES['banner']['tmp_name'][$i];
            $ext = pathinfo($_FILES['banner']['name'][$i], PATHINFO_EXTENSION);
            $file_name=$type.date("y_m_s_h_i_s").".".$ext;
            $config['file_name']=$file_name;            
            $config['upload_path']="./admin/attachments/photos/";        
            $config['allowed_types']="png|jpg|jpeg";
            $this->load->library('upload',$config);   
            $this->upload->initialize($config);
            if($this->upload->do_upload('img')){
              $data=$this->upload->data();
              $filenm = $data['file_name'];   
             }   else{               
              echo $this->upload->display_errors(); die();
             } 
          $pdf_file = base_url('admin/attachments/photos/'.$filenm);
          $insert_array = array(                    
            'type'=>$type,
            'image_path'=>$pdf_file
           );
         $insert = $this->mcommon->common_insert('photos',$insert_array);
        }
        if ($insert) {
            $this->session->set_flashdata('alert_success', 'upload successfully!');
            redirect('SettingsController/uploadPhoto');

        } else {

            $this->session->set_flashdata('alert_danger', 'Something went wrong. Please try again later');
            redirect('SettingsController/uploadPhoto');

        }        
    }
    public function editUploadPhoto($id){
        $view_data['actionUrl'] = base_url().'settingsController/editPhoto';
        $view_data['records'] = $this->mcommon->records_all('photos',array('id'=>$id));
        $data = array(
            'title' => 'Edit Upload Photo',
            'page' => 'Edit Upload Photo',
            'content' => $this->load->view('settings/photo/edit_upload_photo', $view_data, true),
        );
        $this->load->view('base/main_template', $data);
    }
    public function editPhoto(){
        $id = $this->input->post('id');
        $old_file = $this->input->post('old_file');
        $type=$this->input->post('type');
        // print_r($type);
        // die();
        $ext = pathinfo($_FILES['banner']['name'], PATHINFO_EXTENSION);
        $fileName=$type."_".date("y_m_s").".".$ext;
        $config['file_name']=$fileName;
        $config['upload_path']="./attachments/photos/";         
        $config['allowed_types'] = 'png|jpg|jpeg';
        $this->load->library('upload',$config);   
        $this->upload->initialize($config);                 
        if($_FILES['banner']['name'] !=''){
            if($this->upload->do_upload('banner')){
                $data=$this->upload->data();         
            } else{        
                $this->session->set_flashdata('alert_danger', $this->upload->display_errors());
                // echo  $pdf_file1 = base_url('attachments/photos/'.$fileName);
                // die();
                redirect('SettingsController/uploadPhoto');           
            } 
      }
       echo  $pdf_file1 = base_url('attachments/photos/'.$fileName);
       
        $insert_Data = array(
          'type' => $type,         
          'image_path' =>($_FILES['banner']['name'] !='') ? $pdf_file1:$old_file,                
        ); 
        $edit = $this->mcommon->common_edit('photos', $insert_Data,array('id'=>$id));            
        if($_FILES['banner']['name'] > 0){
          unlink($old_file);
        }
        $this->session->set_flashdata('alert_success', 'upload Done!');
        redirect('SettingsController/uploadPhoto');  
      }

    /*** Video  */
    public function uploadVideo(){
        $view_data['actionUrl'] = base_url().'settingsController/storeVideo';
        $view_data['records'] = $this->mcommon->records_all('video',array('is_delete'=>0));
        $data = array(
            'title' => 'Upload Video',
            'page' => 'Upload Video',
            'content' => $this->load->view('settings/video/upload_video', $view_data, true),
        );
        $this->load->view('base/main_template', $data);
    }

    public function storeVideo(){
        $cnt=count($_FILES['banner']['name']);
        $type=$this->input->post('type');
        for($i=0;$i<$cnt;$i++){
            $_FILES['img']['name']=$_FILES['banner']['name'][$i];
            $_FILES['img']['type']= $_FILES['banner']['type'][$i];
            $_FILES['img']['size']= $_FILES['banner']['size'][$i];
            $_FILES['img']['tmp_name']=$_FILES['banner']['tmp_name'][$i];
            $ext = pathinfo($_FILES['banner']['name'][$i], PATHINFO_EXTENSION);
            $file_name=$type.date("y_m_s_h_i_s").".".$ext;
            $config['file_name']=$file_name;            
            $config['upload_path']="./attachments/videos/";        
            $config['allowed_types']="png|jpg|jpeg";
            $this->load->library('upload',$config);   
            $this->upload->initialize($config);
            if($this->upload->do_upload('img')){
              $data=$this->upload->data();
              $filenm = $data['file_name'];   
             }   else{               
              echo $this->upload->display_errors(); die();
             } 
          $pdf_file = base_url('attachments/videos/'.$filenm);
          $insert_array = array(                    
            'caption'=>$type,
            'video_path'=>$pdf_file
           );
         $insert = $this->mcommon->common_insert('video',$insert_array);
        }
        if ($insert) {
            $this->session->set_flashdata('alert_success', 'upload successfully!');
            redirect('SettingsController/uploadVideo');

        } else {

            $this->session->set_flashdata('alert_danger', 'Something went wrong. Please try again later');
            redirect('SettingsController/uploadVideo');

        }        
    }
    public function editUploadVideo($id){
        $view_data['actionUrl'] = base_url().'settingsController/editVideo';
        $view_data['records'] = $this->mcommon->records_all('video',array('id'=>$id));
        $data = array(
            'title' => 'Edit Upload Video',
            'page' => 'Edit Upload Video',
            'content' => $this->load->view('settings/video/edit_upload_video', $view_data, true),
        );
        $this->load->view('base/main_template', $data);
    }
    public function editVideo(){
        $id = $this->input->post('id');
        $old_file = $this->input->post('old_file');
        $type=$this->input->post('type');
        $ext = pathinfo($_FILES['banner']['name'], PATHINFO_EXTENSION);
        $fileName=$type."_".date("y_m_s").".".$ext;
        $config['file_name']=$fileName;
        $config['upload_path']="./attachments/videos/";         
        $config['allowed_types'] = 'png|jpg|jpeg';
        $this->load->library('upload',$config);   
        $this->upload->initialize($config);                 
        if($_FILES['banner']['name'] !=''){
            if($this->upload->do_upload('banner')){
                $data=$this->upload->data();         
            } else{        
                $this->session->set_flashdata('alert_danger', $this->upload->display_errors());               
                redirect('SettingsController/uploadVideo');           
            } 
      }
        $pdf_file1 = base_url('attachments/videos/'.$fileName);
       
        $insert_Data = array(
          'type' => $type,         
          'video_path' =>($_FILES['banner']['name'] !='') ? $pdf_file1:$old_file,                
        ); 
        $edit = $this->mcommon->common_edit('video', $insert_Data,array('id'=>$id));            
        if($_FILES['banner']['name'] > 0){
          unlink($old_file);
        }
        $this->session->set_flashdata('alert_success', 'upload Done!');
        redirect('SettingsController/uploadVideo');  
      }
}