 <div class="progress-wrap d-flex align-items-center justify-content-center cursor-pointer h-40px w-40px position-fixed" id="progress-scroll">
 	<svg class="progress-circle w-100 h-100 position-absolute" viewBox="0 0 100 100">
 		<circle cx="50" cy="50" r="45" class="progress" />
 	</svg>
 	<i class="ri-arrow-up-line fs-16 z-1 position-relative text-primary"></i>
 </div>
 <!-- END scroll top -->

 <!-- Begin Footer -->
 <footer class="footer">
 	<div class="container-fluid">
 		<div class="d-flex justify-content-between align-items-center gap-2">
 			<script>
 				document.write(new Date().getFullYear())
 			</script> © Findflicker
 		</div>
 	</div>
 </footer>
 <!-- END Footer -->

 <!-- Delete Source -->
 <div class="modal fade" id="deleteModal" role="dialog">
 	<div class="modal-dialog modal-dialog-centered modal-sm">
 		<div class="modal-content">
 			<div class="modal-body">
 				<div class="text-center">
 					<h4 class="mb-2">Delete Confirmation</h4>
 					<p class="mb-0">
 						Are you sure you want to delete..?
 					</p>
 					<input type="hidden" name="" id="uid_d" />
 					<input type="hidden" name="" id="model_d" />

 					<div class="d-flex align-items-center justify-content-center mt-4">
 						<a href="#" class="btn btn-light me-2" data-bs-dismiss="modal">Cancel</a>
 						<a href="javascript:void(0)" onclick="deleteRow()" class="btn btn-danger">Yes, Delete it</a>
 					</div>
 				</div>
 			</div>
 		</div>
 	</div>
 </div>
 <!-- /Delete Source -->

 <!-- Status Modal-->
 <div class="modal fade" id="statusModal" role="dialog">
 	<div class="modal-dialog modal-dialog-centered modal-sm">
 		<div class="modal-content">
 			<div class="modal-body">
 				<div class="text-center">
 					<h4 class="mb-2">Status Confirmation</h4>
 					<p class="mb-0">
 						Are you sure you want to change status..?
 					</p>
 					<input type="hidden" name="" id="uid" />
 					<input type="hidden" name="" id="model" />
 					<input type="hidden" name="" id="status" />
 					<div class="d-flex align-items-center justify-content-center mt-4">
 						<a href="#" class="btn btn-light me-2" data-bs-dismiss="modal">Cancel</a>
 						<a href="javascript:void(0)" onclick="change()" class="btn btn-danger">Yes, Change it</a>
 					</div>
 				</div>
 			</div>
 		</div>
 	</div>
 </div>



 <div class="modal fade" id="showModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
 	<div class="modal-dialog" role="document">
 		<div class="modal-content" id="details">

 		</div>
 	</div>
 </div>

 <div class="modal fade" id="issuesModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
 	<div class="modal-dialog modal-dialog-centered" role="document">
 		<div class="modal-content">
			<div class="modal-header">
 			<div class="text-center">
 				<h4 class="mb-2">Issues</h4>
 			</div>
 			<button type="button" class="btn-close icon-btn-sm" data-bs-dismiss="modal" aria-label="Close">
 				<i class="ri-close-large-line fw-semibold"></i>
 			</button>
 		</div>

 			<div class="modal-body" id="issues">

 			</div>
 		</div>
 	</div>
 </div>

 </div>
 <!-- End Begin page -->

 <!-- JAVASCRIPT -->
 <script src="<?= asset('backend_assets') ?>/libs/swiper/swiper-bundle.min.js"></script>
 <script src="<?= asset('backend_assets') ?>/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
 <script src="<?= asset('backend_assets') ?>/libs/simplebar/simplebar.min.js"></script>
 <script src="<?= asset('backend_assets') ?>/js/scroll-top.init.js"></script>

 <script src="<?= asset('backend_assets') ?>/js/jquery.validate.min.js"></script>
 <script src="<?= asset('backend_assets') ?>/js/select2.min.js"></script>
 <script src="<?= asset('backend_assets') ?>/libs/sweetalert2/sweetalert2.min.js"></script>
 <script src="<?= asset('backend_assets') ?>/libs/air-datepicker/air-datepicker.js"></script>
 <!--datatable js-->
 <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
 <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

 <!-- App js -->
 <script type="module" src="<?= asset('backend_assets') ?>/js/app.js"></script>
 <script>
 	function showDetails(id) {
 		$('#details').html('');
 		var url = '<?= url('backend/showDetails') ?>/' + id;
 		$.get(url, function(data) {
 			$('#details').html(data);
 			$('#showModal').modal('show');
 		})
 	}


 	function showIssues(message) {
 		$('#issues').html('');
 		$('#issues').html(message);
 		$('#issuesModal').modal('show');
 	}

 	const ToastMixin = Swal.mixin({
 		toast: true,
 		position: "top-end",
 		showConfirmButton: false,
 		timer: 2500,
 		timerProgressBar: true,
 		didOpen: (toast) => {
 			toast.onmouseenter = Swal.stopTimer;
 			toast.onmouseleave = Swal.resumeTimer;
 		}
 	});

 	const localeEn = {
 		days: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
 		daysShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
 		daysMin: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
 		months: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
 		monthsShort: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
 		today: 'Today',
 		clear: 'Clear',
 		dateFormat: 'dd-MM-yyyy',
 		timeFormat: 'hh:ii aa',
 		firstDay: 0
 	}


 	new AirDatepicker('#range-picker', {
 		range: true,
 		multipleDatesSeparator: ' - ',
 		locale: localeEn,
 	});



 	function showToast(type, message) {
 		ToastMixin.fire({
 			icon: type,
 			title: message
 		});
 	}
 	$(document).ready(function() {
 		$('#datatables').DataTable({
 			dom: 'Bfrtip'
 		});
 		$('.select2').select2();
 	});

 	function commonDelete(id, model) {
 		$('#uid_d').val(id);
 		$('#model_d').val(model);
 		$('#deleteModal').modal('show');
 	}

 	function deleteRow() {
 		var uid = $('#uid_d').val();
 		var model = $('#model_d').val();
 		var url = '<?= route('commonDelete') ?>';
 		$.post(url, {
 			id: uid,
 			model: model,
 			'_token': '<?= csrf_token() ?>'
 		}, function(data) {
 			if (data == 1) {
 				window.location.reload();
 			}
 		});
 	}

 	function change() {
 		var uid = $('#uid').val();
 		var model = $('#model').val();
 		var status = $('#status').val();
 		var url = '<?= route('updateCommonStatus') ?>';
 		$.post(url, {
 			id: uid,
 			status: status,
 			model: model,
 			'_token': '<?= csrf_token() ?>'
 		}, function(data) {
 			$('#statusModal').modal('hide');
 			var row = JSON.parse(data);
 			showToast('success', row.message);
 			setTimeout(() => {
 				window.location.reload();
 			}, 800);
 		});
 	}





 	function changeStatus(id, status, model) {
 		$('#uid').val(id);
 		$('#model').val(model);
 		$('#status').val(status);
 		$('#statusModal').modal('show');
 	}



 </script>
 @include('backend.alert')
 </body>



 </html>
