<?php

use Illuminate\Support\Facades\Auth;
?>
<!-- begin::App -->
<div id="layout-wrapper">
    <!-- Begin Header -->
    <header class="app-header" id="appHeader">
        <div class="container-fluid w-100">
            <div class="d-flex align-items-center">
                <div class="me-auto">
                    <div class="d-inline-flex align-items-center gap-5">
                        <a href="<?= route('dashboard') ?>" class="fs-18 fw-semibold">
                            <img height="30" class="header-sidebar-logo-default d-none" alt="Logo"
                                src="<?= asset('backend_assets') ?>/images/logo.png">
                            <img height="30" class="header-sidebar-logo-light d-none" alt="Logo"
                                src="<?= asset('backend_assets') ?>/images/logo.png">
                            <img height="30" class="header-sidebar-logo-small d-none" alt="Logo"
                                src="<?= asset('backend_assets') ?>/images/logo.png">
                            <img height="30" class="header-sidebar-logo-small-light d-none" alt="Logo"
                                src="<?= asset('backend_assets') ?>/images/logo.png">
                        </a>

                        <button type="button"
                            class="horizontal-toggle btn btn-light-light text-muted icon-btn fs-5 rounded-pill d-none"
                            id="toggleHorizontal">
                            <i class="ri-menu-2-line header-icon"></i>
                        </button>

                    </div>
                </div>
                <div class="flex-shrink-0 d-flex align-items-center gap-1">


                    <div class="dark-mode-btn" id="toggleMode">
                        <button class="btn header-btn active" id="lightModeBtn">
                            <i class="bi bi-brightness-high"></i>
                        </button>
                        <button class="btn header-btn" id="darkModeBtn">
                            <i class="bi bi-moon-stars"></i>
                        </button>
                    </div>
                    <div class="dropdown pe-dropdown-mega d-none d-md-block">
                        <button class="btn header-btn" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-bell"></i>
                        </button>
                        <div class="dropdown-menu dropdown-mega-md header-dropdown-menu pe-noti-dropdown-menu p-0">
                            <div class="p-3 border-bottom">
                                <h6 class="d-flex align-items-center mb-0">Notification
                                    <!-- <span class="badge bg-success rounded-circle align-middle ms-1">4</span> -->
                                </h6>
                            </div>
                            <div class="p-3">

                                <!-- <div class="noti-item">
                                    <img src="<?= asset('backend_assets') ?>/images/avatar/avatar-8.jpg" alt=""
                                        class="avatar-md">
                                    <div>
                                        <a href="javascript:void(0)" class="stretched-link">
                                            <h6 class="mb-1 text-muted"><strong
                                                    class="fw-semibold text-body">Donald</strong> liked your post</h6>
                                        </a>
                                        <p class="text-muted mb-0">Friday, 11:29 PM</p>
                                    </div>
                                    <a href="javascript:void(0)"
                                        class="position-absolute top-10 end-0 fs-18 z-1 link link-danger"><i
                                            class="bi bi-x"></i></a>
                                </div>                                                           -->

                            </div>
                        </div>
                    </div>


                    <div class="dropdown pe-dropdown-mega d-none d-md-block">
                        <button class="header-profile-btn btn gap-1 text-start" type="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <span class="header-btn btn position-relative">
                                <img src="<?= asset('backend_assets') ?>/images/avatar/avatar-10.jpg" alt=""
                                    class="img-fluid rounded-circle">
                                <span
                                    class="position-absolute translate-middle badge border border-light rounded-circle bg-success"><span
                                        class="visually-hidden">unread messages</span></span>
                            </span>
                            <div class="d-none d-lg-block pe-2">
                                <span class="d-block mb-0 fs-13 fw-semibold"><?= Auth::user()->name ?> </span>

                            </div>
                        </button>
                        <div class="dropdown-menu dropdown-mega-sm header-dropdown-menu p-3">
                            <div class="border-bottom pb-2 mb-2 d-flex align-items-center gap-2">
                                <img src="<?= asset('backend_assets') ?>/images/avatar/avatar-10.jpg" alt=""
                                    class="avatar-md">
                                <div>
                                    <a href="javascript:void(0)">
                                        <h6 class="mb-0 lh-base"><?= Auth::user()->name ?> </h6>
                                    </a>
                                    <p class="mb-0 fs-13 text-muted"><?= Auth::user()->email ?></p>
                                </div>
                            </div>
                            <ul class="list-unstyled mb-1 border-bottom pb-1">
                                <li><a class="dropdown-item" href="<?= route('profile') ?>"><i
                                            class="bi bi-person me-1"></i> View Profile</a></li>
                                <!-- <li><a class="dropdown-item" href="javascript:void(0)"><i class="bi bi-gear me-1"></i> Settings</a></li>
                                <li><a class="dropdown-item" href="javascript:void(0)"><i class="bi bi-award me-1"></i> Subscription</a></li> -->
                            </ul>
                            <!-- <ul class="list-unstyled mb-1 border-bottom pb-1">
                                <li><a class="dropdown-item" href="javascript:void(0)"><i class="bi bi-clock me-1"></i> ChangLog</a></li>
                                <li><a class="dropdown-item" href="javascript:void(0)"><i class="bi bi-people me-1"></i> Team</a></li>
                                <li><a class="dropdown-item" href="javascript:void(0)"><i class="bi bi-headset me-1"></i> Support</a></li>
                            </ul> -->
                            <ul class="list-unstyled mb-0">
                                <li><a class="dropdown-item" href="<?= route('logout') ?> "><i
                                            class="bi bi-box-arrow-right me-1"></i> Sign Out</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- END Header -->

    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content border-0 bg-transparent">
                <div class="d-flex justify-content-between align-items-center bg-body">
                    <div class="d-flex align-items-center border-0 px-3" cmdk-input-wrapper="">
                        <i class="bi bi-search me-2"></i>
                        <input class="d-flex w-full py-3 bg-transparent border-0 focus-ring" placeholder=""
                            autocomplete="off" autocorrect="off" spellcheck="false" aria-autocomplete="list"
                            role="combobox" aria-expanded="true" type="text">
                    </div>
                    <button type="button" class="btn-close pe-3" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body bg-body mt-4">
                    <p class="font-normal mb-2">Searching For...</p>
                    <span class="badge bg-light-subtle border text-body">Analytics <i
                            class="ri-close-line"></i></span>
                    <span class="badge bg-light-subtle border text-body">Project <i class="ri-close-line"></i></span>
                    <span class="badge bg-light-subtle border text-body">Eccomerce <i
                            class="ri-close-line"></i></span>
                    <span class="badge bg-light-subtle border text-body">CRM <i class="ri-close-line"></i></span>
                    <span class="badge bg-light-subtle border text-body">Logistics <i
                            class="ri-close-line"></i></span>
                    <span class="badge bg-light-subtle border text-body">Academy <i class="ri-close-line"></i></span>
                </div>
            </div>
        </div>
    </div>
    <aside class="pe-app-sidebar" id="sidebar">
        <div class="pe-app-sidebar-logo px-6 d-flex align-items-center position-relative">
            <!--begin::Brand Image-->
            <a href="<?= route('dashboard') ?>" class="fs-18 fw-semibold">
                <img height="55" class="pe-app-sidebar-logo-default d-none" alt="Logo"
                    src="<?= asset('backend_assets') ?>/images/logo.png">
                <img height="55" class="pe-app-sidebar-logo-light d-none" alt="Logo"
                    src="<?= asset('backend_assets') ?>/images/logo.png">
                <img height="55" class="pe-app-sidebar-logo-minimize d-none" alt="Logo"
                    src="<?= asset('backend_assets') ?>/images/logo.png">
                <img height="55" class="pe-app-sidebar-logo-minimize-light d-none" alt="Logo"
                    src="<?= asset('backend_assets') ?>/images/logo.png">
                <!-- FabKin -->
            </a>
            <!--end::Brand Image-->
        </div>
        <nav class="pe-app-sidebar-menu nav nav-pills" data-simplebar id="sidebar-simplebar">
            <ul class="pe-main-menu list-unstyled">

                <li class="pe-slide pe-has-sub">
                    <a href="<?= route('dashboard') ?>" class="pe-nav-link">
                        <i class="bi bi-calendar-week pe-nav-icon"></i>
                        <span class="pe-nav-content">Dashboards</span>
                    </a>
                </li>

                <li class="pe-slide pe-has-sub <?= request()->routeIs(['slider','addSlider']) ? 'active':'' ?>">
                    <a href="#collapseLogisticssldier" class="pe-nav-link" data-bs-toggle="collapse" aria-expanded="<?= request()->routeIs(['slider','addSlider']) ? 'true':'false' ?>" aria-controls="collapseLogisticssldier">
                        <i class="bi bi-sliders pe-nav-icon"></i>
                        <span class="pe-nav-content">Slider Management</span>
                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                    </a>
                    <ul class="pe-slide-menu collapse <?= request()->routeIs(['slider','addSlider']) ? 'show':'' ?>" id="collapseLogisticssldier">                       
                        <li class="pe-slide-item">
                            <a href="<?= route('slider') ?>"  class="pe-nav-link  <?= request()->routeIs(['slider','addSlider']) ? 'active':'' ?> ">
                                Slider
                            </a>
                        </li>
                    </ul>
                </li> 


                 <li class="pe-slide pe-has-sub <?= request()->routeIs(['products','addProduct']) ? 'active':'' ?>">
                    <a href="#collapseLogisticpro" class="pe-nav-link" data-bs-toggle="collapse" aria-expanded="<?= request()->routeIs(['slider','addSlider']) ? 'true':'false' ?>" aria-controls="collapseLogisticpro">
                        <i class="bi bi-shop-window pe-nav-icon"></i>
                        <span class="pe-nav-content">Product Management</span>
                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                    </a>
                    <ul class="pe-slide-menu collapse <?= request()->routeIs(['products','addProduct']) ? 'show':'' ?>" id="collapseLogisticpro">                       
                        <li class="pe-slide-item">
                            <a href="<?= route('products') ?>"  class="pe-nav-link  <?= request()->routeIs(['products','addProduct']) ? 'active':'' ?> ">
                                Products
                            </a>
                        </li>
                    </ul>
                </li> 




              

                <li class="pe-slide pe-has-sub
    @if(request()->routeIs([
        'country', 'addCountry',
        'language', 'addLanguage',
        'hair', 'addHair',
        'eye', 'addEye',
        'bodyType', 'BodyTypeDetails',
        'orientation', 'orientationDetails'
    ])) active @endif">

                    <a href="#collapseLogistics" class="pe-nav-link" data-bs-toggle="collapse"
                        aria-expanded="@if(request()->routeIs([
            'country', 'addCountry',
            'language', 'addLanguage',
            'hair', 'addHair',
            'eye', 'addEye',
            'bodyType', 'BodyTypeDetails',
            'orientation', 'orientationDetails'
        ])) true @else false @endif"
                        aria-controls="collapseLogistics">
                        <i class="bi bi-truck pe-nav-icon"></i>
                        <span class="pe-nav-content">Masters</span>
                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                    </a>

                    <ul class="pe-slide-menu collapse
        @if(request()->routeIs([
            
            
            
           
            'eye', 'addEye',
            'type', 'addType',
            'industry', 'addIndustry',
            'brand', 'addBrand',           
            'size', 'addSize',           
            'category', 'addCategory',           
        ])) show @endif" id="collapseLogistics">

                        <li class="slide pe-nav-content1">
                            <a href="javascript:void(0)">Masters</a>
                        </li>

                      

                         

                         <li class="pe-slide-item">
                            <a href="<?= route('brand') ?>" class="pe-nav-link  @if(request()->routeIs(['brand', 'addBrand'])) active @endif">
                                Brand
                            </a>
                        </li>

                         <li class="pe-slide-item">
                            <a href="<?= route('type') ?>" class="pe-nav-link  @if(request()->routeIs(['type', 'addType'])) active @endif">
                               Product Type
                            </a>
                        </li>

                         <li class="pe-slide-item">
                            <a href="<?= route('size') ?>" class="pe-nav-link  @if(request()->routeIs(['size', 'addSize'])) active @endif">
                               Product Size
                            </a>
                        </li>

                         <li class="pe-slide-item">
                            <a href="<?= route('industry') ?>" class="pe-nav-link  @if(request()->routeIs(['industry', 'addIndustry'])) active @endif">
                                Industry
                            </a>
                        </li>

                        

                         <li class="pe-slide-item">
                            <a href="<?= route('category') ?>" class="pe-nav-link  @if(request()->routeIs(['category', 'addCategory'])) active @endif">
                                Category
                            </a>
                        </li>

                        

                    </ul>
                </li>

                <!-- <li class="pe-slide pe-has-sub">
                    <a href="<?= route('userVideo') ?>" class="pe-nav-link">
                        <i class="bi bi-camera-video-fill pe-nav-icon"></i>
                        <span class="pe-nav-content">User Guide Video</span>
                    </a>
                </li> -->


               

                <li class="pe-slide pe-has-sub">
                    <a href="#collapseLogistics3" class="pe-nav-link" data-bs-toggle="collapse" aria-expanded="false" aria-controls="collapseLogistics">
                        <i class="bi bi-body-text pe-nav-icon"></i>
                        <span class="pe-nav-content">CMS</span>
                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                    </a>
                    <ul class="pe-slide-menu collapse" id="collapseLogistics3">
                        <li class="slide pe-nav-content1">
                            <a href="javascript:void(0)">Pages</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="<?= route('pages') ?>" class="pe-nav-link">
                                Pages
                            </a>
                            <a href="<?= url('backend/addPage/1') ?>" class="pe-nav-link">
                                Terms & Condition
                            </a>
                            <a href="<?= url('backend/addPage/2') ?>" class="pe-nav-link">
                                Privacy Policy
                            </a>
                        </li>
                    </ul>
                </li>





                <li class="pe-slide pe-has-sub">
                    <a href="#collapseLogistics4" class="pe-nav-link" data-bs-toggle="collapse" aria-expanded="false" aria-controls="collapseLogistics">
                        <i class="bi bi-files pe-nav-icon"></i>
                        <span class="pe-nav-content">SEO Settings</span>
                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                    </a>
                    <ul class="pe-slide-menu collapse" id="collapseLogistics4">
                        <li class="slide pe-nav-content1">
                            <a href="javascript:void(0)">Reports</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="<?= route('meta') ?>" class="pe-nav-link">
                                Meta Information
                            </a>
                        </li>
                    </ul>
                </li>


                 <li class="pe-slide pe-has-sub">
                    <a href="<?= route('settings') ?>" class="pe-nav-link">
                        <i class="bi bi bi-gear-fill pe-nav-icon"></i>
                        <span class="pe-nav-setting">Settings</span>
                    </a>
                </li>

                


            </ul>
        </nav>
    </aside>

    <aside class="pe-app-sidebar horizontal-sidebar" id="horizontal-aside">
        <div class="pe-app-sidebar-logo px-6 d-flex align-items-center position-relative">
            <!--begin::Brand Image-->
            <a href="index.html" class="fs-18 fw-semibold">
                <img height="30" class="pe-app-sidebar-logo-default d-none" alt="Logo"
                    src="<?= asset('backend_assets') ?>/images/logo-dark.png">
                <img height="30" class="pe-app-sidebar-logo-light d-none" alt="Logo"
                    src="<?= asset('backend_assets') ?>/images/logo-light.png">
                <img height="30" class="pe-app-sidebar-logo-minimize d-none" alt="Logo"
                    src="<?= asset('backend_assets') ?>/images/logo-md.png">
                <img height="30" class="pe-app-sidebar-logo-minimize-light d-none" alt="Logo"
                    src="<?= asset('backend_assets') ?>/images/logo-md-light.png">
                <!-- FabKin -->
            </a>
            <!--end::Brand Image-->
        </div>
        <!-- data-simplebar id="sidebar-simplebar" -->
        <nav class="pe-app-sidebar-menu nav nav-pills">
            <ul class="pe-horizontal-menu list-unstyled" id="horizontal-menu">
                <li class="pe-menu-title">
                    Main
                </li>
                <li class="pe-slide pe-has-sub">
                    <a href="#collapseDashboards" class="pe-nav-link" data-bs-toggle="collapse"
                        aria-expanded="false" aria-controls="collapseDashboards">
                        <i class="bi bi-speedometer2 pe-nav-icon"></i>
                        <span class="pe-nav-content">Dashboards</span>
                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                    </a>
                    <ul class="pe-slide-menu collapse" id="collapseDashboards">
                        <li class="pe-slide-item">
                            <a href="index.html" class="pe-nav-link">
                                Academy
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="dashboard-analytics.html" class="pe-nav-link">
                                Analytics
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="dashboard-crm.html" class="pe-nav-link">
                                CRM
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="dashboard-ecommerce.html" class="pe-nav-link">
                                E-Commerce
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="dashboard-logistic.html" class="pe-nav-link">
                                Logistics
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="dashboard-project.html" class="pe-nav-link">
                                Projects
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="pe-menu-title">
                    Applications
                </li>
                <li class="pe-slide pe-has-sub">
                    <a href="#collapseApplications" class="pe-nav-link" data-bs-toggle="collapse"
                        aria-expanded="false" aria-controls="collapseApplications">
                        <i class="bi bi-window-stack pe-nav-icon"></i>
                        <span class="pe-nav-content">Applications</span>
                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                    </a>
                    <ul class="pe-slide-menu collapse" id="collapseApplications">
                        <li class="pe-slide pe-has-sub">
                            <a href="apps-calendar.html" class="pe-nav-link">
                                <i class="bi bi-calendar-week pe-nav-icon"></i>
                                <span class="pe-nav-content">Calendar</span>
                            </a>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="apps-chat.html" class="pe-nav-link">
                                <i class="bi bi-chat-square-text pe-nav-icon"></i>
                                <span class="pe-nav-content">Chat</span>
                            </a>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="apps-email.html" class="pe-nav-link">
                                <i class="bi bi-envelope-at pe-nav-icon"></i>
                                <span class="pe-nav-content">Email</span>
                            </a>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseEcommerce" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseEcommerce">
                                <i class="bi bi-cart4 pe-nav-icon"></i>
                                <span class="pe-nav-content">E-Commerce</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseEcommerce">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">E-Commerce</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-ecommerce-products.html" class="pe-nav-link">
                                        Products
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-ecommerce-products-details.html" class="pe-nav-link">
                                        Product Details
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-ecommerce-products-list.html" class="pe-nav-link">
                                        Product List
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-ecommerce-add-products.html" class="pe-nav-link">
                                        Add Product
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-ecommerce-order-details.html" class="pe-nav-link">
                                        Order Details
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-ecommerce-order.html" class="pe-nav-link">
                                        Orders
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-ecommerce-cart.html" class="pe-nav-link">
                                        Cart
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-ecommerce-checkout.html" class="pe-nav-link">
                                        Checkout
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-ecommerce-wishlist.html" class="pe-nav-link">
                                        Wishlist
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseAcademy" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseAcademy">
                                <i class="bi bi-mortarboard pe-nav-icon"></i>
                                <span class="pe-nav-content">Academy</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseAcademy">
                                <li class="pe-slide pe-has-sub">
                                    <a href="#collapseCourses" class="pe-nav-link" data-bs-toggle="collapse"
                                        aria-expanded="false" aria-controls="collapseCourses">
                                        <span class="pe-nav-sub-content">Courses</span>
                                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                                    </a>
                                    <ul class="pe-slide-menu collapse" id="collapseCourses">
                                        <li class="pe-slide-item">
                                            <a href="apps-academy-courses.html" class="pe-nav-link">All Courses</a>
                                        </li>
                                        <li class="pe-slide-item">
                                            <a href="apps-academy-courses-category.html" class="pe-nav-link">Courses
                                                Category</a>
                                        </li>
                                        <li class="pe-slide-item">
                                            <a href="apps-academy-single-category.html" class="pe-nav-link">Category
                                                Single</a>
                                        </li>
                                    </ul>
                                </li>
                                <li class="pe-slide pe-has-sub">
                                    <a href="#collapseUsers" class="pe-nav-link" data-bs-toggle="collapse"
                                        aria-expanded="false" aria-controls="collapseUsers">
                                        <span class="pe-nav-sub-content">User</span>
                                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                                    </a>
                                    <ul class="pe-slide-menu collapse" id="collapseUsers">
                                        <li class="pe-slide-item">
                                            <a href="apps-academy-user-instructor.html"
                                                class="pe-nav-link">Instructor</a>
                                        </li>
                                        <li class="pe-slide-item">
                                            <a href="apps-academy-user-student.html" class="pe-nav-link">Students</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseCMS" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseCMS">
                                <i class="bi bi-book pe-nav-icon"></i>
                                <span class="pe-nav-content">CMS</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseCMS">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">CMS</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-cms-content.html" class="pe-nav-link">
                                        Content
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-cms-add-content.html" class="pe-nav-link">
                                        Add Content
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-cms-menus.html" class="pe-nav-link">
                                        Menus
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-cms-blog.html" class="pe-nav-link">
                                        Blog
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseLogistics" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseLogistics">
                                <i class="bi bi-truck pe-nav-icon"></i>
                                <span class="pe-nav-content">Logistics</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseLogistics">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">Logistics</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-logistic-list.html" class="pe-nav-link">
                                        List
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-logistic-overview.html" class="pe-nav-link">
                                        Overview
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-logistic-create.html" class="pe-nav-link">
                                        Create Project
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseCRM" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseCRM">
                                <i class="bi bi-binoculars pe-nav-icon"></i>
                                <span class="pe-nav-content">CRM</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseCRM">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">CRM</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-crm-contact.html" class="pe-nav-link">
                                        Contact
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-crm-lead.html" class="pe-nav-link">
                                        Lead
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-crm-deal.html" class="pe-nav-link">
                                        Deal
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseProjects" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseProjects">
                                <i class="bi bi-cast pe-nav-icon"></i>
                                <span class="pe-nav-content">Projects</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseProjects">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">Projects</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-project-list.html" class="pe-nav-link">
                                        List
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-project-overview.html" class="pe-nav-link">
                                        Overview
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-project-create.html" class="pe-nav-link">
                                        Create Project
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseInvoices" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseInvoices">
                                <i class="bi bi-receipt pe-nav-icon"></i>
                                <span class="pe-nav-content">Invoices</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseInvoices">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">Invoices</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-invoice-list.html" class="pe-nav-link">
                                        List
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-invoice-detail.html" class="pe-nav-link">
                                        Details
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="apps-invoice-create.html" class="pe-nav-link">
                                        Create invoice
                                    </a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </li>
                <li class="pe-menu-title">
                    Pages
                </li>
                <li class="pe-slide pe-has-sub">
                    <a href="#collapsePages" class="pe-nav-link" data-bs-toggle="collapse" aria-expanded="false"
                        aria-controls="collapsePages">
                        <i class="bi bi-airplane pe-nav-icon"></i>
                        <span class="pe-nav-content">Pages</span>
                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                    </a>
                    <ul class="pe-slide-menu collapse" id="collapsePages">
                        <li class="slide pe-nav-content1">
                            <a href="javascript:void(0)">Pages</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="pages-starter.html" class="pe-nav-link">
                                Blank Page
                            </a>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseProfile" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseProfile">
                                <span class="pe-nav-sub-content">Profile</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseProfile">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">Profile</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="pages-profile.html" class="pe-nav-link">
                                        Simple Page
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="pages-profile-setting.html" class="pe-nav-link">
                                        Settings
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseBlogs" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseBlogs">
                                <span class="pe-nav-sub-content">Blogs</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseBlogs">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">Blog</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="pages-blog-list.html" class="pe-nav-link">
                                        Blog List
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="pages-blog-details.html" class="pe-nav-link">
                                        Blog Details
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="pages-blog-create.html" class="pe-nav-link">
                                        Create Blog
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-slide-item">
                            <a href="pages-timeline.html" class="pe-nav-link">
                                Timeline
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="pages-faqs.html" class="pe-nav-link">
                                FAQs
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="pages-billing-subscription.html" class="pe-nav-link">
                                Billing & Subscription
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="pages-pricing.html" class="pe-nav-link">
                                Pricing
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="pages-gallery.html" class="pe-nav-link">
                                Gallery
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="pages-sitemap.html" class="pe-nav-link">
                                Sitemap
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="pages-search-result.html" class="pe-nav-link">
                                Search Results
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="pages-privacy-policy.html" class="pe-nav-link">
                                Privacy Policy
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="pages-terms-conditions.html" class="pe-nav-link">
                                Terms & Conditions
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="pe-slide pe-has-sub">
                    <a href="#collapseAuth" class="pe-nav-link" data-bs-toggle="collapse" aria-expanded="false"
                        aria-controls="collapseAuth">
                        <i class="bi bi-person pe-nav-icon"></i>
                        <span class="pe-nav-content">Authentication</span>
                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                    </a>
                    <ul class="pe-slide-menu collapse" id="collapseAuth">
                        <li class="slide pe-nav-content1">
                            <a href="javascript:void(0)">Authentication</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="auth-signin.html" class="pe-nav-link">
                                Sign in
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="auth-signup.html" class="pe-nav-link">
                                Sign Up
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="auth-create-password.html" class="pe-nav-link">
                                Create Password
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="auth-reset-password.html" class="pe-nav-link">
                                Reset Password
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="auth-two-step-verify.html" class="pe-nav-link">
                                Two Step Verification
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="auth-lockscreen.html" class="pe-nav-link">
                                Lock Screen
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="coming-soon.html" class="pe-nav-link">
                                Coming Soon
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="under-maintenance.html" class="pe-nav-link">
                                Under Maintenance
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="pe-slide pe-has-sub">
                    <a href="#collapseError" class="pe-nav-link" data-bs-toggle="collapse" aria-expanded="false"
                        aria-controls="collapseError">
                        <i class="bi bi-bug pe-nav-icon"></i>
                        <span class="pe-nav-content">Error</span>
                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                    </a>
                    <ul class="pe-slide-menu collapse" id="collapseError">
                        <li class="slide pe-nav-content1">
                            <a href="javascript:void(0)">Error</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="auth-401.html" class="pe-nav-link">
                                401
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="auth-404.html" class="pe-nav-link">
                                404
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="auth-500.html" class="pe-nav-link">
                                500
                            </a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="auth-offline.html" class="pe-nav-link">
                                offline page
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="pe-slide pe-has-sub">
                    <a href="#collapseBaseUI" class="pe-nav-link" data-bs-toggle="collapse" aria-expanded="false"
                        aria-controls="collapseBaseUI">
                        <i class="bi bi-feather2 pe-nav-icon"></i>
                        <span class="pe-nav-content">Base UI</span>
                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                    </a>
                    <ul class="pe-slide-menu collapse list-unstyled" id="collapseBaseUI" data-simplebar
                        style="height: 400px;">
                        <li class="slide pe-nav-content1">
                            <a href="javascript:void(0)">Base UI</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-accordions.html" class="pe-nav-link">Accordions</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-alerts.html" class="pe-nav-link">Alert</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-avatars.html" class="pe-nav-link">Avatar</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-badges.html" class="pe-nav-link">Badge</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-breadcrumbs.html" class="pe-nav-link">Breadcrumb</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-buttons.html" class="pe-nav-link">Buttons</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-button-group.html" class="pe-nav-link">Button Group</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-card.html" class="pe-nav-link">Cards</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-cookie.html" class="pe-nav-link">Cookie</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-carousel.html" class="pe-nav-link">Carousel</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-dropdowns.html" class="pe-nav-link">Dropdown</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-images-figures.html" class="pe-nav-link">Images & Figures</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-links.html" class="pe-nav-link">Links</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-list.html" class="pe-nav-link">List Group</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-tabs.html" class="pe-nav-link">Nav & Tabs</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-pagination.html" class="pe-nav-link">Pagination</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-popover.html" class="pe-nav-link">Popovers</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-progress.html" class="pe-nav-link">Progress</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-spinner.html" class="pe-nav-link">Spinners</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-separator.html" class="pe-nav-link">Separator</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-modal.html" class="pe-nav-link">Modal</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-offcanvas.html" class="pe-nav-link">Off Canvas</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-placeholders.html" class="pe-nav-link">Placeholders</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-toast.html" class="pe-nav-link">Toasts</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-tooltips.html" class="pe-nav-link">Tooltips</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-typography.html" class="pe-nav-link">Typography</a>
                        </li>
                        <li class="pe-slide-item">
                            <a href="ui-utilities.html" class="pe-nav-link">Utilities</a>
                        </li>
                    </ul>
                </li>
                <li class="pe-slide pe-has-sub">
                    <a href="#collapseMore" class="pe-nav-link" data-bs-toggle="collapse" aria-expanded="false"
                        aria-controls="collapseMore">
                        <i class="bi bi-bag-plus pe-nav-icon"></i>
                        <span class="pe-nav-content">More</span>
                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                    </a>
                    <ul class="pe-slide-menu collapse" id="collapseMore">
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseAdvancedUI" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseAdvancedUI">
                                <i class="bi bi-feather pe-nav-icon"></i>
                                <span class="pe-nav-content">Advanced UI</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseAdvancedUI">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">Advanced UI</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-block.html" class="pe-nav-link">Block</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-countup.html" class="pe-nav-link">Count Up</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-draggable-cards.html" class="pe-nav-link">Draggable Cards</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-media-player.html" class="pe-nav-link">Media Player</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-ratings.html" class="pe-nav-link">Rating</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-ribbons.html" class="pe-nav-link">Ribbons</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-scrollspy.html" class="pe-nav-link">Scroll Spy</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-sortable-js.html" class="pe-nav-link">Sortable JS</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-sweetalert2.html" class="pe-nav-link">Sweet Alert</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-advance-swiper.html" class="pe-nav-link">Swiper JS</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-tour.html" class="pe-nav-link">Tour</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-treeview.html" class="pe-nav-link">Tree View</a>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseFroms" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseFroms">
                                <i class="bi bi-input-cursor-text pe-nav-icon"></i>
                                <span class="pe-nav-content">Forms</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseFroms">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">Forms</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-form-elements.html" class="pe-nav-link">
                                        Input
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-form-checkboxs-radios.html" class="pe-nav-link">
                                        Checkbox & Radios
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-form-input-group.html" class="pe-nav-link">
                                        Inout Group
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-form-select.html" class="pe-nav-link">
                                        Form Select
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-form-range.html" class="pe-nav-link">
                                        Range Slider
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-form-input-masks.html" class="pe-nav-link">
                                        Input Masks
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-form-file-uploads.html" class="pe-nav-link">
                                        File Uploads
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-date-picker.html" class="pe-nav-link">
                                        Date,Time Picker
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-floating-labels.html" class="pe-nav-link">Floating Label</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-form-layout.html" class="pe-nav-link">Form Layout</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-form-editor.html" class="pe-nav-link">Editor</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-form-validation.html" class="pe-nav-link">Form Validation</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-form-wizards.html" class="pe-nav-link">Form Wizards</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-form-advanced.html" class="pe-nav-link">Form Advanced</a>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseTables" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseTables">
                                <i class="bi bi-table pe-nav-icon"></i>
                                <span class="pe-nav-content">Tables</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseTables">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">Tables</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-tables-basic.html" class="pe-nav-link">
                                        Basic Tables
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-tables-listjs.html" class="pe-nav-link">
                                        List JS Table
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-tables-gridjs.html" class="pe-nav-link">
                                        Grid JS Table
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="ui-tables-datatables.html" class="pe-nav-link">
                                        Datatables
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseCharts" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseCharts">
                                <i class="bi bi-bar-chart pe-nav-icon"></i>
                                <span class="pe-nav-content">Charts</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseCharts">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">Charts</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="chart-apex-line.html" class="pe-nav-link">
                                        Apex Charts
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="chart-js-chart.html" class="pe-nav-link">
                                        Chartjs Charts
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="echart-chart.html" class="pe-nav-link">
                                        Echart Charts
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-menu-title">
                            Icons & Maps
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseIcons" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseIcons">
                                <i class="bi bi-recycle pe-nav-icon"></i>
                                <span class="pe-nav-content">Icons</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseIcons">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">Icons</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="icons-remix.html" class="pe-nav-link">
                                        Remix Icons
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="icons-bootstrap.html" class="pe-nav-link">
                                        Bootstrap Icons
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseMaps" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseMaps">
                                <i class="bi bi-map pe-nav-icon"></i>
                                <span class="pe-nav-content">Maps</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseMaps">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">Maps</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="maps-google.html" class="pe-nav-link">
                                        Google Maps
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="maps-leaflet.html" class="pe-nav-link">
                                        Leaflet Maps
                                    </a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="maps-vector.html" class="pe-nav-link">
                                        Vector Maps
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="pe-menu-title">
                            Other
                        </li>
                        <li class="pe-slide pe-has-sub">
                            <a href="#collapseMenuLavels" class="pe-nav-link" data-bs-toggle="collapse"
                                aria-expanded="false" aria-controls="collapseMenuLavels">
                                <i class="bi bi-diagram-3 pe-nav-icon"></i>
                                <span class="pe-nav-content">Menu levels</span>
                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                            </a>
                            <ul class="pe-slide-menu collapse" id="collapseMenuLavels">
                                <li class="slide pe-nav-content1">
                                    <a href="javascript:void(0)">Menu levels</a>
                                </li>
                                <li class="pe-slide-item">
                                    <a href="javascript:void(0)" class="pe-nav-link">
                                        Level 1.1
                                    </a>
                                </li>
                                <li class="pe-slide pe-has-sub">
                                    <a href="#collapseMenuLavels2" class="pe-nav-link" data-bs-toggle="collapse"
                                        aria-expanded="false" aria-controls="collapseMenuLavels2">
                                        <span class="pe-nav-sub-content">Level 1.2</span>
                                        <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                                    </a>
                                    <ul class="pe-slide-menu collapse" id="collapseMenuLavels2">
                                        <li class="slide pe-nav-content1">
                                            <a href="javascript:void(0)">Level 1.2</a>
                                        </li>
                                        <li class="pe-slide-item">
                                            <a href="javascript:void(0)" class="pe-nav-link">
                                                Level 2.1
                                            </a>
                                        </li>
                                        <li class="pe-slide-item">
                                            <a href="javascript:void(0)" class="pe-nav-link">
                                                Level 2.2
                                            </a>
                                        </li>
                                        <li class="pe-slide pe-has-sub">
                                            <a href="#collapseMenuLavels3" class="pe-nav-link"
                                                data-bs-toggle="collapse" aria-expanded="false"
                                                aria-controls="collapseMenuLavels3">
                                                <span class="pe-nav-sub-content">Level 2.3</span>
                                                <i class="ri-arrow-down-s-line pe-nav-arrow"></i>
                                            </a>
                                            <ul class="pe-slide-menu collapse" id="collapseMenuLavels3">
                                                <li class="slide pe-nav-content1">
                                                    <a href="javascript:void(0)">Level 2.3</a>
                                                </li>
                                                <li class="pe-slide-item">
                                                    <a href="javascript:void(0)" class="pe-nav-link">
                                                        Level 3.1
                                                    </a>
                                                </li>
                                                <li class="pe-slide-item">
                                                    <a href="javascript:void(0)" class="pe-nav-link">
                                                        Level 3.2
                                                    </a>
                                                </li>
                                            </ul>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </li>
            </ul>
        </nav>
    </aside>
    <div class="sidebar-backdrop" id="sidebar-backdrop"></div>
