<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class RangeController extends Controller
{
    public function getRange()
    {
        $range = $this->getLatLngRange(11.134566, 79.075738, 5);

        return response()->json([
            'status'  => 'success',
            'message' => 'range found',
            'data'    => $range
        ], 200);

        // $records = User::whereBetween('latitude', [$range['min_lat'], $range['max_lat']])
        //        ->whereBetween('longitude', [$range['min_lng'], $range['max_lng']])
        //        ->get();
    }
    function getLatLngRange($lat, $lng, $distance = null)
    {

        $earthRadius = 6371; // km

        // Latitude calculation
        $latDelta = ($distance / $earthRadius) * (180 / pi());

        // Longitude calculation
        $lngDelta = ($distance / ($earthRadius * cos(deg2rad($lat)))) * (180 / pi());

        return [
            'min_lat' => round($lat - $latDelta, 7),
            'max_lat' => round($lat + $latDelta, 7),
            'min_lng' => round($lng - $lngDelta, 7),
            'max_lng' => round($lng + $lngDelta, 7),
        ];
    }
}
