<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\CategoryModel;
use App\Models\ProductAttributeModel;
use App\Models\ProductBrandModel;
use App\Models\ProductIndustryModel;
use App\Models\ProductModel;
use App\Models\ProductTypeModel;
use App\Models\SizeModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;

class ProductController extends Controller
{
    public function products()
    {
        $records   =  ProductModel::orderBy('id', 'ASC')->get();
        return view('backend.products.list', compact('records'));
    }

    public function addProduct($id = '')
    {
        $categoryData  = CategoryModel::Where('status', 1)->get();
        $sizeData      = SizeModel::Where('status', 1)->get();
        $industryData  = ProductIndustryModel::Where('status', 1)->get();
        $typeData      = ProductTypeModel::Where('status', 1)->get();
        $brandData     = ProductBrandModel::Where('status', 1)->get();
        if ($id > 0) {
            $record = ProductModel::Where('id', $id)->first();
            return view('backend.products.edit', compact('record', 'categoryData', 'sizeData', 'brandData', 'typeData', 'industryData'));
        } else {
            return view('backend.products.add', compact('categoryData', 'sizeData', 'typeData', 'brandData', 'industryData'));
        }
    }

    public function storeUpdateproducts(Request  $request)
    {
        $input         = $request->all();
        $id            = $input['id'];
        $product_name  = isset($input['product_name']) ? $input['product_name'] : '';
        $category_id   = isset($input['category_id']) ? $input['category_id'] : '';
        $industry_id   = isset($input['industry_id']) ? $input['industry_id'] : '';
        $brand_id             = isset($input['brand_id']) ? $input['brand_id'] : '';
        $type_id                   = isset($input['type_id']) ? $input['type_id'] : '';
        $product_description       = isset($input['product_description']) ? $input['product_description'] : '';
        $product_type       = isset($input['size_type']) ? $input['size_type'] : '';
        $product_size       = isset($input['size']) ? $input['size'] : '';


        if ($id == "") {
            /* Insert */
            $insertArr = array(
               'product_name'    => $product_name,
               'category_id'    => implode(",",$category_id),
               'industry_id'    => implode(",",$industry_id),
               'brand_id'    => implode(",",$brand_id),
               'type_id'    => $type_id,
               'product_description'    => $product_description,
            );

            $insert = ProductModel::create($insertArr);
            if($insert['id'] > 0)
            {
                if ($request->hasFile('product_image')) {

                $images = $request->file('product_image');
                foreach($images as $key=>$image)
                {
                    $imageName = 'product_image' . time() . '_' . str_replace(' ', '_', $image->getClientOriginalName());
                    $image->move(public_path('/uploads/product_image/'), $imageName);
                    $imageUrl = URL::to('/') . '/uploads/product_image/' . $imageName;
                    $insertAr = array(
                        'product_id' => $insert['id'],
                        'product_image'  => $imageUrl,
                        'product_type'   => $product_type[$key],
                        'product_size'   => $product_size[$key]
                    );
                    ProductAttributeModel::create($insertAr);
                }
              }
              return redirect()->route('products')->with('success', 'Pages Saved Successfully');
            }
        }
    }
}
