 @extends('backend.app_template')
@section('title','Settings')
@section('content')
 <?php
 $id                = isset($record->id) ? $record->id:'';
 $app_time          = isset($record->app_time) ? $record->app_time:'';
 $web_time          = isset($record->web_time) ? $record->web_time:'';
 $type              = ($id == '')   ? 'Create':'Update';

 ?>
 <main class="app-wrapper">
            <div class="container-fluid">

                <div class="d-flex align-items-center mt-2 mb-2">

                    <div class="flex-shrink-0">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb justify-content-end mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0)">Settings</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Update</li>
                            </ol>
                        </nav>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-12 col-xxl-12">
                        <form method="POST"  action="<?= route('storeSettings') ?>" enctype="multipart/form-data">
                           @csrf
                            <div>
                                <div class="card">
                                    <span></span>
                                    <!-- Logistics Details Section -->
                                    <div class="card-header">
                                        <h5 class="mb-0">Update Settings</h5>
                                        <div class="float-end">
                                            <a href="<?=  route('settings') ?>" class="btn btn-primary" >Back</a>
                                        </div>
                                    </div>

                                    <div class="card-body">
                                        <div class="row g-4">
                                            <div class="col-xl-4">
                                                <label for="app_time" class="form-label">App Time (in seconds) <span class="text-danger"> *</span></label>
                                                <input type="number" value="<?= $app_time ?>"  class="form-control" id="app_time" name="app_time" placeholder="Enter App Time">
                                                 @error('app_time') <span class="text-danger">{{$message}}</span> @enderror
                                            </div>


                                            <div class="col-xl-4">
                                                <label for="web_time" class="form-label">Web Time (in seconds)  <span class="text-danger"> *</span></label>
                                                <input type="number" value="<?= $web_time ?>"  class="form-control" id="web_time" name="web_time" placeholder="Enter Web Time">
                                                 @error('web_time') <span class="text-danger">{{$message}}</span> @enderror
                                            </div>


                                        </div>


                                    </div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-end gap-3 my-5">
                                <a href="" class="btn btn-light-light text-muted">Cancel</a>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>

                </div>
                <!-- Submit Section -->
            </div>
        </main>
    <script>
        $(function() {
       $("#countryForm").validate({
         rules: {
           body_type: {  required: true },

         },
         messages: {
           body_type: { required: "Please enter Body Type" },
         },
         errorElement: "span",
         errorPlacement: function(error, element) {
           error.addClass("text-danger");
           error.insertAfter(element);
         }
       });
     });
    </script>
@endsection
