@include('base.header')
<style>
    #ageModal {
        display: none;
        /* important */
    }

    .alertpopup {
        z-index: 9999;
        margin-top: -10px !important;
    }

    .location-search-container {
        /* New styles for centering the input within its container */
        display: flex;
        /* Enable Flexbox */
        justify-content: center;
        /* Center horizontally */
        align-items: center;
        /* Center vertically (if needed) */
    }

    /* Ensure the input itself doesn't stretch beyond a readable width,
   or allow it to take the full width if that's desired for mobile UX */
    .location-search-container input {
        max-width: 80%;
        /* Limit width to 80% of the container for a centered look */
    }

    .select2-container {
        width: 374.604px !important;
    }
</style>
@if (session('no_data'))
    <div class="toast-container position-fixed top-0 start-50 translate-middle-x p-3 mt-4 alertpopup" style="">
        <div id="errorToast" class="toast show" role="alert"
            style="min-width: 250px; border-radius:10px; box-shadow:0 4px 12px rgba(0,0,0,0.2);">
            <div class="d-flex align-items-center p-3">
                <span class="me-3 text-danger fs-3">❗</span>
                <span class="flex-grow-1 fs-5">{{ session('no_data') }}</span>
                <button type="button" class="btn-close ms-2" data-bs-dismiss="toast"></button>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        var toastEl = document.getElementById('errorToast');
        var toast = new bootstrap.Toast(toastEl, {
            delay: 3000
        });
        toast.show();
    </script>
@endif

<!-- ================= SERVICE FORM START ================= -->
<!-- jQuery FIRST -->
<div class="request_container">
    <div class="request_container">

    </div>
    <div class="request_heading_bold"></div>
    <div class="home-title">
        <p class="form-title text-center mb-4 mt-5">Welcome to <strong>Find Flicker</strong><br> Your Convenient
            Service
            Connection</>
    </div>
    <form action="{{ route('sendRequest') }}" method="POST">
        @csrf



        <div class="row main_form-con px-4 py-4 ">

            <input type="hidden" id="full_address">

            <div class="row">
                <div class="col-md-4"></div>
                <div class="col-md-4">
                    <label class="form-label">Service*</label>
                    <select id="service_input" class="custom-input " name="service">
                        <button>
                            <selectedcontent></selectedcontent>
                        </button>
                        {{-- <option value="Escorts">Escorts </option>
                    <option value="Individual">Individual </option>
                    <option value="Spa&Massage">Spa & Massage </option>
                    <option value="Audio&VideoCalls">Audio & Video Calls </option>
                    <option value="All">All </option> --}}
                        @foreach ($serviceTypeModels as $serviceTypeModel)
                            <option value="{{ $serviceTypeModel->id }}">{{ $serviceTypeModel->service_type }}</option>
                        @endforeach
                    </select>
                </div>
            </div>




            <div class="row country-section  mt-3">
                <div class="col-md-4"></div>
                <div class="col-md-4">
                    <label class="form-label">Country*</label>
                    <select class="custom-input" id="countrySelect" name="country" style="width: 374.604px!important;">

                        <option value="">Select Country</option>
                        @foreach ($countryModels as $country)
                            <option value="{{ $country->iso3 }}" data-flag="{{ $country->country_flag }}">
                                {{ $country->name }}</option>
                        @endforeach


                    </select>
                </div>
            </div>

            <div class="row language-section mt-3" style="display:none!important">
                <div class="col-md-4"></div>
                <div class="col-md-5">
                    <label class="form-label">Language</label>
                    <div class="multi-select-box">
                        <select class="custom-input" id="languageSelect" name="languages[]" multiple
                            style="width: 374.604px!important;">
                            <option value="">Select Language</option>
                            @foreach ($languageModels as $languageModel)
                                <option value="{{ $languageModel->id }}">{{ $languageModel->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

            <div class="row location-section mt-3">
                <div class="col-md-4"></div>

                <div class="col-md-4">
                    <label class="form-label">Location*</label>
                    <div class="input-group">
                        <span class="input-group-text icon-bg">
                            <i class="fa-solid fa-location-dot"></i>
                        </span>
                        <input type="text" id="preferred_location" name="preferred_location"
                            oninput="getPreferedLocation()" class="form-control custom-input"
                            placeholder="Enter your preferred location" autocomplete="off" value="">
                    </div>
                    <div style="display: flex; align-items: center; gap: 5px;margin-top:15px">
                        <img class="location-icon" src="{{ asset('assets') }}/image/icon 2.png" alt="Location Icon"
                            style="height: 20px; width: 20px;">
                        <a href="javascript:void(0)" class="current-location" onclick="fetchAddress()">
                            <h6 style="margin: 0; text-decoration: underline;">Use current location</h6>
                        </a>
                    </div>

                </div>
            </div>


            <div class="row price-section mt-3">
                <div class="col-md-4"> </div>


                <div class="col-md-8  mb-1 ">
                    <label class="form-label">Hourly Price</label>
                </div>


                <div class="col-md-4"> </div>
                <div class="col-md-2 mb-3">
                    <div class="input-group">
                        <span class="input-group-text icon-bg PriceSymbol">$</span>
                        <input type="text" name="hourly_min" id="hourly_min" class="form-control custom-input"
                            placeholder="1000" oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                    </div>
                </div>

                <div class="col-md-2 mb-3">
                    <div class="input-group">
                        <span class="input-group-text icon-bg PriceSymbol">$</span>
                        <input type="text" name="hourly_max" id="hourly_max" class="form-control custom-input"
                            placeholder="10000" oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                    </div>
                </div>


                <div class="col-md-4"> </div>
                <div class="col-md-4"> </div>

                <div class="col-md-8 mt-2 mb-1 ">
                    <label class="form-label ">Nightly Price</label>
                </div>

                <div class="col-md-4"> </div>
                <div class="col-md-2  mb-3 ">
                    <div class="input-group ">
                        <span class="input-group-text icon-bg PriceSymbol">$</span>
                        <input type="text" name="nightly_min" id="nightly_min"class="form-control custom-input"
                            placeholder="10000">
                    </div>
                </div>
                <div class="col-md-2 mb-3 ">
                    <div class="input-group">
                        <span class="input-group-text icon-bg PriceSymbol">$</span>
                        <input type="text" name="nightly_max" id="nightly_max" class="form-control custom-input"
                            placeholder="20000">
                    </div>
                </div>
                <input type="hidden" name="latitude" value="" id="formLatitude">
                <input type="hidden" name="longitude" value="" id="formLangValue">


                <!-- SERVICE AVAILABILITY -->
                <div class="row mb-3">
                    <div class="col-md-4"></div>
                    <div class="col-md-4">
                        <label class="form-label">Service Availability</label>

                        <div class="d-flex gap-4 align-items-center">
                            <label class="mb-0">
                                <input type="radio" name="availability" value="1"> Incall
                            </label>
                            <label class="mb-0">
                                <input type="radio" name="availability" value="2"> Outcall
                            </label>
                            <label class="mb-0">
                                <input type="radio" name="availability" value="3"> Both
                            </label>
                        </div>
                    </div>
                </div>


            </div>



            <div class="row">
                <div class="col-lg-4 "> </div>
                <div class="col-lg-4 mt-3 text-center ">
                    <button class="submit-btn w-100" id="sendRequestBtn">Send Request</button>
                </div>
            </div>


        </div>


    </form>

</div>

<div id="ageModal" class="age-overlay">
    <div class="age-popup">
        <div class="age-icon">18+</div>

        <h2 class="age-title">ADULTS ONLY</h2>

        <p class="age-text">
            This website contains content intended for adults 18 years and older.
            By entering, you confirm that you are at least 18 years old and understand
            that this site may contain adult-oriented material.
        </p>

        <h3 class="age-question">Are you 18 years of age or older?</h3>

        <div class="age-btn-group">
            <button class="btn-no" id="btnNo">No, Take Me Back</button>
            <button class="btn-yes" id="btnYes">Yes, I'm 18+</button>
        </div>
    </div>
</div>




<div id="mapModal" class="modal" style="display:none;">

    <div class="modal-content p-3">
        <div class="modal-title">
            Pick your places
            <button class="close-modal-btn" onclick="closeMapModal()">×</button>
        </div>

        <div class="location-search-container mt-3 mb-3">
            <input type="text" id="locationSearchInput" placeholder="Search for a location..."
                class="form-control custom-input">
        </div>
        <div class="map-modal-div mt-2" id="map"></div>

        <p class="mt-2"><b>Full Address:</b> <br><span class="address-text" id="fullAddress"></span></p>
        <p><b>Short Address:</b> <br> <span class="address-text" id="shortAddress"></span></p>
        {{-- <p style="display: none"><b>Latitude:</b> <span id="latValue">--</span></p>
        <p style="display: none"><b>Longitude:</b> <span id="lngValue">--</span></p> --}}

        <button onclick="saveLocation()" class="btn map-button">Save location</button>
    </div>
</div>


@include('base.footer')
<script>
    // Run on page load
</script>

<script>
    let map, marker, geocoder;
    let selectedLat = null;
    let selectedLng = null;

    function formatCountry(option) {
        if (!option.id) return option.text;

        const flag = $(option.element).data('flag');

        return $(`
            <span style="display:flex;align-items:center;gap:8px;">
                <img src="${flag}" 
                     style="width:18px;height:14px;border-radius:2px;object-fit:cover;" />
                <span>${option.text}</span>
            </span>
        `);
    }

    function validateForm() {
        console.log("working");

        const service = $('#service_input').val();
        const languageVals = $('#languageSelect').val();
        const country = $('#countrySelect').val();
        let locationRaw = $('#preferred_location').val();
        console.log("RAW =", JSON.stringify(locationRaw));

        let location = locationRaw.trim();
        console.log("TRIM =", JSON.stringify(location));

        location = location === "" ? false : location;
        console.log("FINAL =", location);
        let latitude = $("#formLatitude").val();
        let longitude = $("#formLangValue").val();


        const mandatory1_2_5 = ["1", "2", "5"];
        let valid = false;

        // --------- COMMON FIELD VALUES ----------
        const hourlyMin = $('#hourly_min').val().trim();
        const hourlyMax = $('#hourly_max').val().trim();
        const nightlyMin = $('#nightly_min').val().trim();
        const nightlyMax = $('#nightly_max').val().trim();
        const availability = $('input[name="availability"]:checked').length > 0;

        // ============================
        // VALIDATION FOR HOURLY RANGE
        // ============================
        let hourlyValid = true;

        if (hourlyMin || hourlyMax) {
            // If any one value exists → both required
            if (!hourlyMin || !hourlyMax) {
                hourlyValid = false;
            } else {
                const minH = parseInt(hourlyMin);
                const maxH = parseInt(hourlyMax);

                if (!Number.isInteger(minH) || !Number.isInteger(maxH) ||
                    minH <= 0 || maxH <= 0 || maxH <= minH) {
                    hourlyValid = false;
                }
            }
        }

        // =============================
        // VALIDATION FOR NIGHTLY RANGE
        // =============================
        let nightlyValid = true;

        if (nightlyMin || nightlyMax) {
            if (!nightlyMin || !nightlyMax) {
                nightlyValid = false;
            } else {
                const minN = parseInt(nightlyMin);
                const maxN = parseInt(nightlyMax);

                if (!Number.isInteger(minN) || !Number.isInteger(maxN) ||
                    minN <= 0 || maxN <= 0 || maxN <= minN) {
                    nightlyValid = false;
                }
            }
        }

        // ===============================
        // SERVICE TYPE 1, 2, 5 VALIDATION
        // ===============================
        console.log("===== FORM DEBUG LOG =====");
        console.log({
            country: country,
            location: location,
            latitude: latitude,
            longitude: longitude,
            hourlyValid: hourlyValid,
            nightlyValid: nightlyValid
        });
        console.log("==========================");


        if (mandatory1_2_5.includes(service)) {
            if (
                country &&
                location &&
                hourlyValid && latitude && longitude &&
                nightlyValid
            ) {
                valid = true;
            }
            console.log("valid value", valid);

            // ===============================
            // SERVICE TYPE 3 → Only country + location
            // ===============================
        } else if (service == "3") {
            if (country && (location)) {
                valid = true;
            }

            // ===============================
            // SERVICE TYPE 4 → Only language required
            // ===============================
        } else if (service == "4") {
            if (languageVals && languageVals.length > 0) {
                valid = true;
            }
        }

        // Enable / Disable Button
        if (valid == true) {
            $('#sendRequestBtn')
                .prop('disabled', false)
                .css('background', 'linear-gradient(rgb(168, 28, 52) 0%, rgb(168, 28, 52) 100%)');
        } else {
            $('#sendRequestBtn').prop('disabled', true);
        }

        return valid;
    }
    // localStorage.removeItem("ageVerified");
    $('#service_input').select2({
        placeholder: "Select Service Type",

    });
    $('#languageSelect').select2({
        placeholder: "Select languages",

    });
    // $('#countrySelect').select2({
    //     placeholder: "Select Country",

    //     width: "100%"
    // });
    $('#countrySelect').select2({
        templateResult: formatCountry,
        templateSelection: formatCountry,
        placeholder: "Select Country",
       // allowClear: true,
        width: '100%'
    });


    $(document).ready(function() {
        loadDefaultCountry();





        $('#sendRequestBtn').prop('disabled', true);
        // wire many input events to validation
        $(document).on('input change',
            '#hourly_min, #hourly_max, #nightly_min, #nightly_max,#countrySelect, #languageSelect, input[name="availability"]',
            function() {
                validateForm();
            });
        $(document).on('blur',
            '#preferred_location',
            function() {
                getPreferedLocation();
            });

        let minValue = 1; // Set your global minimum



        if (localStorage.getItem("ageVerified") === "yes") {
            document.getElementById("ageModal").classList.add("hide");
        }

        document.getElementById("btnYes").onclick = function() {
            localStorage.setItem("ageVerified", "yes");
            document.getElementById("ageModal").classList.add("hide");
        };

        document.getElementById("btnNo").onclick = function() {
            window.location.href = "https://google.com";
        };


        function updateSections() {
            var value = $("#service_input").val().trim();
            console.log(value);

            // Default show
            $(".price-section").show();
            $(".country-section").show();
            $(".location-section").show();
            $(".language-section").hide();
            //   $("#languageSelect").css("display", "none");

            if (value == "3") {
                $(".price-section").hide();
            }

            if (value == "4") {
                if (!$("#countrySelect").val()) {
                    loadDefaultCountry();
                }

                //loadDefaultCountry();
                $(".price-section").hide();
                $(".country-section").hide();
                $(".location-section").hide();
                $(".language-section").show();
            }

        }


        updateSections();

        $("#service_input").on("change", function() {
            console.log("this worked ");

            updateSections();
        });

    });

    // $("#countrySelect").on("change", function() {
    //     let countryId = $(this).val();

    //     if (countryId === "") return;

    //     $.ajax({
    //         url: "/get-currency",
    //         type: "POST",
    //         data: {
    //             country_id: countryId,
    //             _token: "{{ csrf_token() }}"
    //         },
    //         success: function(response) {
    //             console.log(response);
    //             if (response.status) {
    //                 let currency = response.currency;
    //                 console.log(currency);

    //                 // Auto-fill your currency input box
    //                 $(".PriceSymbol").text(currency.symbol);

    //                 console.log("Currency Loaded:", currency);
    //             } else {
    //                 console.log(response.message);
    //             }
    //         }
    //     });
    // });
    $("#countrySelect").on("change", function() {
        console.log("check id", $(this).val());

        loadCurrencyByCountry();
    });

    function loadCurrencyByCountry() {
        let countryId = $('#countrySelect').val();
        console.log(countryId);

        if (!countryId) return;

        $.ajax({
            url: "/get-currency",
            type: "POST",
            data: {
                country_id: countryId,
                _token: "{{ csrf_token() }}"
            },
            success: function(response) {
                if (response.status) {
                    $(".PriceSymbol").text(response.currency.symbol);
                } else {
                    console.log(response.message);
                }
            },
            error: function(err) {
                console.error("Currency load failed", err);
            }
        });
    }
</script>


<script
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyABOyILyRqsygsw6SVGj_kVNwi_x0CVzVI&libraries=places,marker"
    async defer></script>

<script src="{{ asset('assets/js/location.js') }}"></script>



<script>
    let country = null;
    // main.js
    function fetchAddress() {


        getCurrentAddress()
            .then(function(res) {
                console.log(res);

                document.getElementById("formLatitude").value = res.latitude;
                document.getElementById("formLangValue").value = res.longitude;

                setCountryDropdown(res.country);

                $('#preferred_location').val(res.address);
                validateForm();
            })
            .catch(function(err) {
                console.log(err);
                document.getElementById("preferred_location").innerHTML = err;
            });
    }

    function loadDefaultCountry() {

        console.log("thats mine");

        getCurrentAddress()
            .then(function(res) {
                console.log("Address:", res.address);
                console.log("Country:", res.country);
                console.log("Lat:", res.latitude);
                console.log("Lng:", res.longitude);
                country = res.country;
                setCountryDropdown(res.country);

                loadCurrencyByCountry();
                //document.getElementById("preferred_location").value = res.address;
            })
            .catch(function(err) {
                console.log(err);
                // document.getElementById("preferred_location").innerHTML = err;
            });
    }

    function openMapModal() {
        document.getElementById("mapModal").style.display = "block";
        setTimeout(() => {

            initMap(); // first time user

        }, 100);
    }

    function closeMapModal() {
        document.getElementById("mapModal").style.display = "none";

    }


    function getPreferedLocation() {
        const input = document.getElementById("preferred_location");

        const country = document.getElementById("countrySelect").value;

        if (country) {
            setupSearchBox(input, country);

        } // Country code must be 2 letters
    }

    function setupSearchBox(input, country = null) {
        let options = {
            fields: ["formatted_address", "geometry", "name"],
        };

        if (country) {
            options.componentRestrictions = {
                country: country
            };
            options.strictBounds = true; // enforce country boundaries
        }

        const autocomplete = new google.maps.places.Autocomplete(input, options);

        autocomplete.addListener("place_changed", function() {
            const place = autocomplete.getPlace();
            if (!place || !place.geometry) return;

            let lat1 = place.geometry.location.lat();
            let lng1 = place.geometry.location.lng();
            // console.log(place);
            // console.log(lat1.toFixed(6), lng1.toFixed(6),country);

            // Move map and marker
            //  map.setCenter({ lat: lat, lng: lng });
            // map.setZoom(15);
            // marker.setPosition(place.geometry.location);

            // Update address + lat/lng
            $("#formLatitude").val(lat1.toFixed(6));
            $("#formLangValue").val(lng1.toFixed(6));
            // getAddress({ lat: lat1, lng: lng1 });
            validateForm();
        });

    }

    function setCountryDropdown(countryName) {
        console.log("testing....");
        console.log($('#preferred_location').val());

        const select = document.getElementById("countrySelect");

        if (!select) return;
        const currentText = select.options[select.selectedIndex]?.text.trim().toLowerCase();
        const targetText = countryName.trim().toLowerCase();
        console.log("currentText", currentText);
        console.log("targetText", targetText);


        // ✅ If already selected, stop execution
        if (currentText === targetText) {
            loadCurrencyByCountry();
            console.log("Already selected, no change.");
            return;
        }

        for (let option of select.options) {
            if (option.text.trim().toLowerCase() === countryName.trim().toLowerCase()) {
                option.selected = true;
                // select.dispatchEvent(new Event("change"));
                console.log("selected, new change.");
                // $('#countrySelect').trigger('change');
                // ✅ set value (important)
                select.value = option.value;

                // ✅ trigger native + jQuery change
                select.dispatchEvent(new Event('change', {
                    bubbles: true
                }));

                // for jQuery safety

                break;
            }
        }

    }

    function getAddress(latlng) {
        console.log(latlng);
        //updateLatLngDisplay(latlng);
        $("#formLatitude").val(lat.toFixed(6));
        $("#formLangValue").val(lng.toFixed(6));
        // geocoder.geocode({
        //     location: latlng
        // }, function(results, status) {
        // if (status === "OK" && results[0]) {
        //     console.log(results[0]);
        //     const components = results[0].address_components;

        //     // Get country
        //     const country = components.find(c => c.types.includes("country"));
        //     const countryName = country ? country.long_name : null;

        //     console.log("User Country:", countryName);

        //     if (countryName) {
        //         setCountryDropdown(countryName); // Auto-select country
        //     }
        //     document.getElementById("fullAddress").innerHTML = results[0].formatted_address;

        //     const locality = results[0].address_components.find(c =>
        //         c.types.includes("locality") ||
        //         c.types.includes("sublocality") ||
        //         c.types.includes("postal_town")
        //     );

        //     const shortText = locality ? locality.long_name : results[0].address_components[1]?.long_name;

        //     document.getElementById("shortAddress").innerHTML = shortText;

        //     selectedAddress = shortText;
        // }
        //});
    }

    function updateLatLngDisplay(latlng) {
        let lat, lng;
        console.log(latlng);

        // // CASE 1: Google LatLng object → use lat()/lng()
        // if (typeof latlng.lat === "function") {
        //     lat = latlng.lat();
        //     lng = latlng.lng();
        // }
        // // CASE 2: Plain object → use lat/lng directly
        // else {
        //     lat = latlng.lat;
        //     lng = latlng.lng;
        // }
        // selectedLat = typeof latlng.lat === "function" ? latlng.lat() : latlng.lat;
        // selectedLng = typeof latlng.lng === "function" ? latlng.lng() : latlng.lng;

        // document.getElementById("latValue").innerHTML = lat.toFixed(6);
        // document.getElementById("lngValue").innerHTML = lng.toFixed(6);

        $("#formLatitude").val(lat.toFixed(6));
        $("#formLangValue").val(lng.toFixed(6));
    }

    function initMap() {

        geocoder = new google.maps.Geocoder();
        if (selectedLat && selectedLng) {
            console.log("work this first if");
            console.log(selectedLat);
            console.log(selectedLng);
            const loc = {
                lat: selectedLat,
                lng: selectedLng
            };
            loadMap(loc);
            loadMap({
                lat: selectedLat,
                lng: selectedLng
            });
        }
        // Try to get current location
        else if (navigator.geolocation) {
            console.log("work this else if");
            navigator.geolocation.getCurrentPosition(
                function(position) {
                    const loc = {
                        lat: position.coords.latitude,
                        lng: position.coords.longitude
                    };
                    loadMap(loc);
                },
                function() {
                    loadMap({
                        lat: 13.0827,
                        lng: 80.2707
                    }); // Chennai fallback
                }
            );
        } else {
            console.log("work this else");
            loadMap({
                lat: 13.0827,
                lng: 80.2707
            });
        }
    }

    function loadMap(center) {
        console.log("loadMapData ", center);

        map = new google.maps.Map(document.getElementById("map"), {
            center: center,
            zoom: 14,
            mapTypeControl: false, // Hide "Map / Satellite"
            streetViewControl: false, // Optional: Hide street view icon
            fullscreenControl: false // Optional: Hide full-screen button
        });

        // Draggable marker
        marker = new google.maps.Marker({
            position: center,
            map: map,
            draggable: true
        });

        getAddress(center);

        // Update address when marker is dragged
        google.maps.event.addListener(marker, "dragend", function() {
            getAddress(marker.getPosition());
        });

        // Update marker when map is dragged
        google.maps.event.addListener(map, "idle", function() {
            const center = map.getCenter();
            marker.setPosition(center);
            getAddress(center);
        });
        const input = document.getElementById("locationSearchInput");
        setupSearchBox(input);
    }

    function setupSearchBoxOld() {

        const input = document.getElementById("locationSearchInput");
        const searchBox = new google.maps.places.SearchBox(input);

        map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

        searchBox.addListener("places_changed", function() {
            const places = searchBox.getPlaces();
            if (places.length === 0) return;

            const place = places[0];

            if (!place.geometry) return;

            map.setCenter(place.geometry.location);
            map.setZoom(15);

            marker.setPosition(place.geometry.location);

            getAddress(place.geometry.location);
        });
    }

    // function saveLocation() {
    //     document.getElementById("preferred_location").value = selectedAddress;
    //     // selectedLat = typeof latlng.lat === "function" ? latlng.lat() : latlng.lat;
    //     // selectedLng = typeof latlng.lng === "function" ? latlng.lng() : latlng.lng;
    //     let formLat = document.getElementById("latValue").textContent;
    //     let formLang = document.getElementById("lngValue").textContent;
    //     // console.log(selectedLng);


    //     document.getElementById("formLatitude").value = formLat;
    //     document.getElementById("formLangValue").value = formLang;

    //     closeMapModal();

    // }
</script>
