<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\EyeModel;
use Illuminate\Http\Request;

class EyeController extends Controller
{
     public function eye()
    {
        $records   =  eyeModel::orderBy('eye_color', 'ASC')->get();
        return view('backend.eye.list', compact('records'));
    }

    public function addEye($id = '')
    {
        $record = '';
        if ($id > 0) {
            $record = EyeModel::WHere('id', $id)->first();
        }
        return view('backend.eye.add_edit', compact('record'));
    }

    public function storeUpdateEye(Request $request)
    {
        $input     = $request->all();
        $id        = isset($input['id']) ? $input['id'] : 0;

        $dataArr = [];
        foreach ($input as $key => $val) {
            if ($key != '_token' && $key != 'id' )
                $dataArr[$key] = $val;
        }

       
        if ($id == 0 || $id == '') {
            $request->validate([
                'eye_color'          =>  "required|unique:eye,eye_color",
              
            ]);
           $insert = EyeModel::create($dataArr);
           if($insert['id'] > 0)
           {
               return redirect()->route('eye')->with('success', 'Eye Saved Successfully');
           }else{
               return redirect()->route('eye')->with('error', 'Something went wrong!');
           }
           
        } else {
            $request->validate([
                'eye_color'          =>  "required",               
            ]);
            $update = EyeModel::Where('id',$id)->update($dataArr);
            return redirect()->route('hair')->with('success', 'Eye Updated Successfully');;
        }        
    }
}
