 @extends('backend.app_template')
@section('title','Body Type Store or Update')
@section('content')
 <?php 
 $id                = isset($record->id) ? $record->id:'';
 $body_type              = isset($record->body_type) ? $record->body_type:''; 
 $type              = ($id == '')   ? 'Create':'Update';
 
 ?>
 <main class="app-wrapper">
            <div class="container-fluid">

                <div class="d-flex align-items-center mt-2 mb-2">
                    
                    <div class="flex-shrink-0">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb justify-content-end mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0)">Body Type</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?= $type ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-12 col-xxl-12">
                        <form method="POST" id="countryForm" action="<?= route('storeUpdateBodyType') ?>" enctype="multipart/form-data">
                           @csrf
                            <div>
                                <div class="card">
                                    <span></span>
                                    <!-- Logistics Details Section -->
                                    <div class="card-header">
                                        <h5 class="mb-0"><?= $type ?> Body Type</h5>
                                        <div class="float-end">
                                            <a href="<?=  route('bodyType') ?>" class="btn btn-primary" >Back</a>
                                        </div>
                                    </div>
                                    <input type="hidden" name="id" value="<?= $id ?>" />
                                    <div class="card-body">
                                        <div class="row g-4">
                                            <div class="col-xl-4">
                                                <label for="body_type" class="form-label">Body Type <span class="text-danger"> *</span></label>
                                                <input type="text" value="<?= $body_type ?>"  class="form-control" id="body_type" name="body_type" placeholder="Enter Body Type">
                                                 @error('body_type') <span class="text-danger">{{$message}}</span> @enderror
                                            </div>
                                           
                                        </div>

                                    </div>
                                </div>                               
                            </div>
                            <div class="d-flex justify-content-end gap-3 my-5">
                                <a href="" class="btn btn-light-light text-muted">Cancel</a>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                   
                </div>
                <!-- Submit Section -->
            </div>
        </main>
    <script>
        $(function() {
       $("#countryForm").validate({
         rules: {
           body_type: {  required: true },
        
         },
         messages: {
           body_type: { required: "Please enter Body Type" },          
         },
         errorElement: "span",
         errorPlacement: function(error, element) {
           error.addClass("text-danger");
           error.insertAfter(element);
         }
       });
     });
    </script>    
@endsection