<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Carbon\Carbon;

class ServiceRequest extends Model
{
    protected $fillable = [
        'request_id',
        'service_id',
        'service_request_type_id',
        'number',
        'customer_id',
        'start_time',
        'end_time',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            // Generate random 4-char alphanumeric
            $model->customer_id = strtoupper(Str::random(4));
            $model->start_time = Carbon::now('Asia/Kolkata');
            $model->end_time   = Carbon::now('Asia/Kolkata')->addMinutes(5);
        });
    }
}
