 @extends('backend.app_template')
@section('title','Page Store or Update')
@section('content')
 <?php 
 $id                = isset($record->id) ? $record->id:'';
 $content_type      = isset($record->type) ? $record->type:''; 
 $title             = isset($record->title) ? $record->title:''; 
 $content           = isset($record->content) ? $record->content:''; 
 $type              = ($id == '')   ? 'Create':'Update';
 
 ?>
 <main class="app-wrapper">
            <div class="container-fluid">

                <div class="d-flex align-items-center mt-2 mb-2">
                    
                    <div class="flex-shrink-0">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb justify-content-end mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0)">Page</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?= $type ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-12 col-xxl-12">
                        <form method="POST" id="countryForm" action="<?= route('storeUpdatePage') ?>" enctype="multipart/form-data">
                           @csrf
                            <div>
                                <div class="card">
                                    <span></span>
                                    <!-- Logistics Details Section -->
                                    <div class="card-header">
                                        <h5 class="mb-0"><?= $type ?> Page</h5>
                                        <div class="float-end">
                                            <a href="<?=  route('pages') ?>" class="btn btn-primary" >Back</a>
                                        </div>
                                    </div>
                                    <input type="hidden" name="id" value="<?= $id ?>" />
                                    <div class="card-body">
                                        <div class="row g-4">
                                            <div class="col-xl-6">
                                                <label for="name" class="form-label">Page Type<span class="text-danger"> *</span></label>
                                                <select  class="form-control select2" id="type" name="type" >
                                                    <option value="">--select--</option>
                                                    <option <?php echo (isset($content_type) && $content_type == 1) ? 'selected' :( ($id != '') ? 'disabled':'')  ?> value="1">Privacy & Policy</option>
                                                    <option <?php echo (isset($content_type) && $content_type == 2) ? 'selected' : ( ($id != '') ? 'disabled':'') ?> value="2">Terms & Condition</option>                                    
                                                </select>
                                                 @error('name') <span class="text-danger">{{$message}}</span> @enderror
                                            </div>  
                                             <div class="col-xl-6">
                                                <label for="name" class="form-label">Page Title<span class="text-danger"> *</span></label>
                                                 <input type="text" value="<?= $title ?>"  class="form-control" id="title" name="title" placeholder="Enter Page Title">
                                                 @error('title') <span class="text-danger">{{$message}}</span> @enderror
                                            </div>    
                                            <div class="col-xl-12">
                                                 <label for="name" class="form-label">Page Content</label>
                                                 <textarea required class="form-control" id="content" name="content" rows="6"><?= $content ?></textarea>
                                            </div>                             
                                        </div>

                                    </div>
                                </div>                               
                            </div>
                            <div class="d-flex justify-content-end gap-3 my-5">
                                <a href="" class="btn btn-light-light text-muted">Cancel</a>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                   
                </div>
                <!-- Submit Section -->
            </div>
        </main>
        <script type="text/javascript" src="//cdn.ckeditor.com/4.5.1/standard/ckeditor.js"></script>
    <script>

        		CKEDITOR.config.versionCheck = false;
		 CKEDITOR.replace('content');

        $(function() {
       $("#countryForm").validate({
         rules: {
           type: {  required: true },
           title: {  required: true },           
        
         },
         messages: {
           type: { required: "Please choose type" },          
           title: { required: "Please enter title" },          
         },
         errorElement: "span",
         errorPlacement: function(error, element) {
           error.addClass("text-danger");
           error.insertAfter(element);
         }
       });
     });
    </script>    
@endsection