 @extends('backend.app_template')
@section('title','Country Store or Update')
@section('content')
 <?php 
 $id                = isset($record->id) ? $record->id:'';
 $country_name      = isset($record->name) ? $record->name:'';
 $country_code      = isset($record->phone_code) ? $record->phone_code:'';
 $currency_name     = isset($record->currency_name) ? $record->currency_name:'';
 $currency_code     = isset($record->currency_code) ? $record->currency_code:'';
 $type              = ($id == '')   ? 'Create':'Update';
 
 ?>
 <main class="app-wrapper">
            <div class="container-fluid">

                <div class="d-flex align-items-center mt-2 mb-2">
                    
                    <div class="flex-shrink-0">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb justify-content-end mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0)">Country</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?= $type ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-12 col-xxl-12">
                        <form method="POST" id="countryForm" action="<?= route('storeUpdateCountry') ?>" enctype="multipart/form-data">
                           @csrf
                            <div>
                                <div class="card">
                                    <span></span>
                                    <!-- Logistics Details Section -->
                                    <div class="card-header">
                                        <h5 class="mb-0"><?= $type ?> Country</h5>
                                        <div class="float-end">
                                            <a href="<?=  route('country') ?>" class="btn btn-primary" >Back</a>
                                        </div>
                                    </div>
                                    <input type="hidden" name="id" value="<?= $id ?>" />
                                    <div class="card-body">
                                        <div class="row g-4">
                                            <div class="col-xl-4">
                                                <label for="country_name" class="form-label">Country Name <span class="text-danger"> *</span></label>
                                                <input type="text" value="<?= $country_name ?>"  class="form-control" id="country_name" name="name" placeholder="Enter Country name">
                                                 @error('name') <span class="text-danger">{{$message}}</span> @enderror
                                            </div>
                                             <div class="col-xl-4">
                                                <label for="country_code" class="form-label">Country Code <span class="text-danger"> *</span></label>
                                                <input type="text" value="<?= $country_code ?>"  class="form-control" id="country_code" name="phone_code" placeholder="Enter Country Code">
                                                @error('country_code') <span class="text-danger">{{$message}}</span> @enderror
                                            </div>
                                            <div class="col-xl-4">
                                                <label for="currency_name" class="form-label">Currency Name <span class="text-danger"> *</span></label>
                                                <input type="text" value="<?= $currency_name ?>"  class="form-control" id="currency_name" name="currency_name" placeholder="Enter Currency Name">
                                                 @error('currency_name') <span class="text-danger">{{$message}}</span> @enderror
                                            </div>
                                            <div class="col-xl-4">
                                                <label for="currency_code" class="form-label">Currency Code <span class="text-danger"> *</span></label>
                                                <input type="text" value="<?= $currency_code ?>"  class="form-control" id="currency_code" name="currency_code" placeholder="Enter Company Name">
                                                 @error('currency_code') <span class="text-danger">{{$message}}</span> @enderror
                                            </div>
                                            <div class="col-xl-4">
                                                <label for="flag_image" class="form-label">Flag Image</label>
                                                <input type="file" accept="image/png, image/jpeg,image/svg" class="form-control" name="flag_image" >
                                            </div>
                                        </div>

                                    </div>
                                </div>                               
                            </div>
                            <div class="d-flex justify-content-end gap-3 my-5">
                                <a href="" class="btn btn-light-light text-muted">Cancel</a>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                   
                </div>
                <!-- Submit Section -->
            </div>
        </main>
    <script>
        $(function() {
       $("#countryForm").validate({
         rules: {
           name: {  required: true },
           phone_code: {  required: true },
           currency_name: {  required: true },
           currency_code: {  required: true },

         },
         messages: {
           name: { required: "Please enter country name" },
           phone_code: { required: "Please enter country code" },
           currency_name: { required: "Please enter currency name" },
           currency_code: { required: "Please enter currency code" },
         },
         errorElement: "span",
         errorPlacement: function(error, element) {
           error.addClass("text-danger");
           error.insertAfter(element);
         }
       });
     });
    </script>    
@endsection