 @extends('backend.app_template')
 @section('title','Ads Verification')
 @section('content')
 <main class="app-wrapper">
     <div class="container-fluid">

         <div class="d-flex align-items-center mt-2 mb-2">
             <h6 class="mb-0 flex-grow-1">Ads Verification</h6>
             <div class="flex-shrink-0">
                 <nav aria-label="breadcrumb">
                     <ol class="breadcrumb justify-content-end mb-0">
                         <li class="breadcrumb-item"><a href="javascript:void(0)">Pages</a></li>
                         <li class="breadcrumb-item active" aria-current="page">Ads Verification</li>
                     </ol>
                 </nav>
             </div>
         </div>
         <div class="row">
             <div class="card">
                 <div class="card-body">
                     <form method="POST" action="<?= route('ads-verification') ?>">
                        @csrf
                         <div class="row">
                             <div class="col-md-4">
                                 <label>Select Date Range</label>
                                 <input type="text" id="range-picker"  class="form-control" value="<?= isset($from) ? $from:'' ?>" name="from" />
                             </div>
                             
                             
                         </div>
                         <div class="d-flex mt-2">
                                <input type="submit" name="submit" value="Search" class="btn btn-primary" />
                         </div>
                         

                     </form>
                 </div>
             </div>

             <table id="datatables" class="table table-responsive   table-bordered w-100 mt-5">
                 <thead>
                     <tr>
                         <th>S.No</th>
                         <th>Service Name</th>                        
                         <th>Contact</th>
                         <th>Date Submitted</th>                        
                         <th>Verification Video</th>
                         <th>View Details</th>
                         <th>Action</th>                     
                     </tr>
                 </thead>
                 <tbody>
                     <?php if (isset($records)) {
                            $i = 1;
                            foreach ($records as $key => $row) {
                        ?>
                             <tr>
                                 <td><?php echo $i ?></td>
                                 <td><?php echo $row->name ?></td>                                 
                                 <td><?php echo $row->phone ?></td>
                                 <td><?php echo date('d M Y',strtotime($row->created_at)) ?></td>
                                 <td>
                                    <a data-placement="top" title="Verify" data-original-title="Verify" href="javascript:void(0)" onclick="watchVideo('<?php echo $row->vedio ?>')" class="badge bg-pill bg-<?php echo ($row->status == 1) ? 'success' :(($row->status == 2) ? 'warning':'danger')  ?>"><i class="bi bi-file-play"></i> Watch</a>
                                     
                                </td>
                                 <td>
                                    <a onclick="showDetails('<?= $row->service_id ?>')" href="javascript:void(0)"  class="badge bg-pill bg-danger"><i class="bi bi-eye"></i> View</a>
                                 </td>
                                <td>
                                    <a data-bs-toggle="tooltip" data-bs-title="<?= ($row->status == 2) ? 'Un Verify':'Verify' ?>" title="<?= ($row->is_verified == 2) ? 'Un Verify':'Verify' ?>" data-original-title="<?= ($row->is_verified == 2) ? 'UnBlock':'Block' ?>" href="javascript:void(0)" onclick="changeStatus('<?php echo $row->id ?>','2','PersonalDetails')" class="btn btn-sm btn-<?= ($row->is_verified == 2) ? 'danger':'success' ?>"><i class="<?= ($row->is_verified == 2) ? 'bi bi-shield-fill-x':'bi bi-shield-fill-check' ?> "></i></a>                                   
                                    <a data-bs-toggle="tooltip" data-bs-title="Reject" title="Reject" data-original-title="Reject" href="javascript:void(0)" onclick="changeStatus('<?php echo $row->id ?>','3','PersonalDetails')" class="btn btn-sm btn-danger"><i class="bi bi-shield-fill-x"></i></a>                                   
                                </td>           
                             </tr>
                     <?php $i++;
                            }
                        } ?>

                 </tbody>
             </table>
         </div>
     </div>
 </main>
 <div class="modal fade" id="videoModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalLabel">
                   Verification Video
                </h5>
                <button type="button" class="btn-close icon-btn-sm" data-bs-dismiss="modal" aria-label="Close">
                    <i class="ri-close-large-line fw-semibold"></i>
                </button>
            </div>
            <div class="modal-body">
                 <video id="modalVideo" width="100%" height="430" controls>
                    <source id="videoSource" src="" type="video/mp4">
                    Your browser does not support the video tag.
                </video>
            </div>           
        </div>
    </div>
</div>
 <script>
    function watchVideo(url)
    {
        const videoSrc = $("#videoSource");
        const video = $("#modalVideo")[0];
        $('#videoModal').modal('show');
        videoSrc.attr("src", url);   
        video.load();
        video.play();
    }
 </script>
 @endsection