<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\User;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckSession
{


    public function handle($request, Closure $next)
    {
        $userId = $request->header('User-Id');
        $sessionId = $request->header('Session-Id');

        if (!$userId || !$sessionId) {
            return response()->json(["message" => "Unauthorized"], 401);
        }

        $user = User::find($userId);

        if (!$user || $user->session_id !== $sessionId) {
            return response()->json(["message" => "Session Expired"], 401);
        }

        return $next($request);
    }

}
