 @extends('backend.app_template')
 @section('title','General Support')
 @section('content')
 <main class="app-wrapper">
     <div class="container-fluid">

         <div class="d-flex align-items-center mt-2 mb-2">
             <h6 class="mb-0 flex-grow-1">General Support</h6>
             <div class="flex-shrink-0">
                 <nav aria-label="breadcrumb">
                     <ol class="breadcrumb justify-content-end mb-0">
                         <li class="breadcrumb-item"><a href="javascript:void(0)">Pages</a></li>
                         <li class="breadcrumb-item active" aria-current="page">General Support</li>
                     </ol>
                 </nav>
             </div>
         </div>
         <div class="row">
             <div class="col-12 col-lg-12">
                 <div class="card card-h-100">
                     <div class="card-header">
                         <h5 class="card-title mb-0"> General Support </h5>
                     </div>
                     <div class="card-body">
                         <!-- Nav tabs -->
                         <ul class="nav nav-tabs-bordered nav-justified" role="tablist">
                             <li class="nav-item" role="presentation">
                                 <a class="nav-link active" data-bs-toggle="tab" href="#demo-tab-9_home" onclick="showAll('all',0)" role="tab" aria-selected="true">
                                     <span><i class="fas fa-home"></i></span>
                                     <span>All complaints</span>
                                 </a>
                             </li>
                             <li class="nav-item" role="presentation">
                                 <a class="nav-link" data-bs-toggle="tab" href="#demo-tab-9_profile" onclick="showAll('unreview',1)" role="tab" aria-selected="false" tabindex="-1">
                                     <span><i class="far fa-user"></i></span>
                                     <span>Unreview</span>
                                 </a>
                             </li>
                             <li class="nav-item" role="presentation">
                                 <a class="nav-link" data-bs-toggle="tab" href="#demo-tab-9_messages" onclick="showAll('resolved',2)" role="tab" aria-selected="false" tabindex="-1">
                                     <span><i class="far fa-envelope"></i></span>
                                     <span>Resolved</span>
                                 </a>
                             </li>
                             <li class="nav-item" role="presentation">
                                 <a class="nav-link" data-bs-toggle="tab" href="#demo-tab-9_settings" onclick="showAll('closed',3)" role="tab" aria-selected="false" tabindex="-1">
                                     <span><i class="fas fa-cog"></i></span>
                                     <span>Closed</span>
                                 </a>
                             </li>
                         </ul>
                         <!-- Tab panes -->
                         <div class="tab-content">
                             <div class="tab-pane active show" id="demo-tab-9_home" role="tabpanel">
                                 <table class="table table-responsive   table-bordered w-100 mt-5">
                                     <thead>
                                         <tr>
                                             <th>S.No</th>
                                             <th>User Email</th>
                                             <th>Vendor Contact</th>
                                             <th>Issue</th>
                                             <th>Images</th>
                                             <th>Status</th>
                                         </tr>
                                     </thead>
                                     <tbody id="all">
                                     </tbody>
                                 </table>
                             </div>
                             <div class="tab-pane" id="demo-tab-9_profile" role="tabpanel">
                                 <table class="table table-responsive   table-bordered w-100 mt-5">
                                     <thead>
                                         <tr>
                                             <th>S.No</th>
                                             <th>User Email</th>
                                             <th>Vendor Contact</th>
                                             <th>Issue</th>
                                             <th>Images</th>
                                             <th>Status</th>
                                         </tr>
                                     </thead>
                                     <tbody id="unreview">
                                     </tbody>
                                 </table>
                             </div>
                             <div class="tab-pane" id="demo-tab-9_messages" role="tabpanel">
                                 <table class="table table-responsive   table-bordered w-100 mt-5">
                                     <thead>
                                         <tr>
                                             <th>S.No</th>
                                             <th>User Email</th>
                                             <th>Vendor Contact</th>
                                             <th>Issue</th>
                                             <th>Images</th>
                                             <th>Status</th>
                                         </tr>
                                     </thead>
                                     <tbody id="resolved">
                                     </tbody>
                                 </table>
                             </div>
                             <div class="tab-pane" id="demo-tab-9_settings" role="tabpanel">
                                 <table class="table table-responsive   table-bordered w-100 mt-5">
                                     <thead>
                                         <tr>
                                             <th>S.No</th>
                                             <th>User Email</th>
                                             <th>Vendor Contact</th>
                                             <th>Issue</th>
                                             <th>Images</th>
                                             <th>Status</th>
                                         </tr>
                                     </thead>
                                     <tbody id="closed">
                                     </tbody>
                                 </table>
                             </div>
                         </div>
                     </div>
                 </div>
             </div>


         </div>
     </div>
 </main>
 <script>
     function showAll(type, status,t) {
         var url = '<?= url('/backend/get-support') ?>?type=' + type + '&status=' + status;
         $.get(url, function(data) {
             $('#' + type).html(data);
         })
     }
     showAll('all', 0,'all');

     function changeSupportChanges(val, id,type) {
         if (val > 0) {
             var url = '<?= url('/backend/updateSupportStatus') ?>?id=' + id + '&status=' + val+'&type='+type;
             $.get(url, function(data) {
                 
                 showAll(type,data,'');
                  showToast('success','Status Changed Successfully');
             });
         }
     }
 </script>
 @endsection