 @extends('backend.app_template')
 @section('title','Size Store or Update')
 @section('content')
 <?php
    $id                = isset($record->id) ? $record->id : '';
    $size              = isset($record->size) ? $record->size : '';
    $size_type         = isset($record->size_type) ? $record->size_type : '';
    $type              = ($id == '')   ? 'Create' : 'Update';

    ?>
 <main class="app-wrapper">
     <div class="container-fluid">

         <div class="d-flex align-items-center mt-2 mb-2">

             <div class="flex-shrink-0">
                 <nav aria-label="breadcrumb">
                     <ol class="breadcrumb justify-content-end mb-0">
                         <li class="breadcrumb-item"><a href="javascript:void(0)">Size</a></li>
                         <li class="breadcrumb-item active" aria-current="page"><?= $type ?></li>
                     </ol>
                 </nav>
             </div>
         </div>
         <div class="row">
             <div class="col-xl-12 col-xxl-12">
                 <form method="POST" id="countryForm" action="<?= route('storeUpdateSize') ?>" enctype="multipart/form-data">
                     @csrf
                     <div>
                         <div class="card">
                             <span></span>
                             <!-- Logistics Details Section -->
                             <div class="card-header">
                                 <h5 class="mb-0"><?= $type ?>Size</h5>
                                 <div class="float-end">
                                     <a href="<?= route('size') ?>" class="btn btn-primary">Back</a>
                                 </div>
                             </div>
                             <input type="hidden" name="id" value="<?= $id ?>" />
                             <div class="card-body">
                                 <div class="row g-4">

                                     <div class="col-xl-4">
                                         <label for="size_type" class="form-label">Size Type<span class="text-danger"> *</span></label>
                                         <select class="form-control select2" id="size_type" name="size_type">
                                             <option value="">--select--</option>
                                             <option <?= ($size_type == 1) ? 'selected':'' ?> value="1">Size</option>
                                             <option <?= ($size_type == 2) ? 'selected':'' ?> value="2">Range</option>
                                             <option <?= ($size_type == 3) ? 'selected':'' ?> value="3">Capacity</option>
                                         </select>
                                         @error('size_type') <span class="text-danger">{{$message}}</span> @enderror
                                     </div>

                                     <div class="col-xl-4">
                                         <label for="size" class="form-label">Size<span class="text-danger"> *</span></label>
                                         <input type="text" value="<?= $size ?>" class="form-control" id="size" name="size" placeholder="Enter Size">
                                         @error('size') <span class="text-danger">{{$message}}</span> @enderror
                                     </div>

                                 </div>

                             </div>
                         </div>
                     </div>
                     <div class="d-flex justify-content-end gap-3 my-5">
                         <a href="" class="btn btn-light-light text-muted">Cancel</a>
                         <button type="submit" class="btn btn-primary">Save</button>
                     </div>
                 </form>
             </div>

         </div>
         <!-- Submit Section -->
     </div>
 </main>
 <script>
     $(function() {
         $("#countryForm").validate({
             rules: {
                 size_type: { required: true  },
                 size: { required: true  },

             },
             messages: {
                 size_type: {
                     required: "Please select size type"
                 },
                 size:"Please Enter Size"
             },
             errorElement: "span",
             errorPlacement: function(error, element) {
                 error.addClass("text-danger");
                 error.insertAfter(element);
             }
         });
     });
 </script>
 @endsection