<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FrontendController;
use App\Http\Controllers\ServiceRequestController;
use App\Http\Controllers\SupportController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get('/session/check', function () {
    return response()->json([
        'alive' => session()->has('_token')
    ]);
})->name('session.check');

Route::get('/', [FrontendController::class, 'index'])->name('/');
Route::get('contact', [FrontendController::class, 'contact'])->name('contact');
Route::get('privacy-policy', [FrontendController::class, 'privacy_policy'])->name('privacy-policy');
Route::get('terms-conditions', [FrontendController::class, 'terms_condition'])->name('terms-conditions');


Route::get('/request-waiting/{token}', [FrontendController::class, 'requestWaiting'])
    ->name('request.waiting');



Route::get('post-ad', [FrontendController::class, 'post_ad'])->name('post-ad');

Route::get('support', [FrontendController::class, 'support'])->name('support');
Route::get('vendor', [FrontendController::class, 'vendor'])->name('vendor');
Route::get('/vendor/{vendor}', [FrontendController::class, 'showVendor'])->name('showVendor');
Route::post('/store-user-vendor-view', [FrontendController::class, 'storeUserVendorView'])->name('store-user-vendor-view');


Route::post('/get-currency', [FrontendController::class, 'getCurrencyByCountry']);
Route::post('/sendRequest', [FrontendController::class, 'sendRequest'])->name('sendRequest');
// routes/web.php
Route::get('/getAcceptedrequests', [FrontendController::class, 'getAcceptedrequests'])
    ->name('getAcceptedrequests');
Route::post('/service-request/store', [ServiceRequestController::class, 'store'])->name('service-request.store');
Route::post('/service-request/update/{id}', [ServiceRequestController::class, 'update'])->name('service-request.update');
Route::post('/serviceRequestStore', [ServiceRequestController::class, 'serviceRequestStore'])->name('serviceRequestStore');


Route::post('/supportRequest', [SupportController::class, 'support_request'])->name('supportRequest');
Route::post('/searchDistanceIncreaseRequest', [ServiceRequestController::class, 'searchDistanceIncreaseRequest'])->name('searchDistanceIncreaseRequest');
