<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\MetaModel;
use Illuminate\Http\Request;

class MetaController extends Controller
{
     public function meta()
    {
        $records   =  MetaModel::get();
        $cont = isset($records) ? count($records):0;
        return view('backend.meta.list', compact('records','cont'));
    }

    public function addMeta($id = '')
    {
        $record = '';
        if ($id > 0) {
            $record = MetaModel::Where('id', $id)->first();
        }
        return view('backend.meta.add_edit', compact('record'));
    }

    public function storeUpdateMeta(Request $request)
    {
        $input     = $request->all();
        $id        = isset($input['id']) ? $input['id'] : 0;

        $dataArr = [];
        foreach ($input as $key => $val) {
            if ($key != '_token' && $key != 'id' )
                $dataArr[$key] = $val;
        }

       
        if ($id == 0 || $id == '') {
            $request->validate([
                'meta_title'          =>  "required",
                'meta_keywords'          =>  "required",
                'meta_description'          =>  "required",
              
            ]);
           $insert = MetaModel::create($dataArr);
           if($insert['id'] > 0)
           {
               return redirect()->route('meta')->with('success', 'Meta Saved Successfully');
           }else{
               return redirect()->route('meta')->with('error', 'Something went wrong!');
           }
           
        } else {
            $request->validate([
                  'meta_title'          =>  "required",
                'meta_keywords'          =>  "required",
                'meta_description'          =>  "required",          
            ]);
            $update = MetaModel::Where('id',$id)->update($dataArr);
            return redirect()->route('meta')->with('success', 'Meta Updated Successfully');;
        }        
    }
}
