@include('base.header')

<style>
    .label {
        font-weight: bold;
        color: rgb(203, 40, 69) !important;
        margin-top: 15px;
        display: block;
    }

    .vendor-title{
        font-weight: bold;
        color: rgb(203, 40, 69) !important;
        font-size: 24px;
        display: block;

    }

    .form-textarea {
        width: 100%;
        height: 110px;
        padding: 12px;
        border: 1px solid #ddd;
        border-radius: 8px;
        background: #f5f7fa;
    }

    .upload-box {
        width: 150px;
        height: 150px;
        border: 2px dashed #0091ff;
        border-radius: 10px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        color: #0091ff;
        cursor: pointer;
    }

    

    .upload-icon {
        font-size: 35px;
    }

    .preview-container {
        display: flex;
        gap: 10px;
        margin-top: 10px;
        flex-wrap: wrap;
    }

    .preview-container img {
        width: 80px;
        height: 80px;
        border-radius: 8px;
        object-fit: cover;
    }

    .submit-report-btn {
        width: 100%;
        margin-top: 25px;
        background: rgb(203, 40, 69);
        color: #fff;
        padding: 10px;
        border: none;
        border-radius: 8px;
        font-size: 18px;
        cursor: pointer;
    }

    .close-btn {
        position: absolute;
        right: 18px;
        top: 15px;
        font-size: 28px;
        border: none;
        background: none;
        cursor: pointer;
    }



    .form-label {
        font-weight: bold;
        display: block;
        margin-bottom: 5px;
    }

    .form-input {
        width: 100%;
        padding: 12px;
        border: 1px solid #ddd;
        border-radius: 8px;
        background: #f5f7fa;
    }

    .form-input.error {
        border-color: rgb(203, 40, 69);
    }

    .btn-loader {
        width: 18px;
        height: 18px;
        border: 3px solid #fff;
        border-top-color: transparent;
        border-radius: 50%;
        display: inline-block;
        margin-left: 8px;
        animation: spin 0.8s linear infinite;
    }

    @keyframes spin {
        from {
            transform: rotate(0deg);
        }

        to {
            transform: rotate(360deg);
        }
    }

    .btn[disabled] {
        opacity: 0.6;
        pointer-events: none;
    }

    #chatRequestBtn {
        position: relative;

        background: #00d14f;

        padding: 10px 18px;
        border-radius: 6px;
        border: none;
        cursor: pointer;
        color: white;
        margin-right: 5px;
    }

    #callRequestBtn {
        position: relative;

        background: #111827;

        padding: 10px 18px;
        border-radius: 6px;
        border: none;
        cursor: pointer;
        color: white;
        margin-right: 5px;
    }

    .btn-loader {
        width: 18px;
        height: 18px;
        border: 3px solid #fff;
        border-top-color: transparent;
        border-radius: 50%;
        animation: spin 0.6s linear infinite;
        margin-left: 5px;
    }

    @keyframes spin {
        100% {
            transform: rotate(360deg);
        }
    }
</style>

<body>
    @php
        $photos = explode(',', $serviceModel->photo);
        $firstPhoto = trim($photos[0]); // get first photo
    @endphp
    <div class="container ">

        <div class="image-container">
            <img src="{{ $firstPhoto }}" alt="Main Image" class="full-width-image">
            <div class="image-thumbnails">
                @foreach ($photos as $photo)
                    <img src="{{ trim($photo) }}" class="image-thumb" data-full="{{ trim($photo) }}">
                @endforeach
            </div>

            <div id="lightbox" class="lightbox" onclick="closeLightbox()">
                <img id="lightbox-img">
            </div>
        </div>

        {{-- <div class="success-box"
            style="background-image: url('{{ $firstPhoto }}');
            height:550px;
            background-size:cover;
            background-position:center;
            background-repeat:no-repeat;">
            <img src="{{ $firstPhoto }}" alt="Main Image" class="full-width-image">
        </div> --}}


        <div class="details-box">

            <button class="back-btn" onclick="goBack()">Back</button>
            <div class="details-box1">
                <p class="vendor-title">{{ $serviceModel->title }}</p>
                <p>{{ $serviceModel->description }}</p>
            </div>

            @if ($serviceModel->service_type == 3)
                <span class="label">Spoken Languages:</span>
                <p>Tamil, English</p>
            @endif
            @if ($serviceModel->service_type == 1)
                <span class="label">Location:</span>
                <p>{{ $requestModel->location }}</p>
                <span class="label">Available For:</span>
                <p>{{ $requestModel->availability }}</p>
            @endif
            <input type="hidden" value="{{ $requestId }}" class="requestId" id="requestId">
            <div class="contact-box">
                <span class="label">CONTACT ⚠</span>

                <label>Social:</label><br>
                <input type="text" value="+91" class="countrycode" id="countryCode" disabled>
                <input type="text" placeholder="Enter Whatsapp Number" id="whatsappNumber">

                <button class="" id="chatRequestBtn">
                    <span class="btn-text"><i class="fa-brands fa-whatsapp"></i> Chat Request</span>
                    <span class="btn-loader" style="display:none;"></span>
                </button>

                <button class="" id="callRequestBtn">
                    <span class="btn-text"><i class="fa-solid fa-phone"></i> Call Request</span>
                    <span class="btn-loader" style="display:none;"></span>
                </button>
                <span id="numberError" style="color:red; font-size:14px; display:none; margin-top:5px;"></span>
                <button class="report-btn" onclick="openReportModal()">Report</button>

                <div class="warning-box">
                    NEVER pay in advance to anyone via Gift / Bing card, Transcash,
                    Neosurf / PCS coupons, Google play card, etc. They are scammers.
                    Report such profiles! We recommend booking verified escorts.
                </div>
            </div>

        </div>


    </div>




    <!-- ================= FOOTER START ================= -->
    @include('base.footer')




    <div id="reportModal" class="modal" style="display:none;">

        <div class="modal-content modal-lg p-3">
            <div class="modal-title">
                Report Ad
                <button class="close-modal-btn" onclick="closeReportModal()">×</button>
            </div>

            <label class="form-label mt-2">Enter your email address</label>
            <input type="email" id="reportEmail" class="form-input" placeholder="Enter your email address">

            <label class="form-label mt-3" >Enter your report</label>
            <textarea id="reportMessage" class="form-textarea" placeholder="Enter report details"></textarea>

            <label class="form-label mt-3" >Add proof</label>

            <div onclick="document.getElementById('proofInput').click()">
                <img class="upload-box-modal" src="{{ asset('assets') }}/image/support_photo.svg" >
            </div>

            <input type="file" id="proofInput" multiple accept="image/*" style="display:none;"
                onchange="previewProof()">

            <div id="previewContainer" class="preview-container"></div>

            <button class="submit-report-btn" onclick="submitReport()">Submit Report</button>
        </div>
    </div>

    <script>



        function showBtnLoader(btn) {

            // Stop loaders on BOTH buttons first
            hideBtnLoader(document.getElementById("chatRequestBtn"));
            hideBtnLoader(document.getElementById("callRequestBtn"));

            // Start loader on clicked button
            btn.querySelector(".btn-text").style.display = "none";
            btn.querySelector(".btn-loader").style.display = "inline-block";
            btn.disabled = true;
        }

        function hideBtnLoader(btn) {
            btn.querySelector(".btn-text").style.display = "inline-block";
            btn.querySelector(".btn-loader").style.display = "none";
            btn.disabled = false;
        }

        function openReportModal() {
            document.getElementById("reportModal").style.display = "flex";
        }

        function closeReportModal() {
            document.getElementById("reportModal").style.display = "none";
        }

        document.getElementById("whatsappNumber").addEventListener("input", function() {
            document.getElementById("numberError").style.display = "none";
        });

        function previewProof() {
            let files = document.getElementById("proofInput").files;
            let container = document.getElementById("previewContainer");
            container.innerHTML = "";

            for (let file of files) {
                let img = document.createElement("img");
                img.src = URL.createObjectURL(file);
                container.appendChild(img);
            }
        }

        function submitReport() {
            const email = document.getElementById("reportEmail").value;
            const message = document.getElementById("reportMessage").value;
            const files = document.getElementById("proofInput").files;

            if (email.trim() === "") {
                document.getElementById("reportEmail").classList.add("error");
                return;
            }

            if (message.trim() === "") {
                showToast('error', 'Please enter a report message.');
                return;
            }

            const serviceId = '{{ $serviceModel->id ?? 'UNKNOWN' }}';

            // Create FormData to handle files
            const formData = new FormData();
            formData.append('serviceId', serviceId);
            formData.append('message', message);
            formData.append('_token', '{{ csrf_token() }}');
            formData.append('email', email);

            // Append multiple files
            for (let i = 0; i < files.length; i++) {
                formData.append('proofs[]', files[i]);
            }

            $.ajax({
                url: "/serviceRequestStore",
                method: "POST",
                data: formData,
                processData: false, // Important for FormData
                contentType: false, // Important for FormData
                success: function(response) {
                    showToast('success', 'Report submitted successfully.');
                    document.getElementById("reportMessage").value = "";
                    document.getElementById("reportEmail").value = "";
                    document.getElementById("proofInput").value = "";
                    document.getElementById("previewContainer").innerHTML = "";
                    closeReportModal();
                    showToast('success', 'Report ad submitted successfully We will contact you soon.');
                },
                error: function() {
                    showToast('error', 'Failed to submit report.');
                }
            });
        }


        function showError(msg) {
            const err = document.getElementById("numberError");
            err.style.display = "block";
            err.textContent = msg;
        }

        document.querySelectorAll('.image-thumb').forEach(img => {
            img.addEventListener('click', function() {

                const url = this.getAttribute('data-full'); // GET REAL IMAGE URL

                document.getElementById('lightbox-img').src = url;
                document.getElementById('lightbox').style.display = 'flex';
            });
        });

        function closeLightbox() {
            document.getElementById('lightbox').style.display = 'none';
        }


        function goBack() {
            window.history.back(); // Goes back immediately without loader
        }


        // Helper function to simulate data submission/request
        function sendContactRequest(type, data, btn) {

            console.log(`Sending ${type} request...`);
            console.log("Data to send:", data);
            const requestId = document.getElementById('requestId').value;
            // --- Replace this with your actual AJAX call (e.g., Axios or jQuery.ajax) ---

            $.ajax({
                url: '/service-request/store',
                method: 'POST',
                data: {
                    service_request_type_id: type,
                    service_id: data.serviceId, // Assuming you need the Service ID
                    number: data.fullNumber,
                    request_id: requestId,
                    _token: '{{ csrf_token() }}' // For Laravel POST requests
                },
                success: function(response) {
                    document.getElementById('whatsappNumber').value = "";
                    hideBtnLoader(btn);
                    showToast('success', `Request sent successfully!`);
                },
                error: function(error) {
                    hideBtnLoader(btn);
                    showToast('error', `Failed to request ${type}.`);
                }
            });

            // For demonstration, we just use alerts:
            // alert(`Request Sent! Type: ${type}, Number: ${data.fullNumber}, Service ID: ${data.serviceId}`);
        }

        // --- 1. Chat Request (WhatsApp) Listener ---
        document.getElementById('chatRequestBtn').addEventListener('click', function() {

            const btn = this;
            showBtnLoader(btn);

            const countryCode = document.getElementById('countryCode').value;
            const whatsappNumber = document.getElementById('whatsappNumber').value;
            if (whatsappNumber.trim() === '') {

                showError("Please enter a WhatsApp number.");
                hideBtnLoader(btn);
                return;
            }

            const fullNumber = countryCode + whatsappNumber;

            // This value is retrieved from the Laravel Blade template
            const serviceId = '{{ $serviceModel->id ?? 'UNKNOWN' }}';



            const data = {
                serviceId: serviceId,
                fullNumber: fullNumber
            };

            sendContactRequest(1, data, btn);
        });

        // --- 2. Call Request Listener ---
        document.getElementById('callRequestBtn').addEventListener('click', function() {
            const btn = this;
            showBtnLoader(btn);
            const countryCode = document.getElementById('countryCode').value;
            const whatsappNumber = document.getElementById('whatsappNumber')
                .value; // Often, the same number is used for calls
            const fullNumber = countryCode + whatsappNumber;

            const serviceId = '{{ $serviceModel->id ?? 'UNKNOWN' }}';

            // Validation might be different for call request,
            // but we'll use the same number field for now.
            if (whatsappNumber.trim() === '') {
                showError("Please enter a WhatsApp number.");
                hideBtnLoader(btn);

                return;
            }

            const data = {
                serviceId: serviceId,
                fullNumber: fullNumber
            };

            sendContactRequest(2, data, btn);
        });
    </script>
    </script>

    </html>
