@include('base.header')
@if (session('mobileExists'))
    <div class="toast-container position-fixed top-0 start-50 translate-middle-x p-3 mt-4 alertpopup" style="">
        <div id="errorToast" class="toast show" role="alert"
            style="min-width: 250px; border-radius:10px; box-shadow:0 4px 12px rgba(0,0,0,0.2);">
            <div class="d-flex align-items-center p-3">
                <span class="me-3 text-danger fs-3">❗</span>
                <span class="flex-grow-1 fs-5">{{ session('mobileExists') }}</span>
                <button type="button" class="btn-close ms-2" data-bs-dismiss="toast"></button>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        var toastEl = document.getElementById('errorToast');
        var toast = new bootstrap.Toast(toastEl, {
            delay: 3000
        });
        toast.show();
    </script>
@endif

<section class="support-con py-5 mt-5">

    <div class="row justify-content-center">
        <div class="col-12 col-md-7 col-lg-5">
            <h2 class="form-title text-center mb-4">Support Request Form</h2>
            <p class="text-center mb-4 description-text">
                Provide your details and issue description. Our support team will
                get back to you as soon as possible.
            </p>

            <!-- FORM START -->
            <form action="{{ route('supportRequest') }}" method="POST" enctype="multipart/form-data">
                @csrf

                <!-- Email -->
                <div class="row">
                    <div class="col-md-1"></div>
                    {{-- <div class="col-md-10">
                        <label class="form-label">Enter Your Mail id</label>
                        <input type="hidden" name="email" class="form-control custom-input" required
                            placeholder="Your Email">
                    </div> --}}
                </div>

                <!-- Phone -->
                <div class="row">
                    <div class="col-md-1"></div>
                    <div class="col-md-10">
                        <label class="form-label mt-3">Vendor Phone Number</label>
                        <input type="text" name="mobile" class="form-control custom-input" required
                            placeholder="Enter Vendor Phone Number">
                    </div>
                </div>

                <!-- Description -->
                <div class="row">
                    <div class="col-md-1"></div>
                    <div class="col-md-10">
                        <label class="form-label mt-3">Description of the Issue</label>
                        <textarea name="issue" class="form-control custom-textarea" rows="4" required
                            placeholder="Enter Your Details Here"></textarea>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-1"></div>
                    <!-- Add Proof -->     <div class="col-md-10">
                    <label class="form-label" style="margin-top:15px;">Add proof</label>

                    {{-- <div class="upload-box" onclick="document.getElementById('proofInput').click()">
                        <div class="upload-icon"></div>
                        <span>Add Photos</span>
                    </div> --}}

                    <div class=" "  onclick="document.getElementById('proofInput').click()">

                       <img class="upload-box" src="{{ asset('assets') }}/image/support_photo.svg" >
                    </div>

                    <input type="file" id="proofInput" name="photo[]" multiple accept="image/*" style="display:none;"
                        onchange="previewProof()">

                    <div id="previewContainer" class="preview-container"></div>
                    </div>
                </div>
                <!-- Submit -->
                <div class="row">
                    <div class="col-md-1"></div>
                    <div class="col-md-10">
                        <button class="btn submit-btn w-100 mt-4"  id="submitBtn" type="submit">Submit</button>
                    </div>
                </div>

            </form>
            <!-- FORM END -->

        </div>
    </div>

</section>

@include('base.footer')
<script>


    //const emailInput = document.getElementById("emailInput");
    const phoneInput = document.getElementById("phoneInput");
    const descInput = document.getElementById("descInput");
    const proofInput = document.getElementById("proofInput");

    const emailError = document.getElementById("emailError");
    const phoneError = document.getElementById("phoneError");
    const descError = document.getElementById("descError");
    const proofError = document.getElementById("proofError");

    const submitBtn = document.getElementById("submitBtn");

    function validateForm() {
        let valid = true;

        // Email validation
        // const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        // if (!emailPattern.test(emailInput.value.trim())) {
        //     emailError.style.display = "block";
        //     valid = false;
        // } else {
        //     emailError.style.display = "none";
        // }

        // Phone validation (10 digits only)
        phoneInput.value = phoneInput.value.replace(/[^0-9]/g, '');
        if (phoneInput.value.length !== 10) {
            phoneError.style.display = "block";
            valid = false;
        } else {
            phoneError.style.display = "none";
        }

        // Description validation
        if (descInput.value.trim().length < 5) {
            descError.style.display = "block";
            valid = false;
        } else {
            descError.style.display = "none";
        }

        // Proof validation
        if (proofInput.files.length === 0) {
            proofError.style.display = "block";
            valid = false;
        } else {
            proofError.style.display = "none";
        }

        // Enable or disable submit button
        submitBtn.disabled = !valid;
    }

    // Event listeners
    //emailInput.addEventListener("input", validateForm);
    phoneInput.addEventListener("input", validateForm);
    descInput.addEventListener("input", validateForm);
    proofInput.addEventListener("change", validateForm);

    function previewProof() {
        let files = proofInput.files;
        let container = document.getElementById("previewContainer");
        container.innerHTML = "";

        for (let file of files) {
            let img = document.createElement("img");
            img.src = URL.createObjectURL(file);
            container.appendChild(img);
        }

        validateForm();
    }
</script>

