@extends('app_layout')
@section('title','Career')
@section('content')

<main class="main">
<section id="hero" class="hero section bgimg" >

      <div class="container aos-init aos-animate" data-aos="fade-up" data-aos-delay="100">

        <div class="row align-items-center">
          <div class="col-lg-12">
            <div class="aos-init aos-animate" data-aos="fade-right" data-aos-delay="200">
             
              <div class="text-center">
                <button class="btn btn-sm bt mt-5">CAREER</button>
              </div>
              <h1 class="hfive text-white text-center">Want to work <br> with us?</h1>
             
             
            </div>
          </div>

         
        </div>

      </div>

    </section>

     <section id="contact" class="contact section">
        <div class="container">
            <div class="row g-4">
                <!-- <div class="col-lg-3"></div> -->
                  
                                    <div class="col-lg-5 mx-auto">
                                        @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                     @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                    <div class="contact-form-panel">
                        <div class="form-container">
                            <span class="ft">CAREER</span>
                            <h5 class="hfive text-dark">We’re ready, Let’s <br>talk.</h5>
                            <p>Contact us to find out more or how we can help you <br>better.</p>

                            <form action="<?= route('send-career') ?>" method="post" enctype="multipart/form-data" class="careerForm">
                               @csrf <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="nameInput" name="name" placeholder="Name" >
                                    <label for="nameInput"> Name</label>
                                     @error('name')
                                            <div class="text-danger">{{ $message }}</div>
                                      @enderror
                                </div>

                                <div class="form-floating mb-3">
                                    <input type="email" class="form-control" id="emailInput" name="email" placeholder="Email Address" required="">
                                    <label for="emailInput">Email/Mobile Number</label>
                                     @error('mail')
                                            <div class="text-danger">{{ $message }}</div>
                                      @enderror
                                </div>



                                <div class="form-floating mb-3">
                                    <textarea class="form-control" rows="5" id="messageInput" name="message" rows="5" placeholder="Your Message" style="height: 150px" required=""></textarea>
                                    <label for="messageInput">Message</label>
                                     @error('message')
                                            <div class="text-danger">{{ $message }}</div>
                                      @enderror
                                </div>

                                <div class="my-3">
                                    <!-- <div class="loading">Loading</div>
                                    <div class="error-message"></div>
                                    <div class="sent-message">Your message has been sent. Thank you!</div> -->
                                </div>
                                    <br>
                                 <div class="form-floating mt-3">
                                    <input type="file"  id="file" name="file" required="">
                                     @error('file')
                                            <div class="text-danger">{{ $message }}</div>
                                      @enderror                                   
                                </div>

                                <div class="d-grid">
                                    <button type="submit" class="btn-submit">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="contact-wrapper">



            </div>
        </div>
    </section>
   
    <script>
         $(function() {
            $(".careerForm").validate({
                rules: {
                    name: {
                        required: true,
                        minlength: 3
                    },
                    // email: {
                    //     required: true,
                    //     email: true
                    // },
                    phone: {
                        required: true,
                        digits: true,
                        maxlength: 10,
                        minlength: 10
                    },

                },
                messages: {
                    name: {
                        required: "please enter name",
                        minlength: "name must be at least 3 characters"
                    },
                    // email: {
                    //     required: "email is required",
                    //     email: "please enter a valid email address"
                    // },
                    phone: {
                        required: "phone number is required",
                        digits: "only numbers are allowed",
                        minlength: "phone number must be 10 digits",
                        maxlength: "phone number must be 10 digits"
                    },
                },
                errorElement: "span",
                errorPlacement: function(error, element) {
                    error.addClass("text-danger");
                    error.insertAfter(element);
                },
               
            });

            
        });
    </script>
   

    @endsection