@extends('app_layout')
@section('title','Contact Us')
@section('content')
<main class="main">

    <!-- Page Title -->
    <div class="page-title ">
        <div class="container mt-5">
            <div class="row g-4">
                <div class="col-lg-2 ">

                </div>
                <div class="col-lg-6 ">
                    <h2 class="htwo">Get in Touch</h2>
                    <h4 class="mt-4 ">We’d love to hear from you.</h4>
                </div>

            </div>


        </div>
    </div><!-- End Page Title -->

    <section class="container">
        <div class="map-container">
            <!-- <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d48389.78314118045!2d-74.006138!3d40.710059!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c25a22a3bda30d%3A0xb89d1fe6bc499443!2sDowntown%20Conference%20Center!5e0!3m2!1sen!2sus!4v1676961268712!5m2!1sen!2sus" width="100%" style="border:0; height: 500px;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe> -->
            <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d7776.285375095924!2d80.132969!3d12.96272!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3a525f0001ea6b53%3A0x4102dab5cce19473!2sPALANIAPPA%20ELECTRONICS!5e0!3m2!1sen!2sin!4v1766410042302!5m2!1sen!2sin" width="100%" height="500" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
    </section>

    <!-- Contact Section -->
    <section id="contact" class="contact section">
        <div class="container">
            <div class="row g-4">
                <div class="col-lg-2"></div>
                <div class="col-lg-4">
                    <div class="contact-info-panel visit-panel">

                        <h3 class="visit-title">Visit Us</h3>

                        <div class="visit-block">
                            <h5>Reg Office & Warehouse:</h5>
                            <p>
                                No. 185/2, Abdul Kalam Street,<br>
                                Nagalkeni, Chromepet,<br>
                                Chennai – 600044
                            </p>
                        </div>

                        <div class="visit-block">
                            <h5>Admin Office & Warehouse</h5>
                            <p>
                                Palaniappa Electronics<br>
                                185/2, Abdul Karam Street,<br>
                                Nagalkeni, Chromepet,<br>
                                Chennai – 600044
                            </p>
                        </div>

                        <div class="visit-block">
                            <h5>Email</h5>
                            <p>
                                b2b.palaniappa@gmail.com<br>
                                enquiry.palaniappa@gmail.com<br>
                                office.palaniappa@gmail.com<br>
                                marketing.palaniappa@gmail.com
                            </p>
                        </div>

                        <div class="visit-block">
                            <h5>Phone</h5>
                            <p>
                                044-29546667 | 044-22481267
                            </p>
                        </div>

                        <div class="visit-block">
                            <h5>Mobile</h5>
                            <p>
                                +91 8939999718|+91 8939999705|<br>
                                +91 8939990722|+91 8939990710
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                     @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                     @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                    <div class="contact-form-panel">
                        <div class="form-container">
                            <h5 class="text-dark">Send your questions</h5>
                            <p>Fields marked with an <span class="text-danger">*</span> are required</p>

                            <form action="<?= route('contact-form') ?>" method="post" class="contactForm">
                               @csrf <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="nameInput" name="name" placeholder="Full Name" required="">
                                    <label for="nameInput">Full Name</label>
                                     @error('name')
                                            <div class="text-danger">{{ $message }}</div>
                                      @enderror
                                </div>

                                <div class="form-floating mb-3">
                                    <input type="email" class="form-control" id="emailInput" name="email" placeholder="Email Address" required="">
                                    <label for="emailInput">Email Address</label>
                                     @error('email')
                                            <div class="text-danger">{{ $message }}</div>
                                      @enderror
                                </div>

                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="subjectInput" name="subject" placeholder="Subject" required="">
                                    <label for="subjectInput">Subject</label>
                                     @error('subject')
                                            <div class="text-danger">{{ $message }}</div>
                                      @enderror
                                </div>

                                <div class="form-floating mb-3">
                                    <textarea class="form-control" id="messageInput" name="message" rows="5" placeholder="Your Message" style="height: 150px" required=""></textarea>
                                    <label for="messageInput">Your Message</label>
                                     @error('message')
                                            <div class="text-danger">{{ $message }}</div>
                                      @enderror
                                </div>

                                <!-- <div class="my-3">
                                    <div class="loading">Loading</div>
                                    <div class="error-message"></div>
                                    <div class="sent-message">Your message has been sent. Thank you!</div>
                                </div> -->

                                <div class="d-grid">
                                    <button type="submit" class="btn-submit">Send<i class="bi bi-send-fill ms-2"></i></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="contact-wrapper">



            </div>
        </div>
    </section>

   <section class="bottom-btn">
        <div class="row">
            <div class="col-lg-12">
            <div class="d-grid">
                <a href="<?= route('career') ?>" class="btn-submit">
                Lets work together <i class="bi bi-arrow-right"></i>
                </a>
            </div>
            </div>
        </div>
    </section>
    <script>
         $(function() {
            $(".contactForm").validate({
                rules: {
                    name: {
                        required: true,
                        minlength: 3
                    },
                    email: {
                        required: true,
                        email: true
                    },
                    phone: {
                        required: true,
                        digits: true,
                        maxlength: 10,
                        minlength: 10
                    },

                },
                messages: {
                    name: {
                        required: "please enter name",
                        minlength: "name must be at least 3 characters"
                    },
                    email: {
                        required: "email is required",
                        email: "please enter a valid email address"
                    },
                    phone: {
                        required: "phone number is required",
                        digits: "only numbers are allowed",
                        minlength: "phone number must be 10 digits",
                        maxlength: "phone number must be 10 digits"
                    },
                },
                errorElement: "span",
                errorPlacement: function(error, element) {
                    error.addClass("text-danger");
                    error.insertAfter(element);
                },
               
            });

            
        });
    </script>
    @endsection