 @extends('backend.app_template')
@section('title','Country Store or Update')
@section('content')
 <?php
 $id                = isset($record->id) ? $record->id:'';
 $video             = isset($record->vedio) ? $record->vedio:'';

 $type              = ($id == '')   ? 'Create':'Update';

 ?>
 <main class="app-wrapper">
            <div class="container-fluid">

                <div class="d-flex align-items-center mt-2 mb-2">

                    <div class="flex-shrink-0">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb justify-content-end mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0)">User Guide Video</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?= $type ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-12 col-xxl-12">
                        <form method="POST" id="countryForm" action="<?= route('storeUpdateUserVideo') ?>" enctype="multipart/form-data">
                           @csrf
                            <div>
                                <div class="card">
                                    <span></span>
                                    <!-- Logistics Details Section -->
                                    <div class="card-header">
                                        <h5 class="mb-0"><?= $type ?> User Guide Video</h5>
                                        <div class="float-end">
                                            <a href="<?=  route('userVideo') ?>" class="btn btn-primary" >Back</a>
                                        </div>
                                    </div>
                                    <input type="hidden" name="id" value="<?= $id ?>" />
                                    <input type="hidden" name="old_vedio" value="<?= $video ?>" />


                                    <div class="card-body">
                                        <div class="row g-4">
                                            <div class="col-xl-4">
                                                <label for="video" class="form-label">User Guide Video</label>
                                                <input type="file" accept="video/mp4" class="form-control" name="video" >
                                            </div>
                                            <div class="col-xl-4">
                                                <?php if ($video != '') { ?>
                                                    <video width="200" height="100" controls>
                                                        <source src="<?= $video ?>" type="video/mp4">
                                                    </video>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="d-flex justify-content-end gap-3 my-5">
                                <a href="" class="btn btn-light-light text-muted">Cancel</a>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>

                </div>
                <!-- Submit Section -->
            </div>
        </main>
    <script>
        $(function() {
       $("#countryForm").validate({
         rules: {
           name: {  required: true },
           phone_code: {  required: true },
           currency_name: {  required: true },
           currency_code: {  required: true },

         },
         messages: {
           name: { required: "Please enter country name" },
           phone_code: { required: "Please enter country code" },
           currency_name: { required: "Please enter currency name" },
           currency_code: { required: "Please enter currency code" },
         },
         errorElement: "span",
         errorPlacement: function(error, element) {
           error.addClass("text-danger");
           error.insertAfter(element);
         }
       });
     });
    </script>
@endsection
