@extends('backend.app_template')
@section('title','Dashboard')
@section('content')
<main class="app-wrapper">
    <div class="container-fluid">

        <div class="row mt-5">
            <div class="col-md-6 col-xl-4 col-xxl-3">
                <div class="card card-h-100 webGradient text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between gap-5 mb-5">
                            <div>
                                <h4 class="text-white mb-1">Web Request</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <div
                                    class="h-48px w-48px bg-white fs-5 rounded d-flex justify-content-center align-items-center text-black fw-semibold"><?= isset($reqCont) ? $reqCont : 0 ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xl-4 col-xxl-3">
                <div class="card card-h-100 webGradient1 text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between gap-5 mb-5">
                            <div>
                                <h4 class="text-white mb-1">Total Advertisement</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <div
                                    class="h-48px w-48px bg-white fs-5 rounded d-flex justify-content-center align-items-center text-black fw-semibold"><?= isset($adCount) ? $adCount : 0 ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xl-4 col-xxl-3">
                <div class="card card-h-100 webGradient2 text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between gap-5 mb-5">
                            <div>
                                <h4 class="text-white mb-1">Total Vendor</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <div
                                    class="h-48px w-48px bg-white fs-5 rounded d-flex justify-content-center align-items-center text-black fw-semibold"><?= isset($vendorCount) ? $vendorCount : 0 ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xl-4 col-xxl-3">
                <div class="card card-h-100 IntelligenceGradient text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between gap-5 mb-5">
                            <div>
                                <h4 class="text-white mb-1">Accepted</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <div
                                    class="h-48px w-48px bg-white fs-5 rounded d-flex justify-content-center align-items-center text-black fw-semibold">
                                    <?= isset($data->accept) ? $data->accept : 0 ?></div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xl-4 col-xxl-3">
                <div class="card card-h-100 datascienceGradient text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between gap-5 mb-5">
                            <div>
                                <h4 class="text-white mb-1">Decline</h4>

                            </div>
                            <div class="flex-shrink-0">
                                <div
                                    class="h-48px w-48px bg-white fs-5 rounded d-flex justify-content-center align-items-center text-black fw-semibold">
                                    <?= isset($data->decline) ? $data->decline : 0 ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0"><i class="bi bi-question-circle"></i>&nbsp;&nbsp;Queries</h5>
                </div>
                <div class="card-body">
                    <div class="row mt-5">
                        <div class="col-md-6 col-xl-4 col-xxl-3">
                            <div class="card card-h-100 webGradient3 text-white">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between gap-5 mb-5">
                                        <div>
                                            <h4 class="text-white mb-1">Total Queries</h4>
                                        </div>
                                        <div class="flex-shrink-0">
                                            <div
                                                class="h-48px w-48px bg-white fs-5 rounded d-flex justify-content-center align-items-center text-black fw-semibold"><?= isset($support->total) ? $support->total : 0 ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 col-xl-4 col-xxl-3">
                            <div class="card card-h-100 webGradient4 text-white">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between gap-5 mb-5">
                                        <div>
                                            <h4 class="text-white mb-1">Total Under Review</h4>
                                        </div>
                                        <div class="flex-shrink-0">
                                            <div
                                                class="h-48px w-48px bg-white fs-5 rounded d-flex justify-content-center align-items-center text-black fw-semibold"><?= isset($support->review) ? $support->review : 0 ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 col-xl-4 col-xxl-3">
                            <div class="card card-h-100 webGradient5 text-white">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between gap-5 mb-5">
                                        <div>
                                            <h4 class="text-white mb-1">Total Resolved</h4>
                                        </div>
                                        <div class="flex-shrink-0">
                                            <div
                                                class="h-48px w-48px bg-white fs-5 rounded d-flex justify-content-center align-items-center text-black fw-semibold"><?= isset($support->resolve) ? $support->resolve : 0 ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="card-title mb-0">Location wise Web Request</h5>
                            </div>
                            <div class="card-body">
                                <div id="location-chart"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="card-title mb-0">Service Wise</h5>
                            </div>
                            <div class="card-body">
                                <div id="sales_managment"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-7">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="card-title mb-0">User Analytics</h5>
                            </div>
                            <div class="card-body">
                                <div id="userChart"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-7">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="card-title mb-0">Total Web Request</h5>
                            </div>
                            <div class="card-body">
                                <div id="chart"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>


        <!-- <div class="row mt-5">
                <div class="col-xl-7">
                    <div class="card courses-card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">All Courses</h5>
                            <a href="javascript:void(0)" class="link link-primary fs-13 text-muted text-decoration-underline">See All<i class="bi bi-arrow-right ms-1"></i></a>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-box table-responsive">
                                <table class="table">
                                    <thead class="">
                                        <tr>
                                            <th>#</th>
                                            <th>Course Name</th>
                                            <th>Category</th>
                                            <th>Duration</th>
                                            <th>Price</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>1</td>
                                            <td>Web Development</td>
                                            <td>Programming</td>
                                            <td>6 Months</td>
                                            <td>$499</td>
                                            <td><span class="badge bg-success-subtle text-success">Available</span></td>
                                            <td>
                                                <div class="dropdown">
                                                    <a href="javascript:void(0)" data-bs-toggle="dropdown" class="text-muted">
                                                        <i class="bi bi-three-dots-vertical"></i>
                                                    </a>
                                                    <ul class="dropdown-menu dropdown-menu-end">
                                                        <li><a class="dropdown-item" href="javascript:void(0)">View</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0)">Edit</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0)">Delete</a></li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>2</td>
                                            <td>Graphic Design</td>
                                            <td>Design</td>
                                            <td>4 Months</td>
                                            <td>$299</td>
                                            <td><span class="badge bg-warning-subtle text-warning">Limited</span></td>
                                            <td>
                                                <div class="dropdown">
                                                    <a href="javascript:void(0)" data-bs-toggle="dropdown" class="text-muted">
                                                        <i class="bi bi-three-dots-vertical"></i>
                                                    </a>
                                                    <ul class="dropdown-menu dropdown-menu-end">
                                                        <li><a class="dropdown-item" href="javascript:void(0)">View</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0)">Edit</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0)">Delete</a></li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>3</td>
                                            <td>Data Science</td>
                                            <td>Analytics</td>
                                            <td>8 Months</td>
                                            <td>$799</td>
                                            <td><span class="badge bg-success-subtle text-success">Available</span></td>
                                            <td>
                                                <div class="dropdown">
                                                    <a href="javascript:void(0)" data-bs-toggle="dropdown" class="text-muted">
                                                        <i class="bi bi-three-dots-vertical"></i>
                                                    </a>
                                                    <ul class="dropdown-menu dropdown-menu-end">
                                                        <li><a class="dropdown-item" href="javascript:void(0)">View</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0)">Edit</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0)">Delete</a></li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>4</td>
                                            <td>Digital Marketing</td>
                                            <td>Marketing</td>
                                            <td>3 Months</td>
                                            <td>$199</td>
                                            <td><span class="badge bg-danger-subtle text-danger">Full</span></td>
                                            <td>
                                                <div class="dropdown">
                                                    <a href="javascript:void(0)" data-bs-toggle="dropdown" class="text-muted">
                                                        <i class="bi bi-three-dots-vertical"></i>
                                                    </a>
                                                    <ul class="dropdown-menu dropdown-menu-end">
                                                        <li><a class="dropdown-item" href="javascript:void(0)">View</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0)">Edit</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0)">Delete</a></li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>5</td>
                                            <td>Machine Learning</td>
                                            <td>AI</td>
                                            <td>9 Months</td>
                                            <td>$999</td>
                                            <td><span class="badge bg-success-subtle text-success">Available</span></td>
                                            <td>
                                                <div class="dropdown">
                                                    <a href="javascript:void(0)" data-bs-toggle="dropdown" class="text-muted">
                                                        <i class="bi bi-three-dots-vertical"></i>
                                                    </a>
                                                    <ul class="dropdown-menu dropdown-menu-end">
                                                        <li><a class="dropdown-item" href="javascript:void(0)">View</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0)">Edit</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0)">Delete</a></li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="d-flex flex-wrap gap-3 align-items-center m-5">
                                <div class="fw-medium"> Showing 1 - 5 of 3 Entries</div>
                                <div class="ms-auto">
                                    <nav aria-label="Page navigation example">
                                        <ul class="pagination pagination-primary mb-0">
                                            <li class="page-item">
                                                <a class="page-link" href="javascript:void(0)">
                                                    <i class="ri-arrow-left-s-line fw-semibold"></i>
                                                </a>
                                            </li>
                                            <li class="page-item"><a class="page-link" href="javascript:void(0)">1</a></li>
                                            <li class="page-item active"><a class="page-link" href="javascript:void(0)">2</a></li>
                                            <li class="page-item"><a class="page-link" href="javascript:void(0)">3</a></li>
                                            <li class="page-item">
                                                <a class="page-link" href="javascript:void(0)">
                                                    <i class="ri-arrow-right-s-line fw-semibold"></i>
                                                </a>
                                            </li>
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-5">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Course Schedule</h5>
                            <div class="dropdown">
                                <a href="javascript:void(0)" data-bs-toggle="dropdown" class="text-muted">
                                    <i class="bi bi-three-dots-vertical"></i>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li><a class="dropdown-item" href="javascript:void(0)">View All</a></li>
                                    <li><a class="dropdown-item" href="javascript:void(0)">Import</a></li>
                                    <li><a class="dropdown-item" href="javascript:void(0)">Export</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="course"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xl-4">
                    <div class="card card-h-100">
                        <div class="card-header d-flex justify-content-between">
                            <h5 class="card-title mb-0">Popular Instructors</h5>
                            <a href="javascript:void(0)" class="link link-primary fs-13 text-muted text-decoration-underline">See All<i class="bi bi-arrow-right ms-1"></i></a>
                        </div>
                        <div class="card-body">
                            <ul class="list-group list-group-flush list-borderless">
                                <li class="list-group-item d-flex justify-content-between py-3">
                                    <div class="d-flex gap-3">
                                        <img src="assets/images/avatar/avatar-1.jpg" alt="Instructor" class="avatar-md rounded-circle">
                                        <div>
                                            <h6 class="mb-1">John Doe <span class="fs-11 fw-normal ms-2"><i class="bi bi-star-fill text-warning me-1"></i>(4.8)</span></h6>
                                            <p class="text-muted mb-1">Web Development</p>
                                        </div>
                                    </div>
                                    <small class="text-muted">15 Courses • 10K Students</small>
                                </li>
                                <li class="list-group-item d-flex justify-content-between py-3">
                                    <div class="d-flex gap-3">
                                        <img src="assets/images/avatar/avatar-2.jpg" alt="Instructor" class="avatar-md rounded-circle">
                                        <div>
                                            <h6 class="mb-1">Sarah Smith <span class="fs-11 fw-normal ms-2"><i class="bi bi-star-fill text-warning me-1"></i>(4.9)</span></h6>
                                            <p class="text-muted mb-1">Data Science</p>
                                        </div>
                                    </div>
                                    <small class="text-muted">20 Courses • 12K Students</small>
                                </li>
                                <li class="list-group-item d-flex justify-content-between py-3">
                                    <div class="d-flex gap-3">
                                        <img src="assets/images/avatar/avatar-3.jpg" alt="Instructor" class="avatar-md rounded-circle">
                                        <div>
                                            <h6 class="mb-1">Michael Lee <span class="fs-11 fw-normal ms-2"><i class="bi bi-star-fill text-warning me-1"></i>(4.7)</span></h6>
                                            <p class="text-muted mb-1">UI/UX Design</p>
                                        </div>
                                    </div>
                                    <small class="text-muted">12 Courses • 8K Students</small>
                                </li>
                                <li class="list-group-item d-flex justify-content-between py-3">
                                    <div class="d-flex gap-3">
                                        <img src="assets/images/avatar/avatar-4.jpg" alt="Instructor" class="avatar-md rounded-circle">
                                        <div>
                                            <h6 class="mb-1">Emily Brown <span class="fs-11 fw-normal ms-2"><i class="bi bi-star-fill text-warning me-1"></i>(4.6)</span></h6>
                                            <p class="text-muted mb-1">Digital Marketing</p>
                                        </div>
                                    </div>
                                    <small class="text-muted">10 Courses • 6K Students</small>
                                </li>
                                <li class="list-group-item d-flex justify-content-between py-3">
                                    <div class="d-flex gap-3">
                                        <img src="assets/images/avatar/avatar-5.jpg" alt="Instructor" class="avatar-md rounded-circle">
                                        <div>
                                            <h6 class="mb-1">Daniel Wilson <span class="fs-11 fw-normal ms-2"><i class="bi bi-star-fill text-warning me-1"></i>(4.9)</span></h6>
                                            <p class="text-muted mb-1">Cybersecurity</p>
                                        </div>
                                    </div>
                                    <small class="text-muted">18 Courses • 14K Students</small>
                                </li>
                                <li class="list-group-item d-flex justify-content-between pt-3 pb-0">
                                    <div class="d-flex gap-3">
                                        <img src="assets/images/avatar/avatar-6.jpg" alt="Instructor" class="avatar-md rounded-circle">
                                        <div>
                                            <h6 class="mb-1">Sophia Miller <span class="fs-11 fw-normal ms-2"><i class="bi bi-star-fill text-warning me-1"></i>(4.5)</span></h6>
                                            <p class="text-muted mb-1">Artificial Intelligence</p>
                                        </div>
                                    </div>
                                    <small class="text-muted">22 Courses • 16K Students</small>
                                </li>
                            </ul>

                        </div>
                    </div>
                </div>
                <div class="col-xl-4">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Assignment Progress</h5>
                            <div class="dropdown ms-auto">
                                <a href="javascript:void(0)" data-bs-toggle="dropdown" class="text-muted">
                                    <i class="bi bi-three-dots-vertical"></i>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li><a class="dropdown-item" href="javascript:void(0)">Tday</a></li>
                                    <li><a class="dropdown-item" href="javascript:void(0)">This Week</a></li>
                                    <li><a class="dropdown-item" href="javascript:void(0)">This Month</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="card-body">
                            <section class="px-5 mx-n5" data-simplebar style="max-height: 410px;">
                                <div class="d-flex gap-4 align-items-center p-3 border rounded-3 mb-4">
                                    <div class="circular-progress circular-sm circular-progress-primary" style="--progress: 55;">
                                        <svg class="circular-inner" viewBox="0 0 56 56">
                                            <circle class="bg-circular-progress"></circle>
                                            <circle class="fg-circular-progress"></circle>
                                        </svg>
                                        <div class="circular-text">55%</div>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">Web Development Basics</h6>
                                        <p class="text-muted mb-0">150 Tasks</p>
                                    </div>
                                    <div class="dropdown ms-auto">
                                        <a href="javascript:void(0)" data-bs-toggle="dropdown" class="text-muted">
                                            <i class="bi bi-three-dots-vertical"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li><a class="dropdown-item" href="javascript:void(0)">View</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0)">Edit</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0)">Delete</a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="d-flex gap-4 align-items-center p-3 border rounded-3 mb-4">
                                    <div class="circular-progress circular-sm circular-progress-info" style="--progress: 75;">
                                        <svg class="circular-inner" viewBox="0 0 56 56">
                                            <circle class="bg-circular-progress"></circle>
                                            <circle class="fg-circular-progress"></circle>
                                        </svg>
                                        <div class="circular-text">75%</div>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">Advanced JavaScript</h6>
                                        <p class="text-muted mb-0">45 Tasks</p>
                                    </div>
                                    <div class="dropdown ms-auto">
                                        <a href="javascript:void(0)" data-bs-toggle="dropdown" class="text-muted">
                                            <i class="bi bi-three-dots-vertical"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li><a class="dropdown-item" href="javascript:void(0)">View</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0)">Edit</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0)">Delete</a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="d-flex gap-4 align-items-center p-3 border rounded-3 mb-4">
                                    <div class="circular-progress circular-sm circular-progress-danger" style="--progress: 63;">
                                        <svg class="circular-inner" viewBox="0 0 56 56">
                                            <circle class="bg-circular-progress"></circle>
                                            <circle class="fg-circular-progress"></circle>
                                        </svg>
                                        <div class="circular-text">63%</div>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">React & Vue Frameworks</h6>
                                        <p class="text-muted mb-0">90 Tasks</p>
                                    </div>
                                    <div class="dropdown ms-auto">
                                        <a href="javascript:void(0)" data-bs-toggle="dropdown" class="text-muted">
                                            <i class="bi bi-three-dots-vertical"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li><a class="dropdown-item" href="javascript:void(0)">View</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0)">Edit</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0)">Delete</a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="d-flex gap-4 align-items-center p-3 border rounded">
                                    <div class="circular-progress circular-sm circular-progress-warning" style="--progress: 46;">
                                        <svg class="circular-inner" viewBox="0 0 56 56">
                                            <circle class="bg-circular-progress"></circle>
                                            <circle class="fg-circular-progress"></circle>
                                        </svg>
                                        <div class="circular-text">46%</div>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">Backend Development</h6>
                                        <p class="text-muted mb-0">60 Tasks</p>
                                    </div>
                                    <div class="dropdown ms-auto">
                                        <a href="javascript:void(0)" data-bs-toggle="dropdown" class="text-muted">
                                            <i class="bi bi-three-dots-vertical"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li><a class="dropdown-item" href="javascript:void(0)">View</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0)">Edit</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0)">Delete</a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="d-flex gap-4 align-items-center p-3 border rounded mt-3">
                                    <div class="circular-progress circular-sm circular-progress-success" style="--progress: 72;">
                                        <svg class="circular-inner" viewBox="0 0 56 56">
                                            <circle class="bg-circular-progress"></circle>
                                            <circle class="fg-circular-progress"></circle>
                                        </svg>
                                        <div class="circular-text">72%</div>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">UI/UX Design Fundamentals</h6>
                                        <p class="text-muted mb-0">85 Tasks</p>
                                    </div>
                                    <div class="dropdown ms-auto">
                                        <a href="javascript:void(0)" data-bs-toggle="dropdown" class="text-muted">
                                            <i class="bi bi-three-dots-vertical"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li><a class="dropdown-item" href="javascript:void(0)">View</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0)">Edit</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0)">Delete</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </section>
                        </div>
                    </div>

                </div>
                <div class="col-xl-4">
                    <div class="card">
                        <div class="d-flex justify-content-between align-items-center card-header">
                            <h5 class="card-title mb-0">Notice Board</h5>
                            <div class="dropdown">
                                <a href="javascript:void(0)" data-bs-toggle="dropdown" class="text-muted">
                                    <i class="bi bi-three-dots-vertical"></i>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li><a class="dropdown-item" href="javascript:void(0)">View All</a></li>
                                    <li><a class="dropdown-item" href="javascript:void(0)">Import</a></li>
                                    <li><a class="dropdown-item" href="javascript:void(0)">Export</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="p-0 card-body">
                            <div class="table-box table-responsive">
                                <table class="table mb-0">
                                    <tbody>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center gap-4">
                                                    <div class="avatar-md bg-warning-subtle text-warning d-flex justify-content-center align-items-center rounded">
                                                        <i class="ri-user-community-line fs-5"></i>
                                                    </div>
                                                    <div>
                                                        <div class="fw-medium d-block mb-1 fs-14">Parents Meeting</div>
                                                        <p class="text-muted fs-12 mb-0 max-w-300px">An interactive session to discuss students' progress and academic performance.</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="text-end"><span class="badge bg-light text-body">20 Mar 2025</span></td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center gap-4">
                                                    <div class="avatar-md bg-danger-subtle text-danger d-flex justify-content-center align-items-center rounded">
                                                        <i class="ri-swap-2-fill fs-5"></i>
                                                    </div>
                                                    <div>
                                                        <div class="fw-medium d-block mb-1 fs-14">Teachers Workshop</div>
                                                        <p class="text-muted fs-12 mb-0 max-w-300px">A professional development event focusing on innovative teaching methods.</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="text-end"><span class="badge bg-light text-body">25 Mar 2025</span></td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center gap-4">
                                                    <div class="avatar-md bg-primary-subtle text-primary d-flex justify-content-center align-items-center rounded">
                                                        <i class="ri-exchange-funds-line fs-5"></i>
                                                    </div>
                                                    <div>
                                                        <div class="fw-medium d-block mb-1 fs-14">Art & Science Exhibition</div>
                                                        <p class="text-muted fs-12 mb-0 max-w-300px">Students showcase their creativity and scientific projects in an engaging exhibition.</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="text-end"><span class="badge bg-light text-body">30 Mar 2025</span></td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center gap-4">
                                                    <div class="avatar-md bg-success-subtle text-success d-flex justify-content-center align-items-center rounded">
                                                        <i class="ri-exchange-2-line fs-5"></i>
                                                    </div>
                                                    <div>
                                                        <div class="fw-medium d-block mb-1 fs-14">Cultural Festival</div>
                                                        <p class="text-muted fs-12 mb-0 max-w-300px">A vibrant celebration of diverse traditions, music, and dance performances.</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="text-end"><span class="badge bg-light text-body">2 April 2025</span></td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center gap-4">
                                                    <div class="avatar-md bg-info-subtle text-info d-flex justify-content-center align-items-center rounded">
                                                        <i class="ri-slideshow-view fs-5"></i>
                                                    </div>
                                                    <div>
                                                        <div class="fw-medium d-block mb-1 fs-14">Annual Talent Show</div>
                                                        <p class="text-muted fs-12 mb-0 max-w-300px">A stage for students to display their talents in music, dance, and drama.</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="text-end"><span class="badge bg-light text-body">15 April 2025</span></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div> -->


    </div><!--End container-fluid-->
</main>
<!--End app-wrapper-->
<script>
    var statusCont = '<?php echo isset($monthChart) ? json_encode($monthChart) : 0 ?>';

    if (statusCont.length > 0) {
        var rows = JSON.parse(statusCont);
        var cont = [];
        var sts = [];
        rows.forEach(function(i) {
            cont.push(i.cont);
            sts.push(i.month);
        })

        var options = {
            series: [{
                name: 'Request',
                data: cont
            }],
            chart: {
                height: 320,
                type: 'bar',
                toolbar: {
                    show: false
                },
            },
            plotOptions: {
                bar: {
                    columnWidth: '35%',
                    borderRadius: 8,
                }
            },
            dataLabels: {
                enabled: false
            },
            legend: {
                show: false
            },
            xaxis: {
                categories: sts,
                labels: {
                    style: {
                        fontSize: '12px'
                    }
                }
            },
            fill: {
                type: 'gradient',
                gradient: {
                    shade: 'light',
                    type: 'vertical',
                    shadeIntensity: 0.4,
                    gradientToColors: ['#ffcc80', '#ffe0b2'],
                    inverseColors: false,
                    opacityFrom: 1,
                    opacityTo: 1,
                    stops: [0, 100]
                }
            },
            colors: ['#ffb74d']
        };

        var chart = new ApexCharts(document.querySelector("#chart"), options);
        chart.render();
    }


    var pieChartData = '<?php echo isset($pieChart) ? json_encode($pieChart) : 0 ?>';
    if (pieChartData.length > 0) {
        var rows = JSON.parse(pieChartData);
        var cont1 = [];
        var service = [];
        rows.forEach(function(i) {
            cont1.push(parseInt(i.cont));
            service.push(i.service_type);
        })
        var options = {
            series: cont1,
            chart: {
                width: 380,
                type: 'pie',
            },
            labels: service,
            responsive: [{
                breakpoint: 480,
                options: {
                    chart: {
                        width: 300,
                        height: 300
                    },
                    legend: {
                        position: 'bottom'
                    }
                }
            }]
        };

        var chart = new ApexCharts(document.querySelector("#sales_managment"), options);
        chart.render();
    }

    userAnalytics();

    function userAnalytics() {

    var requestCont = <?php echo isset($monthChart) ? json_encode($monthChart) : '[]'; ?>;
    var adCont      = <?php echo isset($adChart) ? json_encode($adChart) : '[]'; ?>;
    var vendorCont  = <?php echo isset($usersChart) ? json_encode($usersChart) : '[]'; ?>;

    let months = [];
    let cont1 = {}, cont2 = {}, cont3 = {};

    // Build maps
    requestCont.forEach(i => {
        months.push(i.month);
        cont1[i.month] = parseInt(i.cont);
    });

    adCont.forEach(i => {
        cont2[i.month] = parseInt(i.cont);
        if (!months.includes(i.month)) months.push(i.month);
    });

    vendorCont.forEach(i => {
        cont3[i.month] = parseInt(i.cont);
        if (!months.includes(i.month)) months.push(i.month);
    });

    // Sort months (optional if format is YYYY-MM)
    months.sort();

    // Align data
    let reqData = [];
    let adData = [];
    let vendorData = [];

    months.forEach(m => {
        reqData.push(cont1[m] ?? 0);
        adData.push(cont2[m] ?? 0);
        vendorData.push(cont3[m] ?? 0);
    });

    var options = {
        series: [
            { name: 'Total Requests', data: reqData },
            { name: 'Total Advertisement', data: adData },
            { name: 'Total Vendors', data: vendorData }
        ],
        chart: {
            height: 350,
            type: 'area'
        },
        dataLabels: { enabled: false },
        stroke: { curve: 'smooth' },
        xaxis: {
            categories: months
        },
        yaxis: {
            title: { text: 'Count' }
        },
        tooltip: { shared: true }
    };

    var chart = new ApexCharts(document.querySelector("#userChart"), options);
    chart.render();
}


    


      



    var locationChart = '<?php echo isset($locationChart) ? json_encode($locationChart) : "[]"; ?>';

    if (locationChart !== "[]" && locationChart.length > 2) {

        var rows = JSON.parse(locationChart);
        var locData = [];
        rows.forEach(function(i) {
            locData.push({
                x: i.location,
                y: i.cont
            });
        });
        var options = {
            series: [{
                data: locData
            }],
            chart: {
                height: 350,
                type: 'treemap'
            },
            legend: {
                show: false
            },
            title: {
                text: 'Location Request'
            }
        };
        var chart = new ApexCharts(document.querySelector("#location-chart"), options);
        chart.render();
    }
</script>
@endsection