 @extends('backend.app_template')
 @section('title','Ads Management')
 @section('content')
 <main class="app-wrapper">
     <div class="container-fluid">

         <div class="d-flex align-items-center mt-2 mb-2">
             <h6 class="mb-0 flex-grow-1">Ads Management</h6>
             <div class="flex-shrink-0">
                 <nav aria-label="breadcrumb">
                     <ol class="breadcrumb justify-content-end mb-0">
                         <li class="breadcrumb-item"><a href="javascript:void(0)">Pages</a></li>
                         <li class="breadcrumb-item active" aria-current="page">Ads Management</li>
                     </ol>
                 </nav>
             </div>
         </div>
         <div class="row">
             <div class="card">
                 <div class="card-body">
                     <form method="POST" action="<?= route('ads-management') ?>">
                        @csrf
                         <div class="row">
                             <div class="col-md-4">
                                 <label>Select Date Range</label>
                                 <input type="text" id="range-picker"  class="form-control" name="from" value="<?= isset($from) ? $from:'' ?>" />
                             </div>
                             <div class="col-md-4">
                                 <label>Service Type</label>
                                 <select  class="form-control select2" id="service" name="service" >
                                     <option value="">--select--</option>
                                     <?php
                                        if (isset($serviceData)) {
                                            foreach ($serviceData as $val) { ?>
                                             <option <?php echo (isset($service) && $service == $val->id) ? 'selected' : '' ?> value="<?php echo $val->id ?>"><?php echo ucwords($val->service_type) ?></option>
                                     <?php }
                                        }
                                        ?>
                                 </select>
                             </div>
                             
                         </div>
                         <div class="d-flex mt-2">
                                <input type="submit" name="submit" value="Search" class="btn btn-primary" />
                         </div>
                         

                     </form>
                 </div>
             </div>

             <table id="datatables" class="table table-responsive   table-bordered w-100 mt-5">
                 <thead>
                     <tr>
                         <th>S.No</th>
                         <th>Service Name</th>
                         <th>Service Type</th>
                         <th>Contact</th>
                         <th>Date Posted</th>                        
                         <th>Status</th>
                         <th>View Details</th>
                         <th>Action</th>                     
                     </tr>
                 </thead>
                 <tbody>
                     <?php if (isset($records)) {
                            $i = 1;
                            foreach ($records as $key => $row) {
                        ?>
                             <tr>
                                 <td><?php echo $i ?></td>
                                 <td><?php echo $row->name ?></td>
                                 <td><?php echo $row->service_type ?></td>
                                 <td><?php echo $row->phone ?></td>
                                 <td><?php echo date('d M Y',strtotime($row->created_at)) ?></td>
                                 <td><a data-placement="top" title="Status" data-original-title="Status" href="javascript:void(0)" onclick="changeStatus('<?php echo $row->id ?>','<?php echo ($row->status == 1) ? 0 : (($row->status == 2) ? 1:0) ?>','Advertisement')" class="badge bg-pill bg-<?php echo ($row->status == 1) ? 'success' :(($row->status == 2) ? 'warning':'danger')  ?>"><?php echo ($row->status == 1) ? 'Active' : (($row->status == 2) ? 'Block':'In-Active') ?></a></td>
                                 <td>
                                    <a onclick="showDetails('<?= $row->service_id ?>')" href="javascript:void(0)"  class="badge bg-pill bg-danger"><i class="bi bi-eye"></i> View Details</a>
                                 </td>
                                <td>
                                    <a data-bs-toggle="tooltip" data-bs-title="<?= ($row->status == 2) ? 'Un Block':'Block' ?>" title="<?= ($row->status == 2) ? 'Un Block':'Block' ?>" data-original-title="<?= ($row->status == 2) ? 'UnBlock':'Block' ?>" href="javascript:void(0)" onclick="changeStatus('<?php echo $row->id ?>','<?= ($row->status == 2) ? 1:2 ?>','Advertisement')" class="btn btn-sm btn-primary"><i class="<?= ($row->status == 2) ? 'bi bi-unlock-fill':'bi bi-ban-fill' ?> "></i></a>                                   
                                    <a data-bs-toggle="tooltip" data-bs-title="Delete" title="Delete" data-original-title="Delete" href="javascript:void(0)" onclick="commonDelete('<?php echo $row->id ?>','Advertisement')" class="btn btn-sm btn-danger"><i class="bi bi-trash-fill"></i></a>                                    
                                </td>           
                             </tr>
                     <?php $i++;
                            }
                        } ?>

                 </tbody>
             </table>
         </div>
     </div>
 </main>
 @endsection