<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\CategoryModel;
use App\Models\ProductAttributeModel;
use App\Models\ProductBrandModel;
use App\Models\ProductIndustryModel;
use App\Models\ProductModel;
use App\Models\ProductTypeModel;
use App\Models\SizeModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;

class ProductController extends Controller
{
    public function products()
    {
        $records   =  ProductModel::orderBy('id', 'ASC')->get();
        return view('backend.products.list', compact('records'));
    }

    public function addProduct($id = '')
    {
        $categoryData  = CategoryModel::Where('status', 1)->get();
        $sizeData      = SizeModel::Where('status', 1)->get();
        $industryData  = ProductIndustryModel::Where('status', 1)->get();
        $typeData      = ProductTypeModel::Where('status', 1)->get();
        $brandData     = ProductBrandModel::Where('status', 1)->get();
        if ($id > 0) {
            $record       = ProductModel::Where('id', $id)->first();
            $productItems = ProductAttributeModel::Where('product_id', $id)->get();
            return view('backend.products.edit', compact('record', 'productItems', 'categoryData', 'sizeData', 'brandData', 'typeData', 'industryData'));
        } else {
            return view('backend.products.add', compact('categoryData', 'sizeData', 'typeData', 'brandData', 'industryData'));
        }
    }

    public function storeUpdateproducts(Request  $request)
    {
        $input         = $request->all();
        $id            = $input['id'];
        $product_name  = isset($input['product_name']) ? $input['product_name'] : '';
        $category_id   = isset($input['category_id']) ? $input['category_id'] : '';
        $industry_id   = isset($input['industry_id']) ? $input['industry_id'] : '';
        $brand_id             = isset($input['brand_id']) ? $input['brand_id'] : '';
        $type_id                   = isset($input['type_id']) ? $input['type_id'] : '';
        $product_description       = isset($input['product_description']) ? $input['product_description'] : '';
        $product_type       = isset($input['size_type']) ? $input['size_type'] : '';
        $product_size       = isset($input['size']) ? $input['size'] : '';
        $item_id            = isset($input['item_id']) ? $input['item_id'] : '';
        $product_image            = isset($input['product_image']) ? $input['product_image'] : '';
        $broucher            = isset($input['broucher']) ? $input['broucher'] : '';


        if ($id == "") {
            /* Insert */
            $insertArr = array(
                'product_name'    => $product_name,
                'category_id'    => implode(",", $category_id),
                'industry_id'    => implode(",", $industry_id),
                'brand_id'    => implode(",", $brand_id),
                'type_id'    => $type_id,
                'product_description'    => $product_description,
            );

            $insert = ProductModel::create($insertArr);
            if ($insert['id'] > 0) {

                foreach($product_size as $k=>$val)
                {
                     $insertAr = array(
                        'product_type'   => $product_type[$k],
                        'product_size'   => $product_size[$k]
                    );
                    if (isset($request->file('product_image')[$k])) {
                        $image = $request->file('product_image')[$k];
                        $imageName = 'product_image' . time() . '_' . str_replace(' ', '_', $image->getClientOriginalName());
                        $image->move(public_path('/uploads/product_image/'), $imageName);
                        $imageUrl = URL::to('/') . '/uploads/product_image/' . $imageName;
                        $insertAr['product_image'] = $imageUrl;
                    }
                    if (isset($request->file('broucher')[$k])) {
                        $broucher = $request->file('broucher')[$k];
                        $broucherName = 'broucher' . time() . '_' . str_replace(' ', '_', $broucher->getClientOriginalName());
                        $broucher->move(public_path('/uploads/broucher/'), $broucherName);
                        $broucherUrl = URL::to('/') . '/uploads/broucher/' . $broucherName;
                        $insertAr['broucher'] = $broucherUrl;
                    }
                    ProductAttributeModel::create($insertAr);
                }               
                return redirect()->route('products')->with('success', 'Pages Saved Successfully');
            }
        } else {
            $insertArr = array(
                'product_name'    => $product_name,
                'category_id'    => implode(",", $category_id),
                'industry_id'    => implode(",", $industry_id),
                'brand_id'    => implode(",", $brand_id),
                'type_id'    => $type_id,
                'product_description'    => $product_description,
            );
            $update = ProductModel::Where('id', $id)->update($insertArr);

            foreach ($item_id as $k => $val) {
                if ($val == '' || $val == 0) {
                    /** if id is not new list will insert */
                    $insertAr = array(
                        'product_type'   => $product_type[$k],
                        'product_size'   => $product_size[$k]
                    );
                    if (isset($request->file('product_image')[$k])) {
                        $image = $request->file('product_image')[$k];
                        $imageName = 'product_image' . time() . '_' . str_replace(' ', '_', $image->getClientOriginalName());
                        $image->move(public_path('/uploads/product_image/'), $imageName);
                        $imageUrl = URL::to('/') . '/uploads/product_image/' . $imageName;
                        $insertAr['product_image'] = $imageUrl;
                    }
                    if (isset($request->file('broucher')[$k])) {
                        $broucher = $request->file('broucher')[$k];
                        $broucherName = 'broucher' . time() . '_' . str_replace(' ', '_', $broucher->getClientOriginalName());
                        $broucher->move(public_path('/uploads/broucher/'), $broucherName);
                        $broucherUrl = URL::to('/') . '/uploads/broucher/' . $broucherName;
                        $insertAr['broucher'] = $broucherUrl;
                    }
                    ProductAttributeModel::create($insertAr);
                } else {
                    /** if id is available new list will update */
                    $insertAr = array(
                        'product_type'   => $product_type[$k],
                        'product_size'   => $product_size[$k]
                    );
                    if (isset($request->file('product_image')[$k])) {
                        $image = $request->file('product_image')[$k];
                        $imageName = 'product_image' . time() . '_' . str_replace(' ', '_', $image->getClientOriginalName());
                        $image->move(public_path('/uploads/product_image/'), $imageName);
                        $imageUrl = URL::to('/') . '/uploads/product_image/' . $imageName;
                        $insertAr['product_image'] = $imageUrl;
                    }
                    if (isset($request->file('broucher')[$k])) {
                        $broucher = $request->file('broucher')[$k];
                        $broucherName = 'broucher' . time() . '_' . str_replace(' ', '_', $broucher->getClientOriginalName());
                        $broucher->move(public_path('/uploads/broucher/'), $broucherName);
                        $broucherUrl = URL::to('/') . '/uploads/broucher/' . $broucherName;
                        $insertAr['broucher'] = $broucherUrl;
                    }
                    ProductAttributeModel::Where('product_id', $id)->Where('id', $val)->update($insertAr);
                }
            }
            return redirect()->route('products')->with('success', 'Product Updated Successfully');
        }
    }
}
