<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\SizeModel;
use Illuminate\Http\Request;

class SizeController extends Controller
{
      public function size()
    {
        $records   =  SizeModel::orderBy('id', 'ASC')->get();
        return view('backend.size.list', compact('records'));
    }

    public function addSize($id = '')
    {
        $record = '';
        if ($id > 0) {
            $record = SizeModel::WHere('id', $id)->first();
        }
        return view('backend.size.add_edit', compact('record'));
    }

    public function storeUpdateSize(Request $request)
    {
        $input     = $request->all();
        $id        = isset($input['id']) ? $input['id'] : 0;

        $dataArr = [];
        foreach ($input as $key => $val) {
            if ($key != '_token' && $key != 'id' )
                $dataArr[$key] = $val;
        }       
        if ($id == 0 || $id == '') {
            $request->validate([
                'size'          =>  "required|unique:size,size",
                'size_type'          =>  "required",
              
            ]);
           $insert = SizeModel::create($dataArr);
           if($insert['id'] > 0)
           {
               return redirect()->route('size')->with('success', 'Size Saved Successfully');
           }else{
               return redirect()->route('size')->with('error', 'Something went wrong!');
           }
           
        } else {
            $request->validate([
                'size'          =>  "required",
                'size_type'     =>  "required",
            ]);
            $update = SizeModel::Where('id',$id)->update($dataArr);
            return redirect()->route('size')->with('success', 'Size Updated Successfully');;
        }        
    }
}
