<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\UserVedio;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;

class UserGuideController extends Controller
{
    public function userVideo()
    {

        $records   =  UserVedio::orderBy('id', 'desc')->get();
        return view('backend.user_guide.list', compact('records'));
    }



    public function info()
    {
        return view('backend.info');
    }

    public function userVideoDetails($id = '')
    {
        $record = '';
        if ($id > 0) {
            $record = UserVedio::Where('id', $id)->first();
        }
        return view('backend.user_guide.add_edit', compact('record'));
    }

    public function storeUpdateUserVideo(Request $request)
    {


        $input     = $request->all();
        $id        = isset($input['id']) ? $input['id'] : 0;
        $old_vedio = isset($input['old_vedio']) ? $input['old_vedio'] : 0;


        if ($request->file('video') != '') {

            $vedio = $request->file('video');
            $imageName = 'user_guide_vedio_' . time() . '_' . str_replace(' ', '_', $vedio->getClientOriginalName());
            $vedio->move(public_path('/uploads/user_vedio/'), $imageName);
            $videoUrl = URL::to('/') . '/uploads/user_vedio/' . $imageName;

        } else {
            $videoUrl =  $old_vedio;
        }



        $dataArr = array(
            'vedio' => $videoUrl
        );

        if ($id == 0 || $id == '') {


            $insert = UserVedio::create($dataArr);

            if ($insert['id'] > 0) {
                return redirect()->route('userVideo')->with('success', 'Video Saved Successfully');
            } else {
                return redirect()->route('userVideo')->with('error', 'Something went wrong!');
            }
        } else {

            $update = UserVedio::Where('id', $id)->update($dataArr);

            return redirect()->route('userVideo')->with('success', 'Video Updated Successfully');;
        }
    }
}
