 @extends('backend.app_template')
 @section('title','Product Add')
 @section('content')

 <main class="app-wrapper">
     <div class="container-fluid">

         <div class="d-flex align-items-center mt-2 mb-2">

             <div class="flex-shrink-0">
                 <nav aria-label="breadcrumb">
                     <ol class="breadcrumb justify-content-end mb-0">
                         <li class="breadcrumb-item"><a href="javascript:void(0)">Product Add</a></li>
                         <li class="breadcrumb-item active" aria-current="page"></li>
                     </ol>
                 </nav>
             </div>
         </div>
         <div class="row">
             <div class="col-xl-12 col-xxl-12">
                 <form method="POST" id="countryForm" action="<?= route('storeUpdateproducts') ?>" enctype="multipart/form-data">
                     @csrf
                     <div>
                         <div class="card">
                             <span></span>
                             <!-- Logistics Details Section -->
                             <div class="card-header">
                                 <h5 class="mb-0">Add Product</h5>
                                 <div class="float-end">
                                     <a href="<?= route('products') ?>" class="btn btn-primary">Back</a>
                                 </div>
                             </div>
                             <input type="hidden" name="id" value="" />
                             <div class="card-body">
                                 <div class="row g-4">
                                     <div class="col-xl-4">
                                         <label for="product_name" class="form-label">Product Name<span class="text-danger"> *</span></label>
                                         <input type="text" value="" class="form-control" id="product_name" name="product_name" placeholder="Enter Product Name">
                                         @error('product_name') <span class="text-danger">{{$message}}</span> @enderror
                                     </div>

                                     <div class="col-xl-4">
                                         <label for="category_id" class="form-label">Category<span class="text-danger"> *</span></label>
                                         <select class="form-control select2" multiple id="category_id" name="category_id[]">
                                             <option value="">--select--</option>
                                             <?php
                                                if (isset($categoryData)) {
                                                    foreach ($categoryData as $val) { ?>
                                                     <option value="<?php echo $val->id ?>"><?php echo ucwords($val->category_name) ?></option>
                                             <?php }
                                                }  ?>
                                         </select>
                                         @error('category_id') <span class="text-danger">{{$message}}</span> @enderror
                                     </div>

                                     <div class="col-xl-4">
                                         <label for="industry_id" class="form-label">Industry<span class="text-danger"> *</span></label>
                                         <select class="form-control select2" multiple id="industry_id" name="industry_id[]">
                                             <option value="">--select--</option>
                                             <?php
                                                if (isset($industryData)) {
                                                    foreach ($industryData as $val) { ?>
                                                     <option value="<?php echo $val->id ?>"><?php echo ucwords($val->industry) ?></option>
                                             <?php }
                                                }  ?>
                                         </select>
                                         @error('industry_id') <span class="text-danger">{{$message}}</span> @enderror
                                     </div>


                                     <div class="col-xl-4">
                                         <label for="brand_id" class="form-label">Brand<span class="text-danger"> *</span></label>
                                         <select class="form-control select2" multiple id="brand_id" name="brand_id[]">
                                             <option value="">--select--</option>
                                             <?php
                                                if (isset($brandData)) {
                                                    foreach ($brandData as $val) { ?>
                                                     <option value="<?php echo $val->id ?>"><?php echo ucwords($val->brand) ?></option>
                                             <?php }
                                                }  ?>
                                         </select>
                                         @error('brand_id') <span class="text-danger">{{$message}}</span> @enderror
                                     </div>


                                     <div class="col-xl-4">
                                         <label for="type_id" class="form-label">Type<span class="text-danger"> *</span></label>
                                         <select class="form-control select2" id="type_id" name="type_id">
                                             <option value="">--select--</option>
                                             <?php
                                                if (isset($typeData)) {
                                                    foreach ($typeData as $val) { ?>
                                                     <option value="<?php echo $val->id ?>"><?php echo ucwords($val->type) ?></option>
                                             <?php }
                                                }  ?>
                                         </select>
                                         @error('type_id') <span class="text-danger">{{$message}}</span> @enderror
                                     </div>

                                     <div class="col-xl-12">
                                         <label for="type_id" class="form-label">Product Description</label>
                                         <textarea class="form-control" id="product_description" name="product_description"></textarea>
                                     </div>

                                     <table style="width:100%" class="table">
                                         <tr>
                                             <th>Image</th>
                                             <th>Broucher</th>
                                             <th>Product Type</th>
                                             <th>Product Size</th>
                                             <th>Action</th>
                                         </tr>
                                         <tbody id="invoiceBody">
                                             <tr class="all_tr_td_values">
                                                 <td style="width:20%">
                                                     <input data-row="0" data-name="product_image" id="product_image0" type="file" name="product_image[]" id="product_image" class="form-control">
                                                 </td>
                                                 <td style="width:20%">
                                                     <input data-row="0" data-name="broucher" id="broucher0" type="file" name="broucher[]" id="broucher" class="form-control">
                                                 </td>
                                                 <td style="width:20%">
                                                     <select class="form-control select2" data-row="0" data-name="size_type" id="size_type0" name="size_type[]">
                                                         <option value="">--select--</option>
                                                         <option  value="1">Size</option>
                                                         <option  value="2">Range</option>
                                                         <option  value="3">Capacity</option>
                                                     </select>
                                                 </td>
                                                  <td style="width:20%">
                                                     <select class="form-control select2" data-row="0" data-name="size" id="size0" name="size[]">
                                                         <option value="">--select--</option>
                                                          <?php
                                                            if (isset($sizeData)) {
                                                                foreach ($sizeData as $val) { ?>
                                                                <option value="<?php echo $val->id ?>"><?php echo ucwords($val->size) ?></option>
                                                        <?php } }  ?>
                                                     </select>
                                                 </td>
                                                 <td style="width:10%">
                                                     <button type="button" class="btn btn-sm btn-success" onclick="addRow('invoiceBody');"><i class="bi bi-plus"></i></button>
                                                     <button type="button" data-row="0" id="delete" onclick="deleteItem(this)" class="btn btn-sm btn-danger"><i class="bi bi-trash"></i></button>
                                                 </td>
                                             </tr>
                                         </tbody>

                                     </table>

                                 </div>

                             </div>
                         </div>
                     </div>
                     <div class="d-flex justify-content-end gap-3 my-5">
                         <a href="" class="btn btn-light-light text-muted">Cancel</a>
                         <button type="submit" class="btn btn-primary">Save</button>
                     </div>
                 </form>
             </div>

         </div>
         <!-- Submit Section -->
     </div>
 </main>
 <script type="text/javascript" src="//cdn.ckeditor.com/4.5.1/standard/ckeditor.js"></script>
 <script>
     CKEDITOR.config.versionCheck = false;
     CKEDITOR.replace('product_description');


      function addRow(content_id, label_checkbox = '') {
        var row = $("#" + content_id + " tr:last");
        row.find("select").each(function(index) {
            $(this).select2('destroy');
        });
        row.clone().find("input, textarea, select, button, checkbox, radio, label").each(function(j, obj) {
            i = $(this).data('row') + 1;
            id = $(this).data('name') + i;
            $(this).val('').attr({
                'id': id,
                'data-row': i
            });

        }).end().appendTo("#" + content_id);

        row.find("select").each(function(index) {
            $("select").select2();
        });
    }

    function deleteItem(e) {
        var id = e.dataset.row;
        if (id != 0) {
            if (confirm("are you sure you want delete?") === true) {
                $('#product_image' + id).parent().parent().remove();
            }

        }
    }

     $(function() {
         $("#countryForm").validate({
             rules: {
                 eye_color: {
                     required: true
                 },

             },
             messages: {
                 eye_color: {
                     required: "Please enter eye color"
                 },
             },
             errorElement: "span",
             errorPlacement: function(error, element) {
                 error.addClass("text-danger");
                 error.insertAfter(element);
             }
         });
     });
 </script>
 @endsection