 @extends('backend.app_template')
 @section('title','Vendors')
 @section('content')
 <main class="app-wrapper">
     <div class="container-fluid">

         <div class="d-flex align-items-center mt-2 mb-2">
             <h6 class="mb-0 flex-grow-1">Vendors</h6>
             <div class="flex-shrink-0">
                 <nav aria-label="breadcrumb">
                     <ol class="breadcrumb justify-content-end mb-0">
                         <li class="breadcrumb-item"><a href="javascript:void(0)">Pages</a></li>
                         <li class="breadcrumb-item active" aria-current="page">Vendors</li>
                     </ol>
                 </nav>
             </div>
         </div>
         <div class="row">
             <div class="card">
                 <div class="card-body">
                     <form method="POST" action="<?= route('vendors') ?>">
                        @csrf
                         <div class="row">
                             <div class="col-md-4">
                                 <label>Select Date Range</label>
                                 <input type="text" id="range-picker"  class="form-control" name="from" value="<?= isset($from) ? $from:'' ?>"s />
                             </div>
                             
                             
                         </div>
                         <div class="d-flex mt-2">
                                <input type="submit" name="submit" value="Search" class="btn btn-primary" />
                         </div>
                         

                     </form>
                 </div>
             </div>

             <table id="datatables" class="table table-responsive   table-bordered w-100 mt-5">
                 <thead>
                     <tr>
                         <th>S.No</th>
                         <th>Name</th>                        
                         <th>No. of Ads Posted</th>
                         <th>No. of Requests Accepted</th>                        
                         <th>Status</th>
                         <th>Contact</th>
                         <th>Email</th>
                         <th>View Details</th>
                         <th>Action</th>                     
                     </tr>
                 </thead>
                 <tbody>
                     <?php if (isset($records)) {
                            $i = 1;
                            foreach ($records as $key => $row) {
                        ?>
                             <tr>
                                 <td><?php echo $i ?></td>
                                 <td><?php echo $row->name ?></td>                                 
                                 <td><?php echo $row->cont ?></td>                                 
                                 <td><?php echo $row->accepted ?></td>
                                 <td><a data-placement="top" title="Status" data-original-title="Status" href="javascript:void(0)" onclick="changeStatus('<?php echo $row->user_id ?>','<?php echo ($row->status == 1) ? 0 : (($row->status == 2 || $row->status == 0) ? 1:0) ?>','User')" class="badge bg-pill bg-<?php echo ($row->status == 1) ? 'success' :(($row->status == 2) ? 'warning':'danger')  ?>"><?php echo ($row->status == 1) ? 'Active' : (($row->status == 2) ? 'Block':'In-Active') ?></a></td>
                                 <td><?php echo $row->mobile ?></td>
                                 <td><?php echo $row->email ?></td>
                                 <td>
                                    <a  href="<?= route('vendorDetails',[$row->user_id]) ?>"  class="badge bg-pill bg-danger"><i class="bi bi-eye"></i> View</a>
                                 </td>
                                <td>
                                    <a data-bs-toggle="tooltip" data-bs-title="<?= ($row->status == 2) ? 'Un Block':'Block' ?>" title="<?= ($row->status == 2) ? 'Un Block':'Block' ?>" data-original-title="<?= ($row->status == 2) ? 'UnBlock':'Block' ?>" href="javascript:void(0)" onclick="changeStatus('<?php echo $row->user_id ?>','<?= ($row->status == 2) ? 1:2 ?>','User')" class="btn btn-sm btn-<?= ($row->status == 2) ? 'danger':'success' ?>"><i class="<?= ($row->status == 2) ? 'bi bi-shield-fill-x':'bi bi-shield-fill-check' ?> "></i></a>                                   
                                    <a data-bs-toggle="tooltip" data-bs-title="Delete Vendor" title="Delete Vendor" data-original-title="Delete Vendor" href="javascript:void(0)" onclick="changeStatus('<?php echo $row->user_id ?>','3','User')" class="btn btn-sm btn-danger"><i class="bi bi-shield-fill-x"></i></a>                                   
                                </td>           
                             </tr>
                     <?php $i++;
                            }
                        } ?>

                 </tbody>
             </table>
         </div>
     </div>
 </main>
 <div class="modal fade" id="videoModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalLabel">
                   Verification Video
                </h5>
                <button type="button" class="btn-close icon-btn-sm" data-bs-dismiss="modal" aria-label="Close">
                    <i class="ri-close-large-line fw-semibold"></i>
                </button>
            </div>
            <div class="modal-body">
                 <video id="modalVideo" width="100%" height="430" controls>
                    <source id="videoSource" src="" type="video/mp4">
                    Your browser does not support the video tag.
                </video>
            </div>           
        </div>
    </div>
</div>
 <script>
    function watchVideo(url)
    {
        const videoSrc = $("#videoSource");
        const video = $("#modalVideo")[0];
        $('#videoModal').modal('show');
        videoSrc.attr("src", url);   
        video.load();
        video.play();
    }
 </script>
 @endsection