 @extends('backend.app_template')
 @section('title','Web Requests')
 @section('content')
 <main class="app-wrapper">
     <div class="container-fluid">

         <div class="d-flex align-items-center mt-2 mb-2">
             <h6 class="mb-0 flex-grow-1">Web Requests</h6>
             <div class="flex-shrink-0">
                 <nav aria-label="breadcrumb">
                     <ol class="breadcrumb justify-content-end mb-0">
                         <li class="breadcrumb-item"><a href="javascript:void(0)">Pages</a></li>
                         <li class="breadcrumb-item active" aria-current="page">Blank</li>
                     </ol>
                 </nav>
             </div>
         </div>
         <div class="row">
             <div class="card">
                 <div class="card-body">
                     <form method="POST" action="<?= route('web-request') ?>">
                        @csrf
                         <div class="row">
                             <div class="col-md-4">
                                 <label>Users</label>
                                 <select  class="form-control select2" id="users" name="user" >
                                     <option value="">--select--</option>
                                     <?php
                                        if (isset($usersData)) {
                                            foreach ($usersData as $val) { ?>
                                             <option <?php echo (isset($user) && $user == $val->id) ? 'selected' : '' ?> value="<?php echo $val->id ?>"><?php echo ucwords($val->name) ?></option>
                                     <?php }
                                        }
                                        ?>
                                 </select>
                             </div>
                             <div class="col-md-4">
                                 <label>Service Type</label>
                                 <select  class="form-control select2" id="service" name="service" >
                                     <option value="">--select--</option>
                                     <?php
                                        if (isset($serviceData)) {
                                            foreach ($serviceData as $val) { ?>
                                             <option <?php echo (isset($service) && $service == $val->id) ? 'selected' : '' ?> value="<?php echo $val->id ?>"><?php echo ucwords($val->service_type) ?></option>
                                     <?php }
                                        }
                                        ?>
                                 </select>
                             </div>
                              <div class="col-md-4">
                                 <label>Status </label>
                                 <select  class="form-control select2" id="type" name="type" >
                                     <option value="">--select--</option>
                                     <option <?php echo (isset($type) && $type == 1) ? 'selected' : '' ?> value="1">Accepted</option>
                                     <option <?php echo (isset($type) && $type == 2) ? 'selected' : '' ?> value="2">Declined</option>                                    
                                 </select>
                             </div>
                         </div>
                         <div class="d-flex mt-2">
                                <input type="submit" name="submit" value="Search" class="btn btn-primary" />
                         </div>
                         

                     </form>
                 </div>
             </div>

             <table id="datatables" class="table table-nowrap table-hover table-bordered w-100 mt-5">
                 <thead>
                     <tr>
                         <th>S.No</th>
                         <th>Name</th>
                         <th>Request ID</th>
                         <th>Service</th>
                         <th>Location</th>
                         <th>Language</th>                        
                         <th>Type</th>                        
                     </tr>
                 </thead>
                 <tbody>
                     <?php if (isset($records)) {
                            $i = 1;
                            foreach ($records as $key => $row) {
                        ?>
                             <tr>
                                 <td><?php echo $i ?></td>
                                 <td><?php echo $row->name ?></td>
                                 <td><?php echo $row->request_id ?></td>
                                 <td><?php echo $row->service_type ?></td>
                                 <td><?php echo $row->location ?></td>
                                 <td><?php echo $row->language_names ?></td>
                                 <td><?php echo ($row->type == 1) ? 'Accepted':( ($row->type == 2) ? 'Decline':'' ) ?></td>
                                
                             </tr>

                     <?php $i++;
                            }
                        } ?>

                 </tbody>
             </table>
         </div>
     </div>
 </main>
 @endsection