import 'package:animated_bottom_navigation_bar/animated_bottom_navigation_bar.dart';
import 'package:capscribes/UI/Admin/dashboard/AdminFileScreen.dart';
import 'package:capscribes/UI/Hospital/dashboard/HospitalFileScreen.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';

import 'dashboard/AdminAllDoctorListsScreen.dart';
import 'dashboard/AdminHomeScreen.dart';
import 'dashboard/AdminNotificationScreen.dart';
import 'dashboard/AdminProfileScreen.dart';

class AdminDashboardScreen extends StatefulWidget {
  const AdminDashboardScreen({super.key});

  @override
  State<AdminDashboardScreen> createState() => _AdminDashboardScreenState();
}

class _AdminDashboardScreenState extends State<AdminDashboardScreen> {
  int _currentIndex = 0;

  final List<Widget> _screens = [
    AdminHomeScreen(),
    AdminFileScreen(),
    AdminNotificationScreen(),
    AdminProfileScreen(),
  ];
  final List<String> labels = [
    'Home',
    'Files',
    'Notifications',
    'Profile',
  ];


  final iconList = <IconData>[
    Icons.home,
    Icons.file_copy_rounded,
    Icons.notifications_outlined,
    Icons.person,
  ];

  Future<bool> _onExitRequested() async {
    final shouldExit = await showDialog<bool>(
      context: context,
      builder: (context) => AlertDialog(
        title: Text('Exit App?'),
        content: Text('Do you really want to exit the app?'),
        actions: [
          TextButton(
            onPressed: () => Navigator.of(context).pop(false),
            child: Text('Cancel'),
          ),
          TextButton(
            onPressed: () => Navigator.of(context).pop(true),
            child: Text('Exit'),
          ),
        ],
      ),
    );

    return shouldExit ?? false;
  }

  @override
  Widget build(BuildContext context) {
    SystemChrome.setSystemUIOverlayStyle(
      SystemUiOverlayStyle(
        statusBarColor: Color(0xffC85D06), // Change status bar color here
        statusBarIconBrightness: Brightness.light, // White icons
      ),
    );
    return PopScope(
      canPop: false,
      onPopInvoked: (didPop) async {
        if (didPop) return;
        final shouldExit = await _onExitRequested();
        if (shouldExit && mounted) {
          SystemNavigator.pop();
        }
      },
      child: Scaffold(
        backgroundColor: Color(0xffC85D06),
        body: _screens[_currentIndex],

        floatingActionButton: Container(
          height: 60,
          width: 60,
          child: FloatingActionButton(
            shape: CircleBorder(),
            backgroundColor: Color(0xffFF9C4B),
            elevation: 6,
            child: SvgPicture.asset(
              'assets/doctor.svg',
              width: 28,
              height: 28,
              color: Colors.white, // optional if your SVG supports coloring
            ),
            onPressed: () {

              Navigator.of(context).pushReplacement(MaterialPageRoute(
                  builder: (context) => AdminAllDoctorListsScreen()));
            },
          ),
        ),


        floatingActionButtonLocation: FloatingActionButtonLocation.centerDocked,

        // Animated bottom navigation bar
        bottomNavigationBar: BottomNavigationBar(
          currentIndex: _currentIndex,
          onTap: (index) => setState(() => _currentIndex = index),
          backgroundColor: Color(0xffFF9C4B),
          selectedItemColor: Colors.white,
          unselectedItemColor: Colors.white70,
          type: BottomNavigationBarType.fixed,
          items: [
            BottomNavigationBarItem(
              icon: Icon(Icons.home,size: 15,),
              label: 'Home',
            ),
            BottomNavigationBarItem(
              icon: Icon(Icons.file_copy_rounded,size: 15,),
              label: 'Files',
            ),
            BottomNavigationBarItem(
              icon: Icon(Icons.notifications_outlined,size: 15,),
              label: 'Notifications',
            ),
            BottomNavigationBarItem(
              icon: Icon(Icons.person,size: 15,),
              label: 'Profile',
            ),
          ],
        ),

      ),
    );
  }
}



class ProfileScreen extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return
      Scaffold(
        appBar: AppBar(
          backgroundColor: const Color(0xff289B38),
          title: const Text('Profile', style: TextStyle(color: Colors.white)),
        ),
      backgroundColor: const Color(0xFF3AAFA9),
        body: Stack(

          children: [
            Container(
              height: 60,
              decoration: BoxDecoration(
                color: Color(0xff289B38), // Example background color
                borderRadius: BorderRadius.only(
                  bottomLeft: Radius.circular(20.0),
                  bottomRight: Radius.circular(20.0),
                ),
              ), // Example background color
            ),
            SingleChildScrollView(
              child: Center(
                child: Padding(
                  padding: const EdgeInsets.only(left: 5.0, right: 10.0, top: 0.0, bottom: 0.0),
                  child: Padding(
                    padding: const EdgeInsets.all(10.0),

                  ),
                ),
              ),
            ),
          ],
        ),
    );
  }

  Widget buildStatusRow() {
    return Padding(
      padding: const EdgeInsets.symmetric(horizontal: 30.0, vertical: 10),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Column(
            children: const [
              Icon(Icons.volume_up, color: Color(0xFF2D6DA7), size: 30),
              SizedBox(height: 6),
              Text(
                "100",
                style: TextStyle(
                  fontSize: 18,
                  fontWeight: FontWeight.bold,
                  color: Colors.red,
                ),
              ),
              Text(
                "Pending",
                style: TextStyle(fontSize: 12, color: Colors.black),
              ),
            ],
          ),
          Column(
            children: const [
              Icon(Icons.download, color: Color(0xFF2D6DA7), size: 30),
              SizedBox(height: 6),
              Text(
                "400",
                style: TextStyle(
                  fontSize: 18,
                  fontWeight: FontWeight.bold,
                  color: Colors.green,
                ),
              ),
              Text(
                "Received",
                style: TextStyle(fontSize: 12, color: Colors.black),
              ),
            ],
          ),
        ],
      ),
    );
  }


}

// 🔷 Custom clipper for rounded top + diagonal bottom-right cut

