import 'package:capscribes/UI/Doctor/dashboard/DoctorFileScreen.dart';
import 'package:capscribes/UI/Doctor/dashboard/DoctorHomeScreen.dart';
import 'package:capscribes/UI/Doctor/dashboard/DoctorNotificationScreen.dart';
import 'package:capscribes/UI/Doctor/dashboard/DoctorProfileScreen.dart';
import 'package:capscribes/UI/Doctor/dashboard/SoundDemo.dart';
import 'package:capscribes/UI/Doctor/dashboard/VoiceRecorderPage.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';

class DoctorDashboardScreen extends StatefulWidget {
  const DoctorDashboardScreen({super.key});

  @override
  State<DoctorDashboardScreen> createState() => _DoctorDashboardScreenState();
}

class _DoctorDashboardScreenState extends State<DoctorDashboardScreen> {
  int _currentIndex = 0;

  final List<Widget> _screens = [
    DoctorHomeScreen(),
    DoctorFileScreen(),
    DoctorNotificationScreen(),
    DoctorProfileScreen(),
  ];
  final List<String> labels = [
    'Home',
    'Files',
    'Notifications',
    'Profile',
  ];


  final iconList = <IconData>[
    Icons.home,
    Icons.file_copy_rounded,
    Icons.notifications_outlined,
    Icons.person,
  ];

  Future<bool> _onExitRequested() async {
    final shouldExit = await showDialog<bool>(
      context: context,
      builder: (context) => AlertDialog(
        title: Text('Exit App?'),
        content: Text('Do you really want to exit the app?'),
        actions: [
          TextButton(
            onPressed: () => Navigator.of(context).pop(false),
            child: Text('Cancel'),
          ),
          TextButton(
            onPressed: () => Navigator.of(context).pop(true),
            child: Text('Exit'),
          ),
        ],
      ),
    );

    return shouldExit ?? false;
  }
  @override
  Widget build(BuildContext context) {
    Future.delayed(Duration.zero, () {
      FocusScope.of(context).unfocus(); // Hide keyboard if it's open
    });
    SystemChrome.setSystemUIOverlayStyle(
      SystemUiOverlayStyle(
        statusBarColor: Color(0xff1F5C93), // Change status bar color here
        statusBarIconBrightness: Brightness.light, // White icons
      ),
    );
    return PopScope(
      canPop: false,
      onPopInvoked: (didPop) async {
        if (didPop) return;
        final shouldExit = await _onExitRequested();
        if (shouldExit && mounted) {
          SystemNavigator.pop();
        }
      },
      child: Scaffold(
        backgroundColor: Color(0xff539DE0),
        body: _screens[_currentIndex],

        floatingActionButton: Container(
          height: 60,
          width: 60,
          child: FloatingActionButton(
            shape: CircleBorder(),
            backgroundColor: Color(0xff539DE0),
            elevation: 6,
            child:   Icon(Icons.add,color: Colors.white,size: 40,),
            onPressed: () {

              Navigator.pushReplacement(
                context,
                MaterialPageRoute(builder: (_) => SoundDemo()),
              );

            },
          ),
        ),


        floatingActionButtonLocation: FloatingActionButtonLocation.centerDocked,

        // Animated bottom navigation bar
        bottomNavigationBar: BottomNavigationBar(
          currentIndex: _currentIndex,
          onTap: (index) => setState(() => _currentIndex = index),
          backgroundColor: Color(0xff539DE0),
          selectedItemColor: Colors.white,
          unselectedItemColor: Colors.white70,
          type: BottomNavigationBarType.fixed,
          items: [
            BottomNavigationBarItem(
              icon: Icon(Icons.home,size: 15,),
              label: 'Home',
            ),
            BottomNavigationBarItem(
              icon: Icon(Icons.file_copy_rounded,size: 15,),
              label: 'Files',
            ),
            BottomNavigationBarItem(
              icon: Icon(Icons.notifications_outlined,size: 15,),
              label: 'Notifications',
            ),
            BottomNavigationBarItem(
              icon: Icon(Icons.person,size: 15,),
              label: 'Profile',
            ),
          ],
        ),

      ),
    );
  }
}
