import 'package:capscribes/UI/Admin/AdminIntroScreen.dart';
import 'package:capscribes/UI/Hospital/HospitalIntroScreen.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:sliding_action_button/sliding_action_button.dart';

class HospitalLoginScreen extends StatefulWidget {
  const HospitalLoginScreen({super.key});

  @override
  State<HospitalLoginScreen> createState() => _HospitalLoginScreenState();
}

class _HospitalLoginScreenState extends State<HospitalLoginScreen> {
  bool _obscurePassword = true;

  final TextEditingController emailController = TextEditingController();
  final TextEditingController passwordController = TextEditingController();
  final GlobalKey<FormState> _formKey = GlobalKey<FormState>();
  ///This is the controller used to control the square sliding action state (Loading, resetting etc)
  final SlideToActionController _squareSlidToActionController =
  SlideToActionController();

  @override
  void initState() {
    super.initState();

  }


  @override
  Widget build(BuildContext context) {
    // Set the status bar color to orange
    SystemChrome.setSystemUIOverlayStyle(
      SystemUiOverlayStyle(
        statusBarColor:  Color(0xff39C5B4), // Change status bar color here
        statusBarIconBrightness: Brightness.light, // White icons
      ),
    );
    return Scaffold(
      backgroundColor: Colors.white,
      resizeToAvoidBottomInset: true, // Important: allows screen resize on keyboard open
      body: SafeArea(
        child: SingleChildScrollView(
          child: Container(
            height: MediaQuery.of(context).size.height, // Full height
            width: double.infinity,
            child: Stack(
              children: [
                // Background SVG
                Positioned.fill(
                  child: SvgPicture.asset(
                    'assets/hospitalloginback.svg',
                    fit: BoxFit.cover,
                  ),
                ),

                // Foreground form content
                Align(
                  alignment: Alignment.bottomCenter,
                  child: Padding(
                    padding: const EdgeInsets.all(24.0),
                    child: Form(
                      key: _formKey,
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          const SizedBox(height: 40),
                          const Text(
                            "Login in to your account",
                            style: TextStyle(color: Colors.black, fontSize: 16),
                          ),

                          const SizedBox(height: 20),

                          // Email
                          TextFormField(
                            controller: emailController,
                            decoration: const InputDecoration(
                              labelText: 'Email',
                              hintText: "exmaple@mail.com",
                              hintStyle: TextStyle(color: Colors.grey),
                              labelStyle: TextStyle(
                                color: Colors.grey, // 👈 Change to your desired color
                                fontSize: 16,
                              ),

                              prefixIcon: Icon(Icons.email),
                              border: OutlineInputBorder(),
                            ),
                            keyboardType: TextInputType.emailAddress,
                            validator: (value) =>
                            value == null || value.isEmpty ? 'Enter email' : null,
                          ),
                          const SizedBox(height: 15),

                          // Password
                          TextFormField(
                            controller: passwordController,
                            obscureText: _obscurePassword,
                            decoration: InputDecoration(
                              labelText: 'Password',
                              labelStyle: TextStyle(
                                color: Colors.grey, // 👈 Change to your desired color
                                fontSize: 16,
                              ),
                              hintText: "*******",
                              hintStyle: TextStyle(color: Colors.grey),
                              prefixIcon: Icon(Icons.lock),
                              border: OutlineInputBorder(),

                              // 👁 Eye icon to toggle visibility
                              suffixIcon: IconButton(
                                icon: Icon(
                                  _obscurePassword ? Icons.visibility_off : Icons.visibility,
                                ),
                                onPressed: () {
                                  setState(() {
                                    _obscurePassword = !_obscurePassword;
                                  });
                                },
                              ),
                            ),
                            validator: (value) =>
                            value == null || value.isEmpty ? 'Enter password' : null,
                          ),

                          const SizedBox(height: 20),

                          // Slide to login
                          SquareSlideToActionButton(
                            slideToActionController: _squareSlidToActionController,
                            width: 350,
                            parentBoxRadiusValue: 15,
                            squareSlidingButtonSize: 40,
                            leftEdgeSpacing: 3,
                            initialSlidingActionLabel: 'Login',
                            initialSlidingActionLabelTextStyle: const TextStyle(
                              color: Colors.white,
                              fontSize: 16,
                              fontWeight: FontWeight.w600,
                            ),
                            finalSlidingActionLabel: 'Login',
                            squareSlidingButtonIcon:
                            const Icon(
                              Icons.double_arrow,
                              color:  Color(0xff0B665B),
                            ),
                            parentBoxBackgroundColor: Color(0xff0B665B),
                            parentBoxDisableBackgroundColor: Colors.grey,
                            squareSlidingButtonBackgroundColor: Colors.white,
                            isEnable: true,
                            slideActionButtonType:
                            SlideActionButtonType.slideActionWithLoaderButton,
                            onSlideActionCompleted: () async {
                              _squareSlidToActionController.loading();
                              await Future.delayed(const Duration(seconds: 3), () {
                                _squareSlidToActionController.reset(3);
                                Navigator.of(context).pushReplacement(MaterialPageRoute(
                                    builder: (context) => HospitalIntroScreen()));
                              });
                              print("Sliding action completed");
                            },
                            onSlideActionCanceled: () {
                              print("Sliding action cancelled");
                            },
                          ),
                          const SizedBox(height: 10),
                        ],
                      ),
                    ),
                  ),
                ),
              ],
            ),
          ),
        ),
      ),
    );

  }
}