import 'dart:convert';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:http/http.dart' as http;
import 'package:shared_preferences/shared_preferences.dart';

import '../../../Networking/ApiService.dart';
import '../../../Networking/DialogHelper.dart';
import '../../../Networking/getAuthHeaders.dart';
import '../../Admin/AdminDashboardScreen.dart';
import '../../Doctor/DoctorDashboardScreen.dart';
import '../../Transcrpit/TranscrpitDashboardScreen.dart';
import '../HospitalDashboardScreen.dart';

class Adddoctorpage extends StatefulWidget {

  const Adddoctorpage({super.key});

  @override
  State<Adddoctorpage> createState() => _AdddoctorpageState();
}

class _AdddoctorpageState extends State<Adddoctorpage> {
  final ApiService apiService = ApiService();
  late SharedPreferences sharedPreferences;
  String Firstname="",USERID="",ROLEID="",Pendingfile="",Recivedfile="";
  final _formKey = GlobalKey<FormState>();
  final TextEditingController _nameController = TextEditingController();
  final TextEditingController _mobileController = TextEditingController();
  final TextEditingController _emailController = TextEditingController();
  final TextEditingController _expController = TextEditingController();
  final TextEditingController _passwordController = TextEditingController();
  final TextEditingController _confirmPasswordController = TextEditingController();

  bool _obscurePassword = true;
  bool _obscureConfirmPassword = true;

  final FocusNode _nameFocus = FocusNode();
  final FocusNode _mobileFocus = FocusNode();
  final FocusNode _emailFocus = FocusNode();
  final FocusNode _expFocus = FocusNode();
  final FocusNode _passwordFocus = FocusNode();
  final FocusNode _confirmPasswordFocus = FocusNode();
  @override
  void initState() {
    super.initState();

    initialeclass();
  }

  initialeclass() async {
    sharedPreferences = await SharedPreferences.getInstance();
    setState(() {
      ROLEID = sharedPreferences.getString("userRole") ?? '';
      Firstname = sharedPreferences.getString("username") ?? '';
      USERID = sharedPreferences.getString("user_id") ?? '';
    });


    // ROLENAME = sharedPreferences.getString("role_name") ?? '';
  }
  Future<void> _saveDoctor() async {
    if (_formKey.currentState!.validate()) {
      final headers = await getAuthHeaders();
      DialogHelper.showLoading(context);
      try {
        final response = await http.post(
          Uri.parse("https://app.capscribes.com/api/users"),
          headers: headers,
          body: jsonEncode({
            "name": _nameController.text.trim(),
            "email": _emailController.text.trim(),
            "mobile": _mobileController.text.trim(),
            "password": _passwordController.text.trim(),
            "password_confirmation": _confirmPasswordController.text.trim(),
            "roleId": "4",        // fixed values
            "hospitalId": USERID,
            "experience": _expController.text.trim(),
          }),
        );
        final responseData = json.decode(response.body);

        if (response.statusCode == 200 || response.statusCode == 201) {
          DialogHelper.dismissDialog();
          ScaffoldMessenger.of(context).showSnackBar(
            const SnackBar(content: Text("Doctor added successfully!")),
          );

          // ✅ Unfocus all fields to hide keyboard
          FocusScope.of(context).unfocus();
          // ✅ Clear fields after success
          _nameController.clear();
          _mobileController.clear();
          _emailController.clear();
          _expController.clear();
          _passwordController.clear();
          _confirmPasswordController.clear();

          // ✅ Unfocus all fields after a short delay to ensure UI updates
          Future.delayed(Duration(milliseconds: 100), () {
            _nameFocus.unfocus();
            _mobileFocus.unfocus();
            _emailFocus.unfocus();
            _expFocus.unfocus();
            _passwordFocus.unfocus();
            _confirmPasswordFocus.unfocus();
          });


          // ✅ Optionally refresh page or go back
          // Navigator.pop(context, true);  // if you want to go back with success
        } else {
          DialogHelper.dismissDialog();

          String errorMessage = responseData['message'] ?? response.body;
          ScaffoldMessenger.of(context).showSnackBar(
            SnackBar(content: Text("$errorMessage")),
          );
        }
      } catch (e) {
        DialogHelper.dismissDialog();
        ScaffoldMessenger.of(context).showSnackBar(
          SnackBar(content: Text("Error: $e")),
        );
      } finally {
        DialogHelper.dismissDialog();
      }




    }
  }


  Color getBackgroundColor(String roleId) {
    switch (roleId) {
      case "2": // Admin
        return Color(0xffC85D06);

      case "3": // Admin
        return Color(0xffb3b300);
      case "4": // Doctor
        return Color(0xff1F5C93); // Greenish
      case "5": // Hospital
        return Color(0xff004D40); // Purple
      default:
        return Colors.grey; // Default or unknown
    }
  }


  @override
  Widget build(BuildContext context) {


    return  WillPopScope(
      onWillPop: () async {



        switch (ROLEID) {
          case "2":
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => AdminDashboardScreen()),
            );
            break;
          case "3":
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => TranscrpitDashboardScreen()),
            );
            break;
          case "4":
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => DoctorDashboardScreen()),
            );
            break;
          case "5":
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => HospitalDashboardScreen()),
            );
            break;
          default:
          // Handle unknown ROLEID or do nothing
            break;
        }

        return false; // Prevent default pop
      },
      child: Scaffold(

        appBar: AppBar(title: Text('Add Doctor',style: TextStyle(color: Colors.white),

        ),
          backgroundColor: getBackgroundColor(ROLEID),
          iconTheme: IconThemeData(color: Colors.white),),
        body: SingleChildScrollView(
          padding: EdgeInsets.all(16),
          child:  Form(       // ✅ wrap with Form
            key: _formKey,  // ✅ connect form key here
            child: Column(
                    children: [
            SizedBox(height: 30),
                    // Name
                    TextFormField(
                    controller: _nameController,
                      focusNode: _nameFocus,
            decoration: const InputDecoration(
              labelText: "Name",
              prefixIcon: Icon(Icons.person),
              border: OutlineInputBorder(),
            ),
            validator: (value) =>
            value!.isEmpty ? "Please enter name" : null,
                    ),
                    const SizedBox(height: 30),

                    // Mobile
                    TextFormField(
            controller: _mobileController,
                      focusNode: _mobileFocus,
            keyboardType: TextInputType.phone,
                      inputFormatters: [
                        FilteringTextInputFormatter.digitsOnly,             // Allow only digits
                        LengthLimitingTextInputFormatter(10),               // Limit to 10 digits
                      ],
            decoration: const InputDecoration(
              labelText: "Mobile Number",
              prefixIcon: Icon(Icons.phone),
              border: OutlineInputBorder(),

            ),
            validator: (value) {
              if (value!.isEmpty) return "Enter mobile number";
              if (value.length != 10) return "Enter valid 10-digit number";
              return null;
            },
                    ),
                    const SizedBox(height: 30),

                    // Email
                    TextFormField(
            controller: _emailController,
                      focusNode: _emailFocus,
            keyboardType: TextInputType.emailAddress,
            decoration: const InputDecoration(
              labelText: "Email",
              prefixIcon: Icon(Icons.email),
              border: OutlineInputBorder(),
            ),
            validator: (value) {
              if (value!.isEmpty) return "Enter email";
              if (!RegExp(r'^[^@]+@[^@]+\.[^@]+').hasMatch(value)) {
                return "Enter valid email";
              }
              return null;
            },
                    ),
                    const SizedBox(height: 30),

                    // Experience
                    TextFormField(
            controller: _expController,
                      focusNode: _expFocus,
            keyboardType: TextInputType.number,
            decoration: const InputDecoration(
              labelText: "Experience (Years)",
              prefixIcon: Icon(Icons.work),
              border: OutlineInputBorder(),
            ),
            validator: (value) =>
            value!.isEmpty ? "Enter experience" : null,
                    ),
                    const SizedBox(height: 30),

                    // Password
                    TextFormField(
            controller: _passwordController,
            obscureText: _obscurePassword,
                      focusNode: _passwordFocus ,
            decoration: InputDecoration(
              labelText: "Password",
              prefixIcon: const Icon(Icons.lock),
              border: const OutlineInputBorder(),
              suffixIcon: IconButton(
                icon: Icon(
                    _obscurePassword ? Icons.visibility_off : Icons.visibility),
                onPressed: () {
                  setState(() {
                    _obscurePassword = !_obscurePassword;
                  });
                },
              ),
            ),
            validator: (value) {
              if (value!.isEmpty) return "Enter password";
              if (value.length < 6) return "Password must be at least 6 characters";
              return null;
            },
                    ),
                    const SizedBox(height: 30),

                    // Confirm Password
                    TextFormField(
            controller: _confirmPasswordController,
            obscureText: _obscureConfirmPassword,
                      focusNode: _confirmPasswordFocus  ,
            decoration: InputDecoration(
              labelText: "Confirm Password",
              prefixIcon: const Icon(Icons.lock_outline),
              border: const OutlineInputBorder(),
              suffixIcon: IconButton(
                icon: Icon(
                    _obscureConfirmPassword ? Icons.visibility_off : Icons.visibility),
                onPressed: () {
                  setState(() {
                    _obscureConfirmPassword = !_obscureConfirmPassword;
                  });
                },
              ),
            ),
            validator: (value) {
              if (value!.isEmpty) return "Re-enter password";
              if (value != _passwordController.text) {
                return "Passwords do not match";
              }
              return null;
            },
                    ),
                    const SizedBox(height: 30),

                    // Save Button
                    SizedBox(
            width: double.infinity,
            child: ElevatedButton(
              onPressed: _saveDoctor,
              style: ElevatedButton.styleFrom(
                backgroundColor:  Color(0xff004D40),
                padding: const EdgeInsets.symmetric(vertical: 14),
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(8),
                ),
              ),
              child: const Text(
                "Save",
                style: TextStyle(fontSize: 18, fontWeight: FontWeight.bold,color: Colors.white),
              ),
            ),
                    )
                    ],
                  ),
          ),
    ),
    ),
    );
  }
}
