import 'dart:convert';
import 'dart:io';

import 'package:capscribes/UI/Admin/AdminDashboardScreen.dart';
import 'package:capscribes/UI/Admin/AdminIntroScreen.dart';
import 'package:capscribes/UI/Doctor/DoctorDashboardScreen.dart';
import 'package:capscribes/UI/Hospital/HospitalDashboardScreen.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:http/http.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:sliding_action_button/sliding_action_button.dart';

import '../Networking/ApiService.dart';
import '../Networking/DialogHelper.dart';
import 'Doctor/DoctorIntroScreen.dart';
import 'Hospital/HospitalIntroScreen.dart';
import 'Transcrpit/TranscrpitDashboardScreen.dart';
import 'Transcrpit/TranscrpitIntroScreen.dart';

class LoginScreen extends StatefulWidget {
  const LoginScreen({super.key});

  @override
  State<LoginScreen> createState() => _LoginScreenState();
}

class _LoginScreenState extends State<LoginScreen> {
  bool _obscurePassword = true;
  final ApiService apiService = ApiService();
  late SharedPreferences sharedPreferences;
  bool isFiresttimeIn= false;
  final TextEditingController emailController = TextEditingController();
  final TextEditingController passwordController = TextEditingController();
  final GlobalKey<FormState> _formKey = GlobalKey<FormState>();
  ///This is the controller used to control the square sliding action state (Loading, resetting etc)
  final SlideToActionController _squareSlidToActionController =
  SlideToActionController();
  String? _fcmToken;
  @override
  void initState() {
    super.initState();
    initialeclass();
  }
  initialeclass() async {
    sharedPreferences = await SharedPreferences.getInstance();
  }


  @override
  void dispose() {
    _squareSlidToActionController?.dispose(); // Important: dispose controller
    super.dispose();
  }


  @override
  Widget build(BuildContext context) {
    // Set the status bar color to orange
    SystemChrome.setSystemUIOverlayStyle(
      SystemUiOverlayStyle(
        statusBarColor:  Color(0xffFF0000), // Change status bar color here
        statusBarIconBrightness: Brightness.light, // White icons
      ),
    );
    return PopScope(
      canPop: false,
      onPopInvoked: (didPop) async {
        if (didPop) return;

        final shouldExit = await showDialog<bool>(
          context: context,
          builder: (context) => AlertDialog(
            title: const Text('Exit App'),
            content: const Text('Do you want to exit the app?'),
            actions: [
              TextButton(
                onPressed: () => Navigator.of(context).pop(false),
                child: const Text('Cancel'),
              ),
              TextButton(
                onPressed: () {
                  // Pop the dialog
                  Navigator.of(context).pop(true);
                  SystemNavigator.pop();

                  // Exit the application
                  // Ensure to import 'package:flutter/services.dart';
                },
                child: const Text('Exit'),
              ),
            ],
          ),
        );

        if (shouldExit == true) {
          // Exit the app
          Navigator.of(context).maybePop();
        }
      },
      child: Scaffold(
        backgroundColor: Colors.white,
        resizeToAvoidBottomInset: true, // Important: allows screen resize on keyboard open
        body: SafeArea(
          child: SingleChildScrollView(
            child: Container(
              height: MediaQuery.of(context).size.height, // Full height
              width: double.infinity,
              child: Stack(
                children: [
                  // Background SVG

                  // Foreground form content
                  Align(
                    alignment: Alignment.topCenter,
                    child: Padding(
                      padding: const EdgeInsets.only(top: 100.0,bottom: 24.0,left: 24.0,right: 24.0),
                      child: Form(
                        key: _formKey,
                        child: Column(
                          mainAxisSize: MainAxisSize.min,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            SvgPicture.asset(
                              'assets/loginlogo.svg',
                              fit: BoxFit.fitWidth,
                            ),
                            const SizedBox(height: 40),
                            const Text(
                              "Login in to your account",
                              style: TextStyle(color: Colors.black, fontSize: 16),
                            ),

                            const SizedBox(height: 20),

                            // Email
                            TextFormField(
                              controller: emailController,
                              decoration: const InputDecoration(
                                labelText: 'Email',
                                hintText: "exmaple@mail.com",
                                hintStyle: TextStyle(color: Colors.grey),
                                labelStyle: TextStyle(
                                  color: Colors.grey, // 👈 Change to your desired color
                                  fontSize: 16,
                                ),

                                prefixIcon: Icon(Icons.email),
                                border: OutlineInputBorder(),
                              ),
                              keyboardType: TextInputType.emailAddress,
                              validator: (value) =>
                              value == null || value.isEmpty ? 'Enter email' : null,
                            ),
                            const SizedBox(height: 15),

                            // Password
                            TextFormField(
                              controller: passwordController,
                              obscureText: _obscurePassword,
                              decoration: InputDecoration(
                                labelText: 'Password',
                                labelStyle: TextStyle(
                                  color: Colors.grey, // 👈 Change to your desired color
                                  fontSize: 16,
                                ),
                                hintText: "*******",
                                hintStyle: TextStyle(color: Colors.grey),
                                prefixIcon: Icon(Icons.lock),
                                border: OutlineInputBorder(),

                                // 👁 Eye icon to toggle visibility
                                suffixIcon: IconButton(
                                  icon: Icon(
                                    _obscurePassword ? Icons.visibility_off : Icons.visibility,
                                  ),
                                  onPressed: () {
                                    setState(() {
                                      _obscurePassword = !_obscurePassword;
                                    });
                                  },
                                ),
                              ),
                              validator: (value) =>
                              value == null || value.isEmpty ? 'Enter password' : null,
                            ),

                            const SizedBox(height: 20),

                            // Slide to login
                            SquareSlideToActionButton(
                              slideToActionController: _squareSlidToActionController,
                              width: 350,
                              parentBoxRadiusValue: 15,
                              squareSlidingButtonSize: 40,
                              leftEdgeSpacing: 3,
                              initialSlidingActionLabel: 'Login',
                              initialSlidingActionLabelTextStyle: const TextStyle(
                                color: Colors.white,
                                fontSize: 16,
                                fontWeight: FontWeight.w600,
                              ),
                              finalSlidingActionLabel: 'Login',
                              squareSlidingButtonIcon: const Icon(
                                Icons.double_arrow,
                                color: Color(0xffFF0000),
                              ),
                              parentBoxBackgroundColor: Color(0xffFF0000),
                              parentBoxDisableBackgroundColor: Colors.grey,
                              squareSlidingButtonBackgroundColor: Colors.white,
                              isEnable: true,
                              slideActionButtonType: SlideActionButtonType.slideActionWithLoaderButton,
                              onSlideActionCompleted: () async {
                                if (_formKey.currentState!.validate()) {
                                  if (mounted) _squareSlidToActionController.loading(); // Start loader

                                  try {
                                    await apicall(); // Perform API call
                                  } catch (e) {
                                    if (mounted) _squareSlidToActionController.reset(1); // Reset button if error
                                  }
                                } else {
                                  if (mounted) _squareSlidToActionController.reset(1); // Reset if form is invalid
                                }
                              },
                              onSlideActionCanceled: () {
                                print("Sliding action cancelled");
                              },
                            ),

                            const SizedBox(height: 10),
                          ],
                        ),
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ),
        ),
      ),
    );

  }
  apicall() async {
    if (_formKey.currentState!.validate()) {
      final String email = emailController.text.trim();
      final String password = passwordController.text;

      DialogHelper.showLoading(context);

      try {
        Response response = await post(
          Uri.parse(apiService.BaseURL + apiService.Loginapi),
          body: {
            'email': email,
            'password': password,
            'token':_fcmToken
          },
        );

        print("loginresponse: ${response.statusCode}");

        if (response.statusCode == 200) {
          if (!mounted) return;


          final Map<String, dynamic> data = jsonDecode(response.body);
          print('Login successful: $data');

          setState(() {
            isFiresttimeIn = sharedPreferences.getBool('firsttime') ?? false;
            sharedPreferences.setBool('isLoggedIn', true);
            sharedPreferences.setBool('firsttime', isFiresttimeIn);
            sharedPreferences.setString('user_id', data['userId'].toString());
            sharedPreferences.setString('username', data['name'].toString());
            sharedPreferences.setString('email', data['email'].toString());
            sharedPreferences.setString('userRole', data['auth'].toString());
            sharedPreferences.setString('auth_token', data['token'].toString());


            DialogHelper.dismissDialog();

            Fluttertoast.showToast(
              msg: "Login Successfully",
              toastLength: Toast.LENGTH_SHORT,
              gravity: ToastGravity.BOTTOM,
              timeInSecForIosWeb: 1,
              backgroundColor: Colors.black,
              textColor: Colors.white,
              fontSize: 16.0,
            );

            print(isFiresttimeIn);
            print(data['auth'].toString());



          });
          switch (isFiresttimeIn) {
            case true:
            // First-time logic based on role
              switch (data['auth'].toString()) {

                case '2':
                  Navigator.of(context).pushReplacement(
                    MaterialPageRoute(
                      builder: (context) => AdminIntroScreen(),
                    ),
                  );

                  break;
                case '3':
                  Navigator.of(context).pushReplacement(
                    MaterialPageRoute(
                      builder: (context) => TranscrpitIntroScreen(),
                    ),
                  );

                  break;
                case '4':
                  Navigator.of(context).pushReplacement(
                    MaterialPageRoute(
                      builder: (context) => DoctorIntroScreen(),
                    ),
                  );
                  break;
                case '5':
                  Navigator.of(context).pushReplacement(
                    MaterialPageRoute(
                      builder: (context) => HospitalIntroScreen(),
                    ),
                  );
                  break;
                default:
                  Navigator.of(context).pushReplacement(
                    MaterialPageRoute(
                      builder: (context) => LoginScreen(),
                    ),
                  );
              }
              break;

            case false:
            // Non-first-time logic based on role
              switch (data['auth'].toString()) {
                case '2':
                  Navigator.of(context).pushReplacement(
                    MaterialPageRoute(
                      builder: (context) => AdminIntroScreen(),
                    ),
                  );

                  break;
                case '3':
                  Navigator.of(context).pushReplacement(
                    MaterialPageRoute(
                      builder: (context) => TranscrpitIntroScreen(),
                    ),
                  );

                  break;
                case '4':
                  Navigator.of(context).pushReplacement(
                    MaterialPageRoute(
                      builder: (context) => DoctorIntroScreen(),
                    ),
                  );
                  break;
                case '5':
                  Navigator.of(context).pushReplacement(
                    MaterialPageRoute(
                      builder: (context) => HospitalIntroScreen(),
                    ),
                  );
                  break;
                default:
                  Navigator.of(context).pushReplacement(
                    MaterialPageRoute(
                      builder: (context) => LoginScreen(),
                    ),
                  );
              }
              break;
          }


        } else {
          await Future.delayed(const Duration(seconds: 1), () {
            _squareSlidToActionController.reset(1);
          });
          DialogHelper.dismissDialog();
          final Map<String, dynamic> errorData = jsonDecode(response.body);
          String message = "An unexpected error occurred";

          if (errorData.containsKey('message')) {
            message = errorData['message'].toString();
          }

          Fluttertoast.showToast(
            msg: message,
            toastLength: Toast.LENGTH_SHORT,
            gravity: ToastGravity.BOTTOM,
            timeInSecForIosWeb: 1,
            backgroundColor: Colors.black,
            textColor: Colors.white,
            fontSize: 16.0,
          );
        }
      } on SocketException {
        DialogHelper.dismissDialog();
        Fluttertoast.showToast(
          msg: "Network error! Please retry.",
          toastLength: Toast.LENGTH_SHORT,
          gravity: ToastGravity.BOTTOM,
          backgroundColor: Colors.red,
          textColor: Colors.white,
        );
      } catch (e) {
        DialogHelper.dismissDialog();
        print("Exception: $e");
      }
    }
  }


  void navigateBasedOnRole(BuildContext context, String role, bool isFirstTime) {
    if (isFirstTime) {
      switch (role) {
        case '2':
          Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => AdminIntroScreen()));
          break;
        case '3':
          Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => TranscrpitIntroScreen()));
          break;
        case '4':
          Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => DoctorIntroScreen()));
          break;
        case '5':
          Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => HospitalIntroScreen()));
          break;
        default:
          Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => LoginScreen()));
      }
    } else {
      switch (role) {
        case '2':
          Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => AdminDashboardScreen()));
          break;
        case '3':
          Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => TranscrpitDashboardScreen()));
          break;
        case '4':
          Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => DoctorDashboardScreen()));
          break;
        case '5':
          Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => HospitalDashboardScreen()));
          break;
        default:
          Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => LoginScreen()));
      }
    }
  }

}