import 'package:capscribes/UI/Doctor/DoctorDashboardScreen.dart';
import 'package:capscribes/UI/Hospital/HospitalDashboardScreen.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../Admin/AdminDashboardScreen.dart';
import '../LoginScreen.dart';
import 'TranscrpitDashboardScreen.dart';

class TranscrpitIntroScreen extends StatefulWidget {
  const TranscrpitIntroScreen({super.key});

  @override
  State<TranscrpitIntroScreen> createState() => _TranscrpitIntroScreenState();
}

class _TranscrpitIntroScreenState extends State<TranscrpitIntroScreen> {
  late SharedPreferences sharedPreferences;
  final PageController _controller = PageController();
  int _currentPage = 0;

  final List<String> _imagePaths = [
    "assets/adminintrofs.svg",
    "assets/adminintross.svg",
  ];

  void _nextPage() {
    if (_currentPage < _imagePaths.length - 1) {
      _controller.nextPage(duration: Duration(milliseconds: 300), curve: Curves.easeInOut);
    } else {
      _goToLogin();
    }
  }

  void _skip() {
    _goToLogin();
  }

  Future<void> _goToLogin() async {
    sharedPreferences = await SharedPreferences.getInstance();
    String? role = sharedPreferences.getString('userRole');
    await sharedPreferences.setBool('firsttime', true);
    await sharedPreferences.setBool('isFirstTime', false);

    switch (role) {
      case '2':
        Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => AdminDashboardScreen()));
        break;
      case '3':
        Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => TranscrpitDashboardScreen()));
        break;
      case '4':
        Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => DoctorDashboardScreen()));
        break;
      case '5':
        Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => HospitalDashboardScreen()));
        break;
      default:
        Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => LoginScreen()));
    }



  }

  @override
  Widget build(BuildContext context) {
    SystemChrome.setSystemUIOverlayStyle(
      SystemUiOverlayStyle(
        statusBarColor:  Color(0xffFFFFFF), // Change status bar color here
        statusBarIconBrightness: Brightness.dark, // White icons
      ),
    );
    return PopScope(
      canPop: false,
      onPopInvoked: (didPop) async {
        if (didPop) return;

        final shouldExit = await showDialog<bool>(
          context: context,
          builder: (context) => AlertDialog(
            title: const Text('Exit App'),
            content: const Text('Do you want to exit the app?'),
            actions: [
              TextButton(
                onPressed: () => Navigator.of(context).pop(false),
                child: const Text('Cancel'),
              ),
              TextButton(
                onPressed: () => Navigator.of(context).pop(true),
                child: const Text('Exit'),
              ),
            ],
          ),
        );

        if (shouldExit == true) {
          // Exit the app
          Navigator.of(context).maybePop();
        }
      },
      child: Scaffold(
        body: Stack(
          children: [
            // 🔶 Background PageView (Full-screen Images)
            PageView.builder(
              controller: _controller,
              itemCount: _imagePaths.length,
              onPageChanged: (index) {
                setState(() => _currentPage = index);
              },
              itemBuilder: (context, index) {
                return SvgPicture.asset(
                  _imagePaths[index],
                  width: MediaQuery.of(context).size.width,
                  height: MediaQuery.of(context).size.height,
                  fit: BoxFit.cover,
                );
              },
            ),

            // 🔶 Foreground: Dot indicators & buttons at the bottom
            Align(
              alignment: Alignment.bottomCenter,
              child: Padding(
                padding: const EdgeInsets.only(bottom: 40.0),
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    // Dot Indicator


                    // Bottom Buttons
                    Padding(
                      padding: const EdgeInsets.symmetric(horizontal: 24.0),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          TextButton(
                            onPressed: _skip,
                            child: Text("Skip", style: TextStyle(color: Colors.grey)),
                          ),
                          Row(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: List.generate(
                              _imagePaths.length,
                                  (index) => AnimatedContainer(
                                duration: Duration(milliseconds: 300),
                                margin: EdgeInsets.symmetric(horizontal: 6),
                                width: _currentPage == index ? 12 : 8,
                                height: _currentPage == index ? 12 : 8,
                                decoration: BoxDecoration(
                                  color: _currentPage == index ? Color(0xffb3b300) : Colors.grey[400],
                                  shape: BoxShape.circle,
                                ),
                              ),
                            ),
                          ),

                          TextButton(
                            onPressed: _nextPage,
                            child: Text(
                              _currentPage == _imagePaths.length - 1 ? "Done" : "Next",
                              style: TextStyle(color: Color(0xffb3b300)),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

}