import 'dart:async';

import 'package:capscribes/UI/Admin/AdminDashboardScreen.dart';
import 'package:capscribes/UI/Admin/AdminIntroScreen.dart';
import 'package:capscribes/UI/Doctor/DoctorIntroScreen.dart';
import 'package:capscribes/UI/Doctor/DoctorLoginScreen.dart';
import 'package:capscribes/UI/Hospital/HospitalDashboardScreen.dart';
import 'package:capscribes/UI/Hospital/HospitalIntroScreen.dart';
import 'package:capscribes/UI/Hospital/HospitalLoginScreen.dart';
import 'package:capscribes/UI/SplashScreen.dart';
import 'package:capscribes/UI/Transcrpit/TranscrpitIntroScreen.dart';
import 'package:capscribes/requestNotificationPermission.dart';
import 'package:connectivity_plus/connectivity_plus.dart';

import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:shared_preferences/shared_preferences.dart';

import 'UI/LoginScreen.dart';
import 'UI/Doctor/DoctorDashboardScreen.dart';
import 'UI/Transcrpit/TranscrpitDashboardScreen.dart';


void main() async {
  WidgetsFlutterBinding.ensureInitialized();
  await requestNotificationPermission();

  SharedPreferences prefs = await SharedPreferences.getInstance();
  bool isLoggedIn = prefs.getBool('isLoggedIn') ?? false;
  //bool isFirstTime = prefs.getBool('isFirstTime') ?? true;
  String? role = prefs.getString('userRole');
  bool isFiresttimeIn = prefs.getBool('firsttime') ?? false;

  runApp(MyApp(isLoggedIn: isLoggedIn,  role: role,isFiresttimeIn:isFiresttimeIn));
}
class MyApp extends StatelessWidget {
  final bool isLoggedIn;
  final String? role;
  final bool isFiresttimeIn;

  MyApp({required this.isLoggedIn, required this.role, required this.isFiresttimeIn});

  @override
  Widget build(BuildContext context) {
    Widget screen;

    print(isLoggedIn);
    print(role);
    print(isFiresttimeIn);
    if (!isLoggedIn) {
      screen = LoginScreen();
    } else if (isFiresttimeIn) {
      print("condtion1");

      switch (role) {
        case '2':
          screen = AdminDashboardScreen();
          break;
        case '3':
          screen = TranscrpitDashboardScreen();
          break;
        case '4':
          screen = DoctorDashboardScreen();
          break;
        case '5':
          screen = HospitalDashboardScreen();
          break;
        default:
          screen = LoginScreen();
      }
    } else {
      print("condtion2");
      switch (role) {
        case '2':
          screen = AdminIntroScreen();
          break;
        case '3':
          screen = TranscrpitIntroScreen();
          break;
        case '4':
          screen = DoctorIntroScreen();
          break;
        case '5':
          screen = HospitalIntroScreen();
          break;
        default:
          screen = LoginScreen(); // fallback
      }

    }

    return MaterialApp(
      debugShowCheckedModeBanner: false,
      home: ConnectivityObserver(
        child: screen,
      ),
    );
  }
}


class ConnectivityObserver extends StatefulWidget {
  final Widget child;

  const ConnectivityObserver({Key? key, required this.child}) : super(key: key);

  @override
  _ConnectivityObserverState createState() => _ConnectivityObserverState();
}

class _ConnectivityObserverState extends State<ConnectivityObserver> {
  late StreamSubscription<List<ConnectivityResult>> _subscription;
  final Connectivity _connectivity = Connectivity();

  @override
  void initState() {
    super.initState();
    // Listen to connectivity changes
    _subscription = _connectivity.onConnectivityChanged.listen(_showConnectivitySnackBar);
    _checkInitialConnectivity();
  }

  Future<void> _checkInitialConnectivity() async {
    try {
      final result = await _connectivity.checkConnectivity();
      // Wrap the single result in a list to match the listener's expected type
      _showConnectivitySnackBar(result);
    } catch (e) {
      // Handle exception if needed
      print('Error checking connectivity: $e');
    }
  }

  void _showConnectivitySnackBar(List<ConnectivityResult> results) {
    if (results.isNotEmpty) {
      final result = results.first;
      final hasConnection = result != ConnectivityResult.none;

      if (!hasConnection) {
        ScaffoldMessenger.of(context).showSnackBar(
          SnackBar(
            content: Text('No internet connection'),
            backgroundColor: Colors.red,
            duration: Duration(days: 1),  // Snackbar will be visible until an internet connection is re-established
          ),
        );
      } else {
        ScaffoldMessenger.of(context).hideCurrentSnackBar();
      }
    }
  }

  @override
  void dispose() {
    _subscription.cancel();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return widget.child;
  }
}



// home: isFirstTime
// ? DoctorIntroScreen()
//     : isLoggedIn
// ? DoctorDashboardScreen()
//     : DoctorLoginScreen(),

// home: isFirstTime
// ? HospitalIntroScreen()
//     : isLoggedIn
// ? HospitalDashboardScreen()
//     : HospitalLoginScreen(),


