import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class DialogHelper {
  static BuildContext? _dialogContext;

  static void showLoading(BuildContext context) {
    showDialog(
      context: context,
      barrierDismissible: false,
      builder: (BuildContext dialogContext) {
        _dialogContext = dialogContext;
        return WillPopScope(
          onWillPop: () async => false, // Prevent back dismiss
          child: AlertDialog(
            content: Row(
              children: const [
                CircularProgressIndicator(),
                SizedBox(width: 20),
                Expanded(child: Text("Loading... Please wait")),
              ],
            ),
          ),
        );
      },
    );
  }

  static void dismissDialog() {
    if (_dialogContext != null) {
      try {
        Navigator.pop(_dialogContext!);
      } catch (e) {
        print("Dialog dismissal error: $e");
      } finally {
        _dialogContext = null; // Clear the context to avoid reuse
      }
    }
  }
}

