import 'package:capscribes/UI/Admin/dashboard/AdminAllDoctorListsScreen.dart';
import 'package:capscribes/UI/Hospital/dashboard/AllDoctorListsScreen.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:cached_network_image/cached_network_image.dart';



class AdminSingleDoctorProfileScreen extends StatefulWidget {
  const AdminSingleDoctorProfileScreen({super.key});

  @override
  State<AdminSingleDoctorProfileScreen> createState() => _AdminSingleDoctorProfileScreenState();
}

class _AdminSingleDoctorProfileScreenState extends State<AdminSingleDoctorProfileScreen> {
  String? profile_pic;
  _myHandleOnPopMethod(){
    // Navigator.of(context).pushReplacement(
    //   MaterialPageRoute(
    //     builder: (context) => DoctorListsScreen(),
    //   ),
    // );
  }
  @override
  Widget build(BuildContext context) {

    return
      PopScope(
        canPop: false, // prevent default back
        onPopInvoked: (didPop) async {
          if (!didPop) {
            // Replace current screen with another one
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => AdminAllDoctorListsScreen()),
            );
          }
        },
        child: Scaffold(
          appBar: AppBar(
            backgroundColor:  Color(0xffFF9C4B),
            leading: IconButton(
              icon: Icon(
                Icons.arrow_back_ios_new_outlined,
                color: Colors.white,
              ),
              onPressed: () {
                Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(builder: (context) => AdminAllDoctorListsScreen()),
                );
              },
            ),
            title: Text('namme', style: TextStyle(color: Colors.white)),
          ),

          backgroundColor: Colors.white,
          body: Stack(

            children: [
              Container(
                height: 120,
                decoration: BoxDecoration(
                  color:  Color(0xffFF9C4B), // Example background color
                  borderRadius: BorderRadius.only(
                    bottomLeft: Radius.circular(20.0),
                    bottomRight: Radius.circular(20.0),
                  ),
                ), // Example background color
              ),
              SingleChildScrollView(
                child: Center(
                  child: Padding(
                    padding: const EdgeInsets.only(left: 5.0, right: 10.0, top: 30.0, bottom: 0.0),
                    child: Padding(
                      padding: const EdgeInsets.all(10.0),
                      child:
                      Column(
                        children: [
                          Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,

                            children: [
                              Padding(
                                padding: const EdgeInsets.only(bottom: 8.0),
                                child: Row(
                                  mainAxisSize: MainAxisSize.min,
                                  children: [
                                    Icon(Icons.volume_up, size: 25,color: Colors.white,),
                                    SizedBox(width: 2),
                                    Text("42",style: TextStyle(color: Colors.white),),
                                  ],
                                ),
                              ),
                              Center(
                                child:
                                CircleAvatar(
                                  radius: 70,
                                  backgroundColor: Colors.white,
                                  child: ClipOval(
                                    child: profile_pic == null
                                        ? Icon(
                                      Icons.account_circle_rounded,
                                      size: 130,
                                      color: Colors.grey,
                                    )
                                        : CachedNetworkImage(
                                      imageUrl: profile_pic!,
                                      placeholder: (context, url) => Center(
                                        child: Icon(
                                          Icons.account_circle_rounded,
                                          size: 130,
                                          color: Colors.grey,
                                        ),
                                      ),
                                      errorWidget: (context, url, error) => Center(
                                        child: Icon(
                                          Icons.error,
                                          size: 130,
                                          color: Colors.red,
                                        ),
                                      ),
                                      fit: BoxFit.cover,
                                      width: 130,
                                      height: 130,
                                    ),
                                  ),
                                )

                              ),
                              Padding(
                                padding: const EdgeInsets.only(bottom: 8.0),
                                child: Row(
                                  mainAxisSize: MainAxisSize.min,
                                  children: [
                                    Icon(Icons.download, size: 25,color: Colors.white,),
                                    SizedBox(width: 2),
                                    Text("42",style: TextStyle(color: Colors.white),),
                                  ],
                                ),
                              ),
                            ],
                          ),
                          _buildInfoRow(
                            Icon(
                              Icons.manage_accounts,
                              size: 30,
                              color: Colors.black,
                            ),
                            "employeeName",
                          ),
                          _buildInfoRow(
                            Icon(
                              Icons.filter_tilt_shift,
                              size: 30,
                              color: Colors.black,
                            ),
                            "employeeName",
                          ),
                          _buildInfoRow(
                            Icon(
                              Icons.location_on,
                              size: 30,
                              color: Colors.black,
                            ),
                            "employeeName",
                          ),
                          _buildInfoRow(
                            Icon(
                              Icons.call,
                              size: 30,
                              color: Colors.black,
                            ),
                            "employeeName",
                          ),
                          _buildInfoRow(
                            Icon(
                              Icons.mail,
                              size: 30,
                              color: Colors.black,
                            ),
                            "employeeName",
                          ),



                        ],
                      ),

                    ),
                  ),
                ),
              ),
            ],
          ),
        ),
      );
  }

  Widget _buildInfoRow(Icon icon, String text) {
    return Container(
      padding: EdgeInsets.all(10),
      margin: EdgeInsets.symmetric(vertical: 5, horizontal: 10),
      decoration: BoxDecoration(
        border: Border.all(color: Colors.black, width: 2),
        borderRadius: BorderRadius.circular(12),
      ),
      child: Row(
        children: [
          icon,
          SizedBox(width: 15),
          Expanded(
            child: Text(
              text,
              style: TextStyle(
                fontSize: 15,
                color: Colors.black87,
                fontWeight: FontWeight.w500,
              ),
            ),
          ),
        ],
      ),
    );
  }



}
