import 'dart:convert';
import 'dart:io';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:http/http.dart' as http;
import 'package:shared_preferences/shared_preferences.dart';

import '../../../Networking/ApiService.dart';
import '../../../Networking/getAuthHeaders.dart';

class DoctorHomeScreen extends StatefulWidget {
  const DoctorHomeScreen({super.key});

  @override
  State<DoctorHomeScreen> createState() => _DoctorHomeScreenState();
}

class _DoctorHomeScreenState extends State<DoctorHomeScreen> {
  int _selectedToggleIndex = 0;
  final ApiService apiService = ApiService();
  late SharedPreferences sharedPreferences;
  String Firstname="",USERID="",ROLEID="",Pendingfile="",Recivedfile="";
     int  Totalfiles=0;
  @override
  void initState() {
    super.initState();
    initialeclass();
  }
  initialeclass() async {
    sharedPreferences = await SharedPreferences.getInstance();
     Firstname = sharedPreferences.getString("username") ?? '';
    USERID = sharedPreferences.getString("user_id") ?? '';
     ROLEID = sharedPreferences.getString("userRole") ?? '';
    // ROLENAME = sharedPreferences.getString("role_name") ?? '';
     Dashboredapi(0);
  }

  Dashboredapi(int valuefilter)async {
    try {
      final headers = await getAuthHeaders();

      final response = await http.get(Uri.parse(apiService.BaseURL + apiService.Dashbored + "/"+USERID),headers: headers);
      print(apiService.BaseURL + apiService.Dashbored + "/"+USERID);
      if (response.statusCode == 200) {
        // Decode the JSON into a Map
        final Map<String, dynamic> jsonMap = jsonDecode(response.body);

        // Access the 'data' map
        final data = jsonMap['data'];

        // Print the full data
        print("Full Data: $data");

        // Assign individual values to strings

        setState(() {

          if(valuefilter==1){
            Totalfiles = data['week'];
            Pendingfile = data['week_pending'].toString();
            Recivedfile = data['week_received'].toString();

          }else if(valuefilter==2){
            Totalfiles= data['month'];
            Pendingfile = data['month_pending'].toString();
            Recivedfile = data['month_received'].toString();
          } else{
            Totalfiles = data['today'];
            Pendingfile = data['today_pending'].toString();
            Recivedfile = data['today_received'].toString();
          }




        });
        // Print individual values



      } else {
        throw Exception('Failed to load Images');
      }
    } on SocketException {
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch ');
    }  catch (e) {
      print(e);
    }
  }
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: const Color(0xff1F5C93),
      body: SafeArea(
        child: Column(
          children: [
            const SizedBox(height: 20),
            Text.rich(
              TextSpan(
                text: "Welcome ",
                style: const TextStyle(fontSize: 24, color: Colors.white),
                children: [
                  TextSpan(
                    text: Firstname,
                    style: const TextStyle(fontWeight: FontWeight.bold),
                  ),
                ],
              ),
            ),
            const SizedBox(height: 10),
            Padding(
              padding: const EdgeInsets.all(8.0),
              child: Container(
                child: Stack(
                  children: [
                    Padding(
                      padding: const EdgeInsets.symmetric(horizontal: 10),
                      child: ClipPath(
                        clipper: DiagonalBottomLeftClipper(),
                        child: Container(
                          color: Colors.white,
                          padding: const EdgeInsets.all(20),
                          child: Column(
                            children: [
                              SvgPicture.asset(
                                'assets/loginlogo.svg',
                                fit: BoxFit.fitWidth,
                              ),
                              Container(
                                padding: const EdgeInsets.all(4),
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(20),
                                  color: Colors.grey[200],
                                ),
                                child: Row(
                                  mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                                  children: [
                                    buildToggle("Today", _selectedToggleIndex == 0, () {

                                      setState(() => _selectedToggleIndex = 0);
                                      Dashboredapi(0);
                                    }),
                                    buildToggle("Weekly", _selectedToggleIndex == 1, () {
                                      Dashboredapi(1);
                                      setState(() => _selectedToggleIndex = 1);
                                    }),
                                    buildToggle("Monthly", _selectedToggleIndex == 2, () {
                                      Dashboredapi(2);
                                      setState(() => _selectedToggleIndex = 2);
                                    }),
                                  ],
                                ),
                              ),

                              const SizedBox(height: 5),

                              const SizedBox(height: 5),
                              CircularFileIndicator(
                                totalFiles: 10000,
                                completedFiles: Totalfiles,
                              ),

                              buildStatusRow(Pendingfile,Recivedfile),
                              const SizedBox(height: 55),
                            ],
                          ),
                        ),
                      ),
                    ),
                    // Bottom left sort button
                    Positioned(
                      bottom: 0,
                      left: 10,
                      child:
                      Padding(
                        padding: const EdgeInsets.only(top: 14.0),
                        child: ClipPath(
                          clipper: TopRightCutClipper(),
                          child: Material(
                            color: Color(0xff114574),
                            child: InkWell(
                              onTap: () {
                                print("Top-right cut button pressed");
                              },
                              child: Padding(
                                padding: const EdgeInsets.all(3.0),
                                child: Container(
                                  width: 160,
                                  height: 40,
                                  alignment: Alignment.center,
                                  child: Text(
                                    Firstname,
                                    style: TextStyle(color: Colors.white, fontSize: 16),
                                  ),
                                ),
                              ),
                            ),
                          ),
                        ),
                      ),
                    )
                  ],
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  Widget buildStatusRow(String pending,String recived) {
    return Padding(
      padding: const EdgeInsets.symmetric(horizontal: 30.0, vertical: 10),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Column(
            children:  [
              Icon(Icons.volume_up, color: Color(0xFF2D6DA7), size: 30),
              SizedBox(height: 6),
              Text(
                pending,
                style: TextStyle(
                  fontSize: 18,
                  fontWeight: FontWeight.bold,
                  color: Colors.red,
                ),
              ),
              Text(
                "Pending",
                style: TextStyle(fontSize: 12, color: Colors.black),
              ),
            ],
          ),
          Column(
            children:  [
              Icon(Icons.download, color: Color(0xFF2D6DA7), size: 30),
              SizedBox(height: 6),
              Text(
               recived,
                style: TextStyle(
                  fontSize: 18,
                  fontWeight: FontWeight.bold,
                  color: Colors.green,
                ),
              ),
              Text(
                "Received",
                style: TextStyle(fontSize: 12, color: Colors.black),
              ),
            ],
          ),
        ],
      ),
    );
  }
}

Widget buildToggle(String text, bool isActive, VoidCallback onTap) {
  return GestureDetector(
    onTap: onTap,
    child: Container(
      padding: const EdgeInsets.symmetric(horizontal: 20, vertical: 8),
      decoration: BoxDecoration(
        color: isActive ? Color(0xff114574) : Colors.transparent,
        borderRadius: BorderRadius.circular(16),
      ),
      child: Text(
        text,
        style: TextStyle(color: isActive ? Colors.white : Colors.black),
      ),
    ),
  );
}


class DiagonalBottomLeftClipper extends CustomClipper<Path> {
  @override
  @override
  Path getClip(Size size) {
    const double radius = 30;
    const double cutDepth = 50;
    const double cutStartX = 0.55;
    const double cutEndX = 0.45;

    Path path = Path();

    // Top-left corner
    path.moveTo(0, radius);
    path.quadraticBezierTo(0, 0, radius, 0);

    // Top-right corner
    path.lineTo(size.width - radius, 0);
    path.quadraticBezierTo(size.width, 0, size.width, radius);

    // Right side to bottom-right
    path.lineTo(size.width, size.height - radius);
    path.quadraticBezierTo(size.width, size.height, size.width - radius, size.height);

    // Z-shaped slant
    path.lineTo(size.width * cutStartX, size.height);
    path.lineTo(size.width * cutEndX, size.height - cutDepth);
    path.lineTo(radius, size.height - cutDepth);

    // Bottom-left corner with radius
    path.quadraticBezierTo(
      0, size.height - cutDepth,
      0, size.height - cutDepth - radius,
    );

    // Left edge back up
    path.lineTo(0, radius);

    path.close();
    return path;
  }









  @override
  bool shouldReclip(CustomClipper<Path> oldClipper) => false;
}
class CircularFileIndicator extends StatelessWidget {
  final int totalFiles;
  final int completedFiles;

  const CircularFileIndicator({
    super.key,
    required this.totalFiles,
    required this.completedFiles,
  });

  @override
  Widget build(BuildContext context) {
    double progress = completedFiles / totalFiles;
    return Container(
      width: 140,
      height: 140,
      decoration: const BoxDecoration(
        shape: BoxShape.circle,
        boxShadow: [
          BoxShadow(color: Colors.black12, blurRadius: 10, spreadRadius: 2),
        ],
      ),
      child: Stack(
        alignment: Alignment.center,
        children: [
          SizedBox(
            width: 120,
            height: 120,
            child: CircularProgressIndicator(
              value: 1,
              strokeWidth: 12,
              valueColor: AlwaysStoppedAnimation<Color>(Colors.grey.shade400),
            ),
          ),
          SizedBox(
            width: 120,
            height: 120,
            child: CircularProgressIndicator(
              value: progress,
              strokeWidth: 12,
              valueColor: const AlwaysStoppedAnimation<Color>(Color(0xFF2D6DA7)),
              backgroundColor: Colors.transparent,
            ),
          ),
          Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              Text(
                "$completedFiles", // Show completed vs total files
                style: const TextStyle(
                  fontSize: 22,
                  fontWeight: FontWeight.bold,
                ),
              ),
              const SizedBox(height: 4),
              const Text(
                "Files",
                style: TextStyle(fontSize: 16, color: Colors.blueAccent),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
class TopRightCutClipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) {
    const double radius = 13;
    const double cutSize = 30; // Increased cut length/height
    const double cutHeight = 35; // Increased cut height

    Path path = Path();

    // Top-left corner (rounded)
    path.moveTo(0, radius);
    path.quadraticBezierTo(0, 0, radius, 0);

    // Top-right cut (increased size)
    path.lineTo(size.width - cutSize, 0);
    path.lineTo(size.width, cutHeight); // Increased cut height here

    // Right side - bottom-right corner
    path.lineTo(size.width, size.height - radius);
    path.quadraticBezierTo(size.width, size.height, size.width - radius, size.height);

    // Bottom-left corner
    path.lineTo(radius, size.height);
    path.quadraticBezierTo(0, size.height, 0, size.height - radius);

    path.close();
    return path;
  }

  @override
  bool shouldReclip(CustomClipper<Path> oldClipper) => false;
}

