import 'dart:convert';
import 'dart:io';

import 'package:capscribes/UI/Hospital/dashboard/AllDoctorListsScreen.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:http/http.dart' as http;
import 'package:shared_preferences/shared_preferences.dart';

import '../../../Networking/ApiService.dart';
import '../../../Networking/getAuthHeaders.dart';
import '../../Admin/dashboard/AdminAllDoctorListsScreen.dart';


class HospitalSingleDoctorProfileScreen extends StatefulWidget {
  final String DoctorID,DoctorName;
  const HospitalSingleDoctorProfileScreen({super.key, required this.DoctorID,required this.DoctorName});

  @override
  State<HospitalSingleDoctorProfileScreen> createState() => _HospitalSingleDoctorProfileScreenState();
}

class _HospitalSingleDoctorProfileScreenState extends State<HospitalSingleDoctorProfileScreen> {
  String? profile_pic;

  final ApiService apiService = ApiService();
  late SharedPreferences sharedPreferences;
  String Firstname="",USERID="",ROLEID="",selectdoctor="",name="",role="",experience="",email="",hospital="",mobile="",upload="",download="";


  @override
  void initState() {
    super.initState();
    initialeclass();
  }

  // Initialize class and fetch doctor data
  initialeclass() async {
    sharedPreferences = await SharedPreferences.getInstance();
    Firstname = sharedPreferences.getString("username") ?? '';
    USERID = sharedPreferences.getString("user_id") ?? '';

print(ROLEID);

setState(() {
  ROLEID = sharedPreferences.getString("userRole") ?? '';
  doctorprofile();

});

  }


  doctorprofile() async {
    try {
      final headers = await getAuthHeaders();

      final Uri url = Uri.parse(apiService.BaseURL + apiService.DOCTORDETAILS).replace(
        queryParameters: {
          'doctor_id': widget.DoctorID,
        },
      );

      print("GET Request URL: $url");

      final response = await http.get(
        url,
          headers: headers
      );

      if (response.statusCode == 200) {
        final decoded = json.decode(response.body);
        final doctorData = decoded;  // Doctor data from the API response

        // Extract doctor profile details
        setState(() {
          name = doctorData['name'] ?? '';
          role = doctorData['role'] ?? '';
          upload = doctorData['pending'] ?? '';
          download = doctorData['upload'] ?? '';
          email = doctorData['email'] ?? '';
          hospital = doctorData['hospital'] ?? '';
          profile_pic = doctorData['profile'] ?? null;
          mobile = doctorData['mobile_number'] ?? '';
        });

      } else {
        setState(() {

        });
        throw Exception('Failed to load doctor details');
      }
    } on SocketException {
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch');
    } catch (e) {
      print("Error: $e");
      throw Exception('An error occurred: $e');
    }
  }

  _myHandleOnPopMethod(){
    // Navigator.of(context).pushReplacement(
    //   MaterialPageRoute(
    //     builder: (context) => DoctorListsScreen(),
    //   ),
    // );
  }
  Color getBackgroundColor(String roleId) {
    switch (roleId) {
      case "2": // Admin
        return Color(0xffC85D06);
      case "4": // Doctor
        return Color(0xff1F5C93); // Greenish
      case "5": // Hospital
        return Color(0xff004D40); // Purple
      default:
        return Colors.grey; // Default or unknown
    }
  }
  Color getRoleColor(String roleId) {
    switch (roleId) {
      case "2": // Admin
        return Color(0xffC85D06);
      case "4": // Doctor
        return Color(0xff1F5C93);
      case "5": // Hospital
        return Color(0xff004D40);
      default:
        return Colors.grey;
    }
  }


  @override
  Widget build(BuildContext context) {

    return
      PopScope(
        canPop: false, // prevent default back
        onPopInvoked: (didPop) async {
          if (!didPop) {
            // Replace current screen with another one

            switch (ROLEID) {
              case "2":
                Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(builder: (context) => AdminAllDoctorListsScreen()),
                );
                break;
              case "5":
                Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(builder: (context) => AllDoctorListsScreen()),
                );
                break;
              default:
              // Handle unknown ROLEID or do nothing
                break;
            }

          }
        },
        child: Scaffold(
          appBar: AppBar(
            backgroundColor: getBackgroundColor(ROLEID),
            leading: IconButton(
              icon: Icon(
                Icons.arrow_back_ios_new_outlined,
                color: Colors.white,
              ),
              onPressed: () {



                switch (ROLEID) {
                  case "2":
                    Navigator.pushReplacement(
                      context,
                      MaterialPageRoute(builder: (context) => AdminAllDoctorListsScreen()),
                    );
                    break;
                  case "5":
                    Navigator.pushReplacement(
                      context,
                      MaterialPageRoute(builder: (context) => AllDoctorListsScreen()),
                    );
                    break;
                  default:
                  // Handle unknown ROLEID or do nothing
                    break;
                }

              },
            ),
            title: Text(widget.DoctorName, style: TextStyle(color: Colors.white)),
          ),

          backgroundColor: Colors.white,
          body:
          Stack(
            children: [
              Container(
                height: 120,
                decoration: BoxDecoration(
                  color:  getRoleColor(ROLEID),
                  borderRadius: BorderRadius.only(
                    bottomLeft: Radius.circular(20.0),
                    bottomRight: Radius.circular(20.0),
                  ),
                ),
              ),
              SingleChildScrollView(
                child: Center(
                  child: Padding(
                    padding: const EdgeInsets.only(left: 5.0, right: 10.0, top: 30.0, bottom: 0.0),
                    child: Padding(
                      padding: const EdgeInsets.all(10.0),
                      child: Column(
                        children: [
                          Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Padding(
                                padding: const EdgeInsets.only(bottom: 8.0),
                                child: Row(
                                  mainAxisSize: MainAxisSize.min,
                                  children: [
                                    Icon(Icons.volume_up, size: 25, color: Colors.white),
                                    SizedBox(width: 2),
                                    Text(upload, style: TextStyle(color: Colors.white)),
                                  ],
                                ),
                              ),
                              Center(
                                child: CircleAvatar(
                                  radius: 70,
                                  backgroundColor: Colors.white,
                                  child: ClipOval(
                                    child: profile_pic == null
                                        ? Icon(
                                      Icons.account_circle_rounded,
                                      size: 130,
                                      color: Colors.grey,
                                    )
                                        : Image.network(
                                      profile_pic!,
                                      fit: BoxFit.cover,
                                      width: 130,
                                      height: 130,
                                      loadingBuilder: (context, child, loadingProgress) {
                                        if (loadingProgress == null) return child;
                                        return Center(
                                          child: Icon(
                                            Icons.account_circle_rounded,
                                            size: 130,
                                            color: Colors.grey,
                                          ),
                                        );
                                      },
                                      errorBuilder: (context, error, stackTrace) => Center(
                                        child: Icon(
                                          Icons.error,
                                          size: 130,
                                          color: Colors.red,
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              ),


                              Padding(
                                padding: const EdgeInsets.only(bottom: 8.0),
                                child: Row(
                                  mainAxisSize: MainAxisSize.min,
                                  children: [
                                    Icon(Icons.download, size: 25, color: Colors.white),
                                    SizedBox(width: 2),
                                    Text(download, style: TextStyle(color: Colors.white)),
                                  ],
                                ),
                              ),
                            ],
                          ),
                          _buildInfoRow(Icon(Icons.manage_accounts, size: 30, color: Colors.black), name),
                          _buildInfoRow(Icon(Icons.filter_tilt_shift, size: 30, color: Colors.black), role),
                          _buildInfoRow(Icon(Icons.location_on, size: 30, color: Colors.black), hospital),
                          _buildInfoRow(Icon(Icons.call, size: 30, color: Colors.black), mobile),  // You can replace with actual phone number field
                          _buildInfoRow(Icon(Icons.mail, size: 30, color: Colors.black), email),
                        ],
                      ),
                    ),
                  ),
                ),
              ),
            ],
          )

        ),
      );
  }

  Widget _buildInfoRow(Icon icon, String text) {
    return Container(
      padding: EdgeInsets.all(10),
      margin: EdgeInsets.symmetric(vertical: 5, horizontal: 10),
      decoration: BoxDecoration(
        border: Border.all(color: Colors.black, width: 2),
        borderRadius: BorderRadius.circular(12),
      ),
      child: Row(
        children: [
          icon,
          SizedBox(width: 15),
          Expanded(
            child: Text(
              text,
              style: TextStyle(
                fontSize: 15,
                color: Colors.black87,
                fontWeight: FontWeight.w500,
              ),
            ),
          ),
        ],
      ),
    );
  }



}
