import 'package:animated_bottom_navigation_bar/animated_bottom_navigation_bar.dart';
import 'package:capscribes/UI/Admin/dashboard/AdminFileScreen.dart';
import 'package:capscribes/UI/Hospital/dashboard/HospitalFileScreen.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';

import 'TrasnscrpitFileScreen.dart';
import 'TrasnscrpitNotificationScreen.dart';
import 'TrasnscrpitProfileScreen.dart';



class TranscrpitDashboardScreen extends StatefulWidget {
  const TranscrpitDashboardScreen({super.key});

  @override
  State<TranscrpitDashboardScreen> createState() => _TranscrpitDashboardScreenState();
}

class _TranscrpitDashboardScreenState extends State<TranscrpitDashboardScreen> {
  int _currentIndex = 0;

  final List<Widget> _screens = [
    TrasnscrpitFileScreen(),
    TrasnscrpitNotificationScreen(),
    TrasnscrpitProfileScreen(),
  ];
  final List<String> labels = [

    'Files',
    'Notifications',
    'Profile',
  ];


  final iconList = <IconData>[
    Icons.file_copy_rounded,
    Icons.notifications_outlined,
    Icons.person,
  ];

  Future<bool> _onExitRequested() async {
    final shouldExit = await showDialog<bool>(
      context: context,
      builder: (context) => AlertDialog(
        title: Text('Exit App?'),
        content: Text('Do you really want to exit the app?'),
        actions: [
          TextButton(
            onPressed: () => Navigator.of(context).pop(false),
            child: Text('Cancel'),
          ),
          TextButton(
            onPressed: () => Navigator.of(context).pop(true),
            child: Text('Exit'),
          ),
        ],
      ),
    );

    return shouldExit ?? false;
  }

  @override
  Widget build(BuildContext context) {
    SystemChrome.setSystemUIOverlayStyle(
      SystemUiOverlayStyle(
        statusBarColor: Color(0xffb3b300), // Change status bar color here
        statusBarIconBrightness: Brightness.light, // White icons
      ),
    );
    return PopScope(
      canPop: false,
      onPopInvoked: (didPop) async {
        if (didPop) return;
        final shouldExit = await _onExitRequested();
        if (shouldExit && mounted) {
          SystemNavigator.pop();
        }
      },
      child: Scaffold(
        backgroundColor: Color(0xffb3b300),
        body: _screens[_currentIndex],



        // Animated bottom navigation bar
        bottomNavigationBar: BottomNavigationBar(
          currentIndex: _currentIndex,
          onTap: (index) => setState(() => _currentIndex = index),
          backgroundColor: Color(0xffb3b300),
          selectedItemColor: Colors.white,
          unselectedItemColor: Colors.white70,
          type: BottomNavigationBarType.fixed,
          items: [
            BottomNavigationBarItem(
              icon: Icon(Icons.file_copy_rounded,size: 15,),
              label: 'Files',
            ),
            BottomNavigationBarItem(
              icon: Icon(Icons.notifications_outlined,size: 15,),
              label: 'Notifications',
            ),
            BottomNavigationBarItem(
              icon: Icon(Icons.person,size: 15,),
              label: 'Profile',
            ),
          ],
        ),

      ),
    );
  }
}


